/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.collections.Pair;
import org.testng.log4testng.Logger;
import org.testng.xml.dom.ITagFactory;
import org.testng.xml.dom.ITagSetter;
import org.testng.xml.dom.ParentSetter;
import org.testng.xml.dom.Reflect;
import org.testng.xml.dom.TagContent;
import org.testng.xml.dom.Wrapper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XDom {
    private Document m_document;
    private ITagFactory m_tagFactory;
    private static final Logger LOGGER = Logger.getLogger(XDom.class);

    public XDom(ITagFactory tagFactory, Document document) {
        this.m_tagFactory = tagFactory;
        this.m_document = document;
    }

    public Object parse() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, InvocationTargetException {
        Object result = null;
        NodeList nodes = this.m_document.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (item.getAttributes() == null) continue;
            String nodeName = item.getNodeName();
            System.out.println("Node name:" + nodeName);
            Class<?> c = this.m_tagFactory.getClassForTag(nodeName);
            if (c == null) {
                throw new RuntimeException("No class found for tag " + nodeName);
            }
            result = c.newInstance();
            this.populateAttributes(item, result);
            if (ITagSetter.class.isAssignableFrom(result.getClass())) {
                throw new RuntimeException("TAG SETTER");
            }
            this.populateChildren(item, result);
        }
        return result;
    }

    public void populateChildren(Node root, Object result) throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, InvocationTargetException {
        this.p("populateChildren: " + root.getLocalName());
        NodeList childNodes = root.getChildNodes();
        ListMultiMap<String, Object> children = Maps.newListMultiMap();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Class<?> c;
            Node item = childNodes.item(i);
            if (item.getAttributes() == null) continue;
            String nodeName = item.getNodeName();
            if ("suite-files".equals(nodeName)) {
                System.out.println("BREAK");
            }
            if ((c = this.m_tagFactory.getClassForTag(nodeName)) == null) {
                System.out.println("Warning: No class found for tag " + nodeName);
                boolean foundSetter = this.invokeOnSetter(result, (Element)item, nodeName, null);
                System.out.println("  found setter:" + foundSetter);
                continue;
            }
            Object object = this.instantiateElement(c, result);
            if (ITagSetter.class.isAssignableFrom(object.getClass())) {
                System.out.println("Tag setter:" + result);
                ((ITagSetter)object).setProperty(nodeName, result, item);
            } else {
                children.put(nodeName, object);
                this.populateAttributes(item, object);
                this.populateContent(item, object);
            }
            this.populateChildren(item, object);
        }
    }

    private Object instantiateElement(Class<?> c, Object parent) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object result;
        Method m = this.findMethodAnnotatedWith(c, ParentSetter.class);
        if (m != null) {
            result = c.newInstance();
            m.invoke(result, parent);
        } else {
            try {
                result = c.getConstructor(parent.getClass()).newInstance(parent);
            }
            catch (NoSuchMethodException ex) {
                result = c.newInstance();
            }
        }
        return result;
    }

    private Method findMethodAnnotatedWith(Class<?> c, Class<? extends Annotation> annotation) {
        for (Method m : c.getMethods()) {
            if (m.getAnnotation(annotation) == null) continue;
            return m;
        }
        return null;
    }

    private void populateContent(Node item, Object object) {
        for (int i = 0; i < item.getChildNodes().getLength(); ++i) {
            Node child = item.getChildNodes().item(i);
            if (!(child instanceof Text)) continue;
            this.setText(object, (Text)child);
        }
    }

    private void setText(Object bean, Text child) {
        List<Pair<Method, Wrapper>> pairs = Reflect.findMethodsWithAnnotation(bean.getClass(), TagContent.class, bean);
        for (Pair<Method, Wrapper> pair : pairs) {
            try {
                pair.first().invoke(bean, child.getTextContent());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | DOMException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    private boolean invokeOnSetter(Object object, Element element, String nodeName, Object bean) {
        Pair<Method, Wrapper> pair = Reflect.findSetterForTag(object.getClass(), nodeName, bean);
        if (pair != null) {
            Method m = pair.first();
            try {
                List<Object> allParameters;
                if (pair.second() != null) {
                    allParameters = pair.second().getParameters(element);
                } else {
                    allParameters = Lists.newArrayList();
                    allParameters.add(new Object[]{bean});
                }
                for (Object[] objectArray : allParameters) {
                    m.invoke(object, objectArray);
                }
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return false;
    }

    private void populateAttributes(Node node, Object object) {
        for (int j = 0; j < node.getAttributes().getLength(); ++j) {
            Node item = node.getAttributes().item(j);
            this.setProperty(object, item.getLocalName(), item.getNodeValue());
        }
    }

    private void setProperty(Object object, String name, Object value) {
        block6: {
            Pair<Method, Wrapper> setter = Reflect.findSetterForTag(object.getClass(), name, value);
            if (setter != null) {
                Method foundMethod = setter.first();
                try {
                    Class<?> type = foundMethod.getParameterTypes()[0];
                    if (type == Boolean.class || type == Boolean.TYPE) {
                        foundMethod.invoke(object, Boolean.parseBoolean(value.toString()));
                        break block6;
                    }
                    if (type == Integer.class || type == Integer.TYPE) {
                        foundMethod.invoke(object, Integer.parseInt(value.toString()));
                        break block6;
                    }
                    foundMethod.invoke(object, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            } else {
                this.e("Couldn't find setter method for property" + name + " on " + object.getClass());
            }
        }
    }

    private void p(String string) {
        System.out.println("[XDom] " + string);
    }

    private void e(String string) {
        System.out.println("[XDom] [Error] " + string);
    }
}

