/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.hal;

import javax.json.JsonObject;

public final class Link {
    private final String href;
    private final Boolean templated;
    private final String type;
    private final String deprecation;
    private final String name;
    private final String profile;
    private final String title;
    private final String hreflang;

    Link(String href, Boolean templated, String type, String deprecation, String name, String profile, String title, String hreflang) {
        this.href = href;
        this.templated = templated;
        this.type = type;
        this.deprecation = deprecation;
        this.name = name;
        this.profile = profile;
        this.title = title;
        this.hreflang = hreflang;
        if (href.isEmpty()) {
            throw new IllegalArgumentException("The href property is mandatory.");
        }
    }

    public String getHref() {
        return this.href;
    }

    public boolean isTemplated() {
        return this.templated != null ? this.templated : false;
    }

    public String getType() {
        return this.type;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public String getName() {
        return this.name;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    static Link fromJson(JsonObject json) {
        String href = null;
        if (json.containsKey((Object)"href")) {
            href = json.getString("href");
        }
        Boolean templated = null;
        if (json.containsKey((Object)"templated")) {
            templated = json.getBoolean("templated");
        }
        String type = null;
        if (json.containsKey((Object)"type")) {
            type = json.getString("type");
        }
        String deprecation = null;
        if (json.containsKey((Object)"deprecation")) {
            deprecation = json.getString("deprecation");
        }
        String name = null;
        if (json.containsKey((Object)"name")) {
            name = json.getString("name");
        }
        String profile = null;
        if (json.containsKey((Object)"profile")) {
            profile = json.getString("profile");
        }
        String title = null;
        if (json.containsKey((Object)"title")) {
            title = json.getString("title");
        }
        String hreflang = null;
        if (json.containsKey((Object)"hreflang")) {
            hreflang = json.getString("hreflang");
        }
        return new Link(href, templated, type, deprecation, name, profile, title, hreflang);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deprecation == null ? 0 : this.deprecation.hashCode());
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + (this.hreflang == null ? 0 : this.hreflang.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        result = 31 * result + (this.templated == null ? 0 : this.templated.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.deprecation == null ? other.deprecation != null : !this.deprecation.equals(other.deprecation)) {
            return false;
        }
        if (!this.href.equals(other.href)) {
            return false;
        }
        if (this.hreflang == null ? other.hreflang != null : !this.hreflang.equals(other.hreflang)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.profile == null ? other.profile != null : !this.profile.equals(other.profile)) {
            return false;
        }
        if (this.templated == null ? other.templated != null : !this.templated.equals(other.templated)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Link [href=").append(this.href);
        if (this.templated != null) {
            sb.append(", templated=").append(this.templated);
        }
        if (this.type != null) {
            sb.append(", type=").append(this.type);
        }
        if (this.deprecation != null) {
            sb.append(", deprecation").append(this.deprecation);
        }
        if (this.name != null) {
            sb.append(", name=").append(this.name);
        }
        if (this.profile != null) {
            sb.append(", profile=").append(this.profile);
        }
        if (this.title != null) {
            sb.append(", title=").append(this.title);
        }
        if (this.hreflang != null) {
            sb.append(", hreflang=").append(this.hreflang);
        }
        return sb.append("]").toString();
    }
}

