/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConverter {
    private static final String UTF8 = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";

    public static UrlEncodedFormEntity mapToUrlEncodedFormEntity(Map<String, String> map) {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        for (String key : map.keySet()) {
            urlParameters.add(new BasicNameValuePair(key, map.get(key)));
        }
        try {
            return new UrlEncodedFormEntity(urlParameters, CharsetUtils.get((String)UTF8));
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static StringEntity jsonToStringEntity(JsonObject jsonObject) {
        return new StringEntity(jsonObject.toString(), ContentType.create((String)APPLICATION_JSON, (String)UTF8));
    }

    public static String entityToString(HttpEntity entity) throws ParseException, IOException {
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity, (String)UTF8);
    }
}

