/*
 * Decompiled with CFR 0.152.
 */
package com.smallsoho.mcplugin.image;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.tasks.MergeResources;
import com.smallsoho.mcplugin.image.Config;
import com.smallsoho.mcplugin.image.ImagePlugin;
import com.smallsoho.mcplugin.image.interface.IBigImage;
import com.smallsoho.mcplugin.image.utils.CompressUtil;
import com.smallsoho.mcplugin.image.utils.FileUtil;
import com.smallsoho.mcplugin.image.utils.ImageUtil;
import com.smallsoho.mcplugin.image.utils.LogUtil;
import com.smallsoho.mcplugin.image.utils.Tools;
import com.smallsoho.mcplugin.image.webp.WebpUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J0\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020 0\u0005j\b\u0012\u0004\u0012\u00020 `\u00072\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00182\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020 0\u0005j\b\u0012\u0004\u0012\u00020 `\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\u0006H\u0002JH\u0010'\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020 0\u0005j\b\u0012\u0004\u0012\u00020 `\u00072\u0016\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\"\u001a\u00020#H\u0002R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/smallsoho/mcplugin/image/ImagePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "bigImgList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getBigImgList", "()Ljava/util/ArrayList;", "isContainAssembleTask", "", "()Z", "setContainAssembleTask", "(Z)V", "isDebugTask", "setDebugTask", "mcImageConfig", "Lcom/smallsoho/mcplugin/image/Config;", "mcImageProject", "newSize", "", "oldSize", "apply", "", "project", "checkBigImage", "checkMcTools", "countNewSize", "path", "filterImage", "file", "Ljava/io/File;", "imageFileList", "iBigImage", "Lcom/smallsoho/mcplugin/image/interface/IBigImage;", "mtDispatchOptimizeTask", "optimizeImage", "sizeInfo", "traverseResDir", "cacheList", "McImage"})
public final class ImagePlugin
implements Plugin<Project> {
    private Project mcImageProject;
    private Config mcImageConfig;
    private long oldSize;
    private long newSize;
    @NotNull
    private final ArrayList<String> bigImgList = new ArrayList();
    private boolean isDebugTask;
    private boolean isContainAssembleTask;

    @NotNull
    public final ArrayList<String> getBigImgList() {
        return this.bigImgList;
    }

    public final boolean isDebugTask() {
        return this.isDebugTask;
    }

    public final void setDebugTask(boolean bl) {
        this.isDebugTask = bl;
    }

    public final boolean isContainAssembleTask() {
        return this.isContainAssembleTask;
    }

    public final void setContainAssembleTask(boolean bl) {
        this.isContainAssembleTask = bl;
    }

    public void apply(@NotNull Project project) {
        DomainObjectSet domainObjectSet;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.mcImageProject = project;
        boolean hasAppPlugin = project.getPlugins().hasPlugin("com.android.application");
        if (hasAppPlugin) {
            object = project.property("android");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
            }
            domainObjectSet = ((AppExtension)object).getApplicationVariants();
        } else {
            object = project.property("android");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.LibraryExtension");
            }
            domainObjectSet = (DomainObjectSet)((LibraryExtension)object).getLibraryVariants();
        }
        DomainObjectSet variants = domainObjectSet;
        project.getExtensions().create("McImageConfig", Config.class, new Object[0]);
        object = project.property("McImageConfig");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.smallsoho.mcplugin.image.Config");
        }
        this.mcImageConfig = (Config)object;
        project.getGradle().getTaskGraph().whenReady(arg_0 -> ImagePlugin.apply$lambda-1(this, arg_0));
        project.afterEvaluate(arg_0 -> ImagePlugin.apply$lambda-2(variants, this, project, arg_0));
    }

    private final void traverseResDir(File file, ArrayList<File> imageFileList, ArrayList<String> cacheList, IBigImage iBigImage) {
        if (cacheList.contains(file.getAbsolutePath())) {
            return;
        }
        cacheList.add(file.getAbsolutePath());
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (it.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.traverseResDir(it, imageFileList, cacheList, iBigImage);
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.filterImage(it, imageFileList, iBigImage);
                }
            }
        } else {
            this.filterImage(file, imageFileList, iBigImage);
        }
    }

    private final void filterImage(File file, ArrayList<File> imageFileList, IBigImage iBigImage) {
        block14: {
            Object object;
            Config config;
            block13: {
                block12: {
                    config = this.mcImageConfig;
                    if (config == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                        throw null;
                    }
                    object = config.whiteList;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mcImageConfig.whiteList");
                    if (ArraysKt.contains((Object[])object, (Object)file.getName()) || !ImageUtil.Companion.isImage(file)) {
                        return;
                    }
                    object = this.mcImageConfig;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                        throw null;
                    }
                    if (!object.isCheckSize) break block12;
                    object = this.mcImageConfig;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                        throw null;
                    }
                    if (ImageUtil.Companion.isBigSizeImage(file, object.maxSize)) break block13;
                }
                if ((object = this.mcImageConfig) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                    throw null;
                }
                if (!object.isCheckPixels) break block14;
                object = this.mcImageConfig;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                    throw null;
                }
                object = this.mcImageConfig;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                    throw null;
                }
                if (!ImageUtil.Companion.isBigPixelImage(file, object.maxWidth, object.maxHeight)) break block14;
            }
            if ((config = this.mcImageConfig) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                throw null;
            }
            object = config.bigImageWhiteList;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mcImageConfig.bigImageWhiteList");
            if (!ArraysKt.contains((Object[])object, (Object)file.getName())) {
                iBigImage.onBigImage(file);
            }
        }
        imageFileList.add(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void mtDispatchOptimizeTask(ArrayList<File> imageFileList) {
        int coreNum;
        block13: {
            block12: {
                if (imageFileList.size() == 0) return;
                Collection collection = this.bigImgList;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return;
                }
                boolean bl2 = false;
                if (bl2) {
                    return;
                }
                coreNum = Runtime.getRuntime().availableProcessors();
                if (imageFileList.size() < coreNum) break block12;
                Config config = this.mcImageConfig;
                if (config == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                    throw null;
                }
                if (config.multiThread) break block13;
            }
            Iterator<File> iterator = imageFileList.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                this.optimizeImage(file);
            }
            return;
        }
        ArrayList<Future<Unit>> results = new ArrayList<Future<Unit>>();
        ExecutorService pool = Executors.newFixedThreadPool(coreNum);
        int part = imageFileList.size() / coreNum;
        int n = 0;
        if (n < coreNum) {
            do {
                int n2 = n++;
                int from = n2 * part;
                int to = n2 == coreNum - 1 ? imageFileList.size() - 1 : (n2 + 1) * part - 1;
                results.add(pool.submit(() -> ImagePlugin.mtDispatchOptimizeTask$lambda-4(from, to, this, imageFileList)));
            } while (n < coreNum);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            try {
                future.get();
            }
            catch (Exception exception) {}
        }
    }

    private final void optimizeImage(File file) {
        Config config;
        Object object = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.path");
        String path = object;
        if (new File(path).exists()) {
            object = this;
            ((ImagePlugin)object).oldSize += new File(path).length();
        }
        if ((config = this.mcImageConfig) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
            throw null;
        }
        object = config.optimizeType;
        if (Intrinsics.areEqual((Object)object, (Object)"ConvertWebp")) {
            config = this.mcImageConfig;
            if (config == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                throw null;
            }
            Config config2 = config;
            config = this.mcImageProject;
            if (config == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageProject");
                throw null;
            }
            WebpUtils.Companion.securityFormatWebp(file, config2, (Project)config);
        } else if (Intrinsics.areEqual((Object)object, (Object)"Compress")) {
            CompressUtil.Companion.compressImg(file);
        }
        this.countNewSize(path);
    }

    private final void countNewSize(String path) {
        if (new File(path).exists()) {
            ImagePlugin imagePlugin = this;
            imagePlugin.newSize += new File(path).length();
        } else {
            int indexOfDot = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null);
            Object object = path;
            int n = 0;
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(n, indexOfDot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String webpPath = Intrinsics.stringPlus((String)string2, (Object)".webp");
            if (new File(webpPath).exists()) {
                object = this;
                ((ImagePlugin)object).newSize += new File(webpPath).length();
            } else {
                LogUtil.Companion.log("McImage: optimizeImage have some Exception!!!");
            }
        }
    }

    private final void checkBigImage() {
        if (this.bigImgList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("You have big Imgages with big size or large pixels,please confirm whether they are necessary or whether they can to be compressed. If so, you can config them into bigImageWhiteList to fix this Exception!!!\n");
            int n = 0;
            int n2 = this.bigImgList.size();
            if (n < n2) {
                do {
                    int i = n++;
                    stringBuffer.append(this.bigImgList.get(i));
                    stringBuffer.append("\n");
                } while (n < n2);
            }
            throw new GradleException(stringBuffer.toString());
        }
    }

    private final void checkMcTools(Project project) {
        Config config = this.mcImageConfig;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
            throw null;
        }
        String string = config.mctoolsDir;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mcImageConfig.mctoolsDir");
        if (StringsKt.isBlank((CharSequence)string)) {
            string = project.getRootDir().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.rootDir.path");
            FileUtil.INSTANCE.setRootDir(string);
        } else {
            config = this.mcImageConfig;
            if (config == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                throw null;
            }
            string = config.mctoolsDir;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mcImageConfig.mctoolsDir");
            FileUtil.INSTANCE.setRootDir(string);
        }
        if (!FileUtil.INSTANCE.getToolsDir().exists()) {
            throw new GradleException("You need put the mctools dir in project root");
        }
    }

    private final String sizeInfo() {
        return "->>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\nbefore McImage optimize: " + this.oldSize / (long)1024 + "KB\nafter McImage optimize: " + this.newSize / (long)1024 + "KB\nMcImage optimize size: " + (this.oldSize - this.newSize) / (long)1024 + "KB\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<-";
    }

    private static final void apply$lambda-1(ImagePlugin this$0, TaskExecutionGraph it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List list = it.getAllTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.allTasks");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Task task = (Task)element$iv;
            boolean bl = false;
            String taskName = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)taskName, (String)"taskName");
            if (!StringsKt.contains$default((CharSequence)taskName, (CharSequence)"assemble", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)taskName, (CharSequence)"resguard", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)taskName, (CharSequence)"bundle", (boolean)false, (int)2, null)) continue;
            String string = taskName;
            boolean bl2 = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            if (StringsKt.endsWith$default((String)string2, (String)"debug", (boolean)false, (int)2, null)) {
                string = taskName;
                bl2 = false;
                String string3 = string.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"debug", (boolean)false, (int)2, null)) {
                    this$0.setDebugTask(true);
                }
            }
            this$0.setContainAssembleTask(true);
        }
    }

    private static final void apply$lambda-2(DomainObjectSet $variants, ImagePlugin this$0, Project $project, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $variants.all(new Action(this$0, $project){
            final /* synthetic */ ImagePlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public final void execute(Object variant) {
                if (variant == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.internal.api.BaseVariantImpl");
                }
                BaseVariantImpl cfr_ignored_0 = (BaseVariantImpl)variant;
                ImagePlugin.access$checkMcTools(this.this$0, this.$project);
                MergeResources mergeResourcesTask = (MergeResources)((BaseVariantImpl)variant).getMergeResourcesProvider().get();
                String string = ((BaseVariantImpl)variant).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
                Task mcPicTask = this.$project.task(Intrinsics.stringPlus((String)"McImage", (Object)StringsKt.capitalize((String)string)));
                mcPicTask.doLast(arg_0 -> apply.2.1.execute$lambda-0(this.this$0, variant, arg_0));
                String string2 = ((BaseVariantImpl)variant).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
                String chmodTaskName = Intrinsics.stringPlus((String)"chmod", (Object)StringsKt.capitalize((String)string2));
                Task chmodTask = this.$project.task(chmodTaskName);
                chmodTask.doLast(apply.2.1::execute$lambda-1);
                Object[] objectArray = this.$project.getTasks().findByName(chmodTask.getName());
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.Task");
                }
                Task task = (Task)objectArray;
                objectArray = new Object[]{mergeResourcesTask.getTaskDependencies().getDependencies((Task)mergeResourcesTask)};
                task.dependsOn(objectArray);
                objectArray = this.$project.getTasks().findByName(mcPicTask.getName());
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.Task");
                }
                Task task2 = (Task)objectArray;
                objectArray = new Object[1];
                Object object = this.$project.getTasks().findByName(chmodTask.getName());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.Task");
                }
                objectArray[0] = (Task)object;
                task2.dependsOn(objectArray);
                objectArray = new Object[]{this.$project.getTasks().findByName(mcPicTask.getName())};
                mergeResourcesTask.dependsOn(objectArray);
            }

            private static final void execute$lambda-0(ImagePlugin this$0, Object $variant, Task it) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (this$0.isDebugTask()) {
                    object = ImagePlugin.access$getMcImageConfig$p(this$0);
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                        throw null;
                    }
                    if (!((Config)object).enableWhenDebug) {
                        LogUtil.Companion.log("Debug not run ^_^");
                        return;
                    }
                }
                if (!this$0.isContainAssembleTask()) {
                    LogUtil.Companion.log("Don't contain assemble task, mcimage passed");
                    return;
                }
                LogUtil.Companion.log("---- McImage Plugin Start ----");
                Config config = ImagePlugin.access$getMcImageConfig$p(this$0);
                if (config == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mcImageConfig");
                    throw null;
                }
                object = config.toString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mcImageConfig.toString()");
                LogUtil.Companion.log((String)object);
                Set dir = ((BaseVariantImpl)$variant).getAllRawAndroidResources().getFiles();
                ArrayList<E> cacheList = new ArrayList<E>();
                ArrayList<E> imageFileList = new ArrayList<E>();
                for (E e : dir) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"dir");
                    File channelDir = (File)e;
                    ImagePlugin.access$traverseResDir(this$0, channelDir, imageFileList, cacheList, new IBigImage(this$0){
                        final /* synthetic */ ImagePlugin this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onBigImage(@NotNull File file) {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            this.this$0.getBigImgList().add(file.getAbsolutePath());
                        }
                    });
                }
                ImagePlugin.access$checkBigImage(this$0);
                long start = System.currentTimeMillis();
                ImagePlugin.access$mtDispatchOptimizeTask(this$0, imageFileList);
                LogUtil.Companion.log(ImagePlugin.access$sizeInfo(this$0));
                LogUtil.Companion.log(Intrinsics.stringPlus((String)"---- McImage Plugin End ----, Total Time(ms) : ", (Object)(System.currentTimeMillis() - start)));
            }

            private static final void execute$lambda-1(Task it) {
                if (Tools.Companion.isLinux()) {
                    Tools.Companion.chmod();
                }
            }
        });
    }

    private static final Unit mtDispatchOptimizeTask$lambda-4(int $from, int $to, ImagePlugin this$0, ArrayList $imageFileList) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$imageFileList, (String)"$imageFileList");
        int n = $from;
        if (n <= $to) {
            int index;
            do {
                index = n++;
                Object e = $imageFileList.get(index);
                Intrinsics.checkNotNullExpressionValue(e, (String)"imageFileList[index]");
                this$0.optimizeImage((File)e);
            } while (index != $to);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$checkMcTools(ImagePlugin $this, Project project) {
        $this.checkMcTools(project);
    }

    public static final /* synthetic */ Config access$getMcImageConfig$p(ImagePlugin $this) {
        return $this.mcImageConfig;
    }

    public static final /* synthetic */ void access$traverseResDir(ImagePlugin $this, File file, ArrayList imageFileList, ArrayList cacheList, IBigImage iBigImage) {
        $this.traverseResDir(file, imageFileList, cacheList, iBigImage);
    }

    public static final /* synthetic */ void access$checkBigImage(ImagePlugin $this) {
        $this.checkBigImage();
    }

    public static final /* synthetic */ void access$mtDispatchOptimizeTask(ImagePlugin $this, ArrayList imageFileList) {
        $this.mtDispatchOptimizeTask(imageFileList);
    }

    public static final /* synthetic */ String access$sizeInfo(ImagePlugin $this) {
        return $this.sizeInfo();
    }
}

