/*
 * Decompiled with CFR 0.152.
 */
package com.smallsoho.mcplugin.image.utils;

import com.smallsoho.mcplugin.image.utils.ImageUtil;
import com.smallsoho.mcplugin.image.utils.LogUtil;
import com.smallsoho.mcplugin.image.utils.Tools;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/smallsoho/mcplugin/image/utils/CompressUtil;", "", "()V", "Companion", "McImage"})
public final class CompressUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "Compress";

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/smallsoho/mcplugin/image/utils/CompressUtil$Companion;", "", "()V", "TAG", "", "compressImg", "", "imgFile", "Ljava/io/File;", "McImage"})
    public static final class Companion {
        private Companion() {
        }

        public final void compressImg(@NotNull File imgFile) {
            Intrinsics.checkNotNullParameter((Object)imgFile, (String)"imgFile");
            if (!ImageUtil.Companion.isImage(imgFile)) {
                return;
            }
            long oldSize = imgFile.length();
            long newSize = 0L;
            if (ImageUtil.Companion.isJPG(imgFile)) {
                StringBuilder stringBuilder = new StringBuilder();
                String string = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
                int n = 0;
                String string2 = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"imgFile.path");
                int n2 = StringsKt.lastIndexOf$default((CharSequence)string2, (String)".", (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string3 = string.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append("_temp");
                string = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
                String string4 = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"imgFile.path");
                int n3 = StringsKt.lastIndexOf$default((CharSequence)string4, (String)".", (int)0, (boolean)false, (int)6, null);
                n2 = 0;
                String string5 = string.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String tempFilePath = stringBuilder2.append(string5).toString();
                Tools.Companion.cmd("guetzli", imgFile.getPath() + ' ' + tempFilePath);
                File tempFile = new File(tempFilePath);
                newSize = tempFile.length();
                LogUtil.Companion.log(Intrinsics.stringPlus((String)"newSize = ", (Object)newSize));
                if (newSize < oldSize) {
                    String string6 = imgFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"imgFile.path");
                    String imgFileName = string6;
                    if (imgFile.exists()) {
                        imgFile.delete();
                    }
                    tempFile.renameTo(new File(imgFileName));
                } else if (tempFile.exists()) {
                    tempFile.delete();
                }
            } else {
                Tools.Companion.cmd("pngquant", "--skip-if-larger --speed 1 --nofs --strip --force --output " + imgFile.getPath() + " -- " + imgFile.getPath());
                newSize = new File(imgFile.getPath()).length();
            }
            String string = imgFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
            LogUtil.Companion.log(CompressUtil.TAG, string, String.valueOf(oldSize), String.valueOf(newSize));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

