/*
 * Decompiled with CFR 0.152.
 */
package com.smallsoho.mcplugin.image.utils;

import com.smallsoho.mcplugin.image.utils.LogUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/smallsoho/mcplugin/image/utils/ImageUtil;", "", "()V", "Companion", "McImage"})
public final class ImageUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SIZE_TAG = "SizeCheck";

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/smallsoho/mcplugin/image/utils/ImageUtil$Companion;", "", "()V", "SIZE_TAG", "", "isAlphaPNG", "", "filePath", "Ljava/io/File;", "isBigPixelImage", "imgFile", "maxWidth", "", "maxHeight", "isBigSizeImage", "maxSize", "", "isImage", "file", "isJPG", "McImage"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isImage(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".jpg", (boolean)false, (int)2, null)) {
                string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)".png", (boolean)false, (int)2, null)) {
                    string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".jpeg", (boolean)false, (int)2, null)) return false;
                }
            }
            string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".9.png", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isJPG(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".jpg", (boolean)false, (int)2, null)) return true;
            string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".jpeg", (boolean)false, (int)2, null)) return false;
            return true;
        }

        public final boolean isAlphaPNG(@NotNull File filePath) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            if (filePath.exists()) {
                boolean bl2;
                try {
                    BufferedImage img = ImageIO.read(filePath);
                    bl2 = img.getColorModel().hasAlpha();
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    LogUtil.Companion.log(string);
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean isBigSizeImage(@NotNull File imgFile, float maxSize) {
            Intrinsics.checkNotNullParameter((Object)imgFile, (String)"imgFile");
            if (this.isImage(imgFile) && (float)imgFile.length() >= maxSize) {
                String string = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
                LogUtil.Companion.log(ImageUtil.SIZE_TAG, string, "true");
                return true;
            }
            return false;
        }

        public final boolean isBigPixelImage(@NotNull File imgFile, int maxWidth, int maxHeight) {
            BufferedImage sourceImg;
            Intrinsics.checkNotNullParameter((Object)imgFile, (String)"imgFile");
            return this.isImage(imgFile) && ((sourceImg = ImageIO.read(new FileInputStream(imgFile))).getHeight() > maxHeight || sourceImg.getWidth() > maxWidth);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

