/*
 * Decompiled with CFR 0.152.
 */
package com.smallsoho.mcplugin.image.utils;

import com.smallsoho.mcplugin.image.utils.FileUtil;
import com.smallsoho.mcplugin.image.utils.LogUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/smallsoho/mcplugin/image/utils/Tools;", "", "()V", "Companion", "McImage"})
public final class Tools {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/smallsoho/mcplugin/image/utils/Tools$Companion;", "", "()V", "chmod", "", "cmd", "", "params", "executeCmd", "isCmdExist", "", "isLinux", "isMac", "isWindows", "outputMessage", "McImage"})
    public static final class Companion {
        private Companion() {
        }

        public final void cmd(@NotNull String cmd, @NotNull String params) {
            String cmdStr;
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String string = this.isCmdExist(cmd) ? cmd + ' ' + params : (this.isMac() ? FileUtil.INSTANCE.getToolsDirPath() + "mac/" + cmd + ' ' + params : (this.isLinux() ? FileUtil.INSTANCE.getToolsDirPath() + "linux/" + cmd + ' ' + params : (cmdStr = this.isWindows() ? FileUtil.INSTANCE.getToolsDirPath() + "windows/" + cmd + ' ' + params : "")));
            if (Intrinsics.areEqual((Object)cmdStr, (Object)"")) {
                LogUtil.Companion.log("McImage Not support this system");
                return;
            }
            this.outputMessage(cmdStr);
        }

        public final boolean isLinux() {
            String system = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)system, (String)"system");
            return StringsKt.startsWith$default((String)system, (String)"Linux", (boolean)false, (int)2, null);
        }

        public final boolean isMac() {
            String system = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)system, (String)"system");
            return StringsKt.startsWith$default((String)system, (String)"Mac OS", (boolean)false, (int)2, null);
        }

        public final boolean isWindows() {
            String system = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)system, (String)"system");
            String string = system;
            boolean bl = false;
            String string2 = string.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            return StringsKt.contains$default((CharSequence)string2, (CharSequence)"win", (boolean)false, (int)2, null);
        }

        public final void chmod() {
            this.outputMessage(Intrinsics.stringPlus((String)"chmod 755 -R ", (Object)FileUtil.INSTANCE.getRootDirPath()));
        }

        private final void outputMessage(String cmd) {
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isCmdExist(String cmd) {
            String result = this.isMac() || this.isLinux() ? this.executeCmd(Intrinsics.stringPlus((String)"which ", (Object)cmd)) : this.executeCmd(Intrinsics.stringPlus((String)"where ", (Object)cmd));
            if (result == null) return false;
            CharSequence charSequence = result;
            boolean bl = false;
            if (charSequence.length() != 0) return true;
            return false;
        }

        private final String executeCmd(String cmd) {
            String string;
            Process process = Runtime.getRuntime().exec(cmd);
            process.waitFor();
            BufferedReader bufferReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                string = bufferReader.readLine();
            }
            catch (Exception e) {
                LogUtil.Companion.log(e);
                string = null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

