/*
 * Decompiled with CFR 0.152.
 */
package com.smallsoho.mcplugin.image.webp;

import com.smallsoho.mcplugin.image.Config;
import com.smallsoho.mcplugin.image.utils.AndroidUtil;
import com.smallsoho.mcplugin.image.utils.CompressUtil;
import com.smallsoho.mcplugin.image.utils.ImageUtil;
import com.smallsoho.mcplugin.image.utils.LogUtil;
import com.smallsoho.mcplugin.image.utils.Tools;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/smallsoho/mcplugin/image/webp/WebpUtils;", "", "()V", "Companion", "McImage"})
public final class WebpUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int VERSION_SUPPORT_WEBP = 14;
    @NotNull
    private static final String TAG = "Webp";

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/smallsoho/mcplugin/image/webp/WebpUtils$Companion;", "", "()V", "TAG", "", "VERSION_SUPPORT_WEBP", "", "formatWebp", "", "imgFile", "Ljava/io/File;", "isPNGConvertSupported", "", "project", "Lorg/gradle/api/Project;", "securityFormatWebp", "config", "Lcom/smallsoho/mcplugin/image/Config;", "McImage"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isPNGConvertSupported(Project project) {
            return AndroidUtil.Companion.getMinSdkVersion(project) >= 14;
        }

        private final void formatWebp(File imgFile) {
            if (ImageUtil.Companion.isImage(imgFile)) {
                String string = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
                int n = 0;
                String string2 = imgFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"imgFile.path");
                int n2 = StringsKt.lastIndexOf$default((CharSequence)string2, (String)".", (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                String string3 = string.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                File webpFile = new File(Intrinsics.stringPlus((String)string3, (Object)".webp"));
                Tools.Companion.cmd("cwebp", imgFile.getPath() + " -o " + webpFile.getPath() + " -m 6 -quiet");
                if (webpFile.length() < imgFile.length()) {
                    string = imgFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.path");
                    LogUtil.Companion.log(WebpUtils.TAG, string, String.valueOf(imgFile.length()), String.valueOf(webpFile.length()));
                    if (imgFile.exists()) {
                        imgFile.delete();
                    }
                } else {
                    if (webpFile.exists()) {
                        webpFile.delete();
                    }
                    LogUtil.Companion.log("[Webp][" + imgFile.getName() + "] do not convert webp because the size become larger!");
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void securityFormatWebp(@NotNull File imgFile, @NotNull Config config, @NotNull Project project) {
            String string;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)imgFile, (String)"imgFile");
                    Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (!this.isPNGConvertSupported(project)) {
                        throw new Exception("minSDK < 14, Webp is not Support! Please choose other optimize Type!");
                    }
                    if (!ImageUtil.Companion.isImage(imgFile)) return;
                    if (config.isSupportAlphaWebp) {
                        this.formatWebp(imgFile);
                        return;
                    }
                    string = imgFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.name");
                    if (StringsKt.endsWith$default((String)string, (String)".jpg", (boolean)false, (int)2, null)) break block6;
                    string = imgFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".jpeg", (boolean)false, (int)2, null)) break block7;
                }
                this.formatWebp(imgFile);
                return;
            }
            string = imgFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imgFile.name");
            if (!StringsKt.endsWith$default((String)string, (String)".png", (boolean)false, (int)2, null)) return;
            if (!ImageUtil.Companion.isAlphaPNG(imgFile)) {
                this.formatWebp(imgFile);
                return;
            }
            CompressUtil.Companion.compressImg(imgFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

