/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.smartcodeltd.ReleaseCandidateMojo;
import com.smartcodeltd.domain.Version;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="updateVersion")
public class UpdateVersionMojo
extends ReleaseCandidateMojo {
    private static final String default_version_format = "{{ version }}";
    @Parameter(defaultValue="{{ version }}", required=false, property="releaseVersionFormat")
    private String releaseVersionFormat;

    public void execute() throws MojoExecutionException {
        File pom = this.project.getFile();
        String newVersion = this.evaluated(this.versionOf(this.root(this.project)));
        this.info("Setting version to: '%s'", newVersion);
        try {
            this.update(pom, this.with(newVersion));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Couldn't write to pom file '%s'", pom.getPath()), (Exception)e);
        }
    }

    private String evaluated(Version version) {
        return version.formattedWith(this.releaseVersionFormat);
    }

    private void update(File pom, String newVersion) throws IOException {
        Document doc = this.parsed(pom);
        this.firstExisting(this.parentVersion(doc), this.projectVersion(doc)).setText(newVersion);
        Files.write((CharSequence)doc.toString(), (File)pom, (Charset)this.charset);
    }

    private Element projectVersion(Document doc) {
        return doc.getChild("project/version");
    }

    private Element parentVersion(Document doc) {
        return this.shouldModifyParentVersion() ? doc.getChild("project/parent/version") : null;
    }

    private boolean shouldModifyParentVersion() {
        return this.project.hasParent() && !this.isOrganizationPom(this.project.getParent()) && this.hasSameGroupId(this.project, this.project.getParent());
    }

    private boolean hasSameGroupId(MavenProject project, MavenProject parent) {
        return project.getGroupId().equals(parent.getGroupId());
    }

    private boolean isOrganizationPom(MavenProject parent) {
        return "pom".equals(parent.getPackaging()) && parent.getModules().isEmpty();
    }

    private Element firstExisting(Element ... elements) {
        return (Element)Iterables.find(Arrays.asList(elements), (Predicate)Predicates.notNull(), (Object)new Element("dummy"));
    }
}

