/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd.domain;

import com.smartcodeltd.domain.SystemTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private final String version;
    private final SystemTime time;
    private static final Pattern leading_whitespace = Pattern.compile("^\\s+", 8);
    private static final Pattern timestamp = Pattern.compile("\\{\\{ timestamp\\('(.*?)'\\) \\}\\}");

    public Version(String projectVersion) {
        this.version = projectVersion;
        this.time = new SystemTime();
    }

    public Version(String projectVersion, SystemTime time) {
        this.version = projectVersion;
        this.time = time;
    }

    public String formattedWith(String template) {
        return this.parseTimestamp(this.trimmed(template).replace("{{ version }}", this.original(this.version)).replace("{{ api_version }}", this.api(this.version)).replace("{{ qualified_api_version }}", this.qualifiedApi(this.version)));
    }

    public String toString() {
        return this.version;
    }

    private String trimmed(String template) {
        return leading_whitespace.matcher(template).replaceAll("");
    }

    private String parseTimestamp(String template) {
        Matcher matcher = timestamp.matcher(template);
        return matcher.find() ? matcher.replaceAll(this.time.as(matcher.group(1))) : template;
    }

    private String original(String version) {
        return version;
    }

    private String api(String version) {
        int firstHyphenPosition = version.indexOf("-");
        return firstHyphenPosition > 0 ? version.substring(0, firstHyphenPosition) : version;
    }

    private String qualifiedApi(String version) {
        return version.replaceAll("-SNAPSHOT", "");
    }
}

