/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd;

import com.google.common.base.Preconditions;
import com.smartcodeltd.ReleaseCandidateMojo;
import com.smartcodeltd.domain.Version;
import com.smartcodeltd.writer.Writer;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="version", requiresProject=true, defaultPhase=LifecyclePhase.PACKAGE, aggregator=true)
public class VersionMojo
extends ReleaseCandidateMojo {
    private static final String default_output_uri = "stdout";
    private static final String default_output_template = "{{ version }}";
    @Parameter(defaultValue="stdout", required=false, property="outputUri")
    private URI outputUri;
    @Parameter(defaultValue="{{ version }}", required=false, property="outputTemplate")
    protected String outputTemplate;

    public void execute() throws MojoExecutionException {
        File pom = this.project.getFile();
        try {
            Version version = this.currentVersionFrom(this.project.getFile());
            this.info("Detected version: '%s'", version);
            Writer.from(this.outputUri, this.charset).write(version.formattedWith(this.outputTemplate));
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Couldn't read project version from '%s'.", pom.getPath()), e);
        }
    }

    private Version currentVersionFrom(File pom) throws IOException {
        Document doc = this.parsed(pom);
        return new Version(((Element)Preconditions.checkNotNull((Object)this.firstExisting(this.projectVersion(doc), this.parentVersion(doc)))).getText());
    }
}

