/*
 * Decompiled with CFR 0.152.
 */
package com.smartcodeltd;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.smartcodeltd.domain.Version;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class ReleaseCandidateMojo
extends AbstractMojo {
    private static final String default_encoding = "UTF-8";
    protected final Charset charset;
    @Parameter(defaultValue="UTF-8", required=false)
    protected String encoding;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    public ReleaseCandidateMojo() {
        this.charset = Charset.forName(this.getOrElse(this.encoding, default_encoding));
    }

    protected void info(String template, Object ... values) {
        this.getLog().info((CharSequence)String.format(template, values));
    }

    protected <T> T with(T value) {
        return value;
    }

    protected Version versionOf(MavenProject project) {
        return new Version(project.getVersion());
    }

    protected MavenProject root(MavenProject project) {
        return project.hasParent() && !this.isOrganizationPom(project.getParent()) ? this.root(project.getParent()) : project;
    }

    protected boolean isOrganizationPom(MavenProject parent) {
        return this.isParentPom(parent) && !this.isSnapshot(parent);
    }

    private boolean isParentPom(MavenProject parent) {
        return parent.getPackaging().equals("pom");
    }

    protected boolean isSnapshot(MavenProject mavenProject) {
        return mavenProject.getVersion().endsWith("SNAPSHOT");
    }

    protected <T> T getOrElse(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    protected Document parsed(File pom) throws IOException {
        XMLParser parser = new XMLParser();
        XMLStringSource source = new XMLStringSource(CharStreams.toString((Readable)Files.newReader((File)pom, (Charset)this.charset)));
        return parser.parse((XMLSource)source);
    }

    protected Element firstExisting(Element ... elements) {
        return (Element)Iterables.find(Arrays.asList(elements), (Predicate)Predicates.notNull(), (Object)new Element("dummy"));
    }

    protected Element projectVersion(Document doc) {
        return doc.getChild("project/version");
    }

    protected Element parentVersion(Document doc) {
        return doc.getChild("project/parent/version");
    }
}

