/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.property.mapping.data;

import com.day.cq.commons.jcr.JcrUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingData;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingRepository;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class SmartlingPropertyMappingRepository
implements PropertyMappingRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingPropertyMappingRepository.class);
    public static final String CONFIGURATION_FOLDER = "/etc/smartling/configuration";
    public static final String CONFIGURATION_FOLDER_CONF = "/conf/global/settings/smartling/configuration";
    public static final String PROPERTY_MAPPINGS_FILE_NAME = "property_mappings.json";
    public static final String PROPERTY_MAPPINGS_FILE = "/etc/smartling/configuration/property_mappings.json";
    public static final String PROPERTY_MAPPINGS_FILE_CONF = "/conf/global/settings/smartling/configuration/property_mappings.json";
    public static final String SLING_FOLDER = "sling:Folder";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @Reference
    private SlingRepository repository;

    @Override
    public Optional<PropertyMappingData> readMappings() throws PropertyMappingException {
        return this.sessionAction(this::getPropertyMappingData);
    }

    @NotNull
    private Optional<PropertyMappingData> getPropertyMappingData(Session session) throws PropertyMappingException {
        try {
            Node node = session.nodeExists(PROPERTY_MAPPINGS_FILE) ? session.getNode(PROPERTY_MAPPINGS_FILE) : session.getNode(PROPERTY_MAPPINGS_FILE_CONF);
            InputStream contentStream = JcrUtils.readFile((Node)node);
            String content = IOUtils.toString((InputStream)contentStream, (String)StandardCharsets.UTF_8.name());
            return Optional.of(GSON.fromJson(content, PropertyMappingData.class));
        }
        catch (PathNotFoundException e) {
            LOGGER.warn("Property mapping file is missed");
            return Optional.empty();
        }
        catch (RepositoryException e) {
            throw new PropertyMappingException("Couldn't readMappings property mapping file", (Exception)((Object)e));
        }
        catch (JsonSyntaxException e) {
            throw new PropertyMappingException("Property mapping file has wrong format", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new PropertyMappingException("Couldn't readMappings property mapping file stream", e);
        }
    }

    @Override
    public void updateMappings(PropertyMappingData data) throws PropertyMappingException {
        this.sessionAction(session -> {
            try {
                String content = GSON.toJson((Object)data);
                String configurationFolder = CONFIGURATION_FOLDER_CONF;
                if (session.nodeExists(PROPERTY_MAPPINGS_FILE)) {
                    configurationFolder = CONFIGURATION_FOLDER;
                }
                Node configurationNode = JcrUtil.createPath((String)configurationFolder, (String)SLING_FOLDER, (String)SLING_FOLDER, (Session)session, (boolean)true);
                JcrUtils.putFile((Node)configurationNode, (String)PROPERTY_MAPPINGS_FILE_NAME, (String)"application/json", (InputStream)new ByteArrayInputStream(content.getBytes()));
                session.save();
                return content;
            }
            catch (RepositoryException e) {
                throw new PropertyMappingException("Couldn't updateMappings property mapping file", (Exception)((Object)e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T sessionAction(PropertyMappingFunction<Session, T> func) throws PropertyMappingException {
        try {
            Session session = this.repository.loginService(null, null);
            try {
                Session t = func.apply(session);
                return (T)t;
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            throw new PropertyMappingException("Couldn't get an access to JCR repository", (Exception)((Object)e));
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    @FunctionalInterface
    public static interface PropertyMappingFunction<T, R> {
        public R apply(T var1) throws PropertyMappingException;
    }
}

