/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.TranslationCloudConfigUtil;
import com.smartling.aem.connector.automation.CloudConfigLocator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CloudConfigLocatorImpl
implements CloudConfigLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConfigLocatorImpl.class);
    public static final String CQ_CONF_PROPERTY_NAME = "cq:conf";
    public static final String CQ_CLOUD_SERVICE_CONF_PROPERTY_NAME = "cq:cloudserviceconfigs";
    @Reference
    private TranslationCloudConfigUtil translationCloudConfigUtil;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Override
    public <T> T getCloudConfigAppliedOnResource(Resource resource, Class<T> cloudConfigClass) {
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new IllegalArgumentException("Couldn't locate Smartling Cloud Config for missed resource");
        }
        String cloudConfigPath = this.translationCloudConfigUtil.getCloudConfigPathAppliedOnResource(resource, cloudConfigClass);
        if (StringUtils.isEmpty((CharSequence)cloudConfigPath) && SmartlingCloudConfig.class.equals(cloudConfigClass)) {
            cloudConfigPath = this.getCloudConfigPath(resource);
        }
        return this.getCloudConfig(cloudConfigPath, cloudConfigClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getCloudConfig(String cloudConfigPath, Class<T> cloudConfigClass) {
        ResourceResolver resourceResolver = null;
        try {
            if (cloudConfigPath != null) {
                resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
                Resource configResource = resourceResolver.resolve(cloudConfigPath);
                Object object = configResource.adaptTo(cloudConfigClass);
                return (T)object;
            }
            T configResource = null;
            return configResource;
        }
        catch (LoginException ex) {
            LOGGER.error("Couldn't login for a new resource resolver", (Throwable)ex);
            T t = null;
            return t;
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
    }

    @Override
    public boolean isCloudConfigOverridden(Resource resource) {
        Resource content = resource.getChild("jcr:content");
        if (content != null) {
            return StringUtils.isNotEmpty((CharSequence)((CharSequence)ResourceUtil.getValueMap((Resource)content).get(CQ_CONF_PROPERTY_NAME, String.class))) || StringUtils.isNotEmpty((CharSequence)((CharSequence)ResourceUtil.getValueMap((Resource)content).get(CQ_CLOUD_SERVICE_CONF_PROPERTY_NAME, String.class)));
        }
        return false;
    }

    private String getCloudConfigPath(Resource pageResource) {
        String machineTranslationCloudConfigPath = this.translationCloudConfigUtil.getCloudConfigPathAppliedOnResource(pageResource, MachineTranslationCloudConfig.class);
        if (StringUtils.isEmpty((CharSequence)machineTranslationCloudConfigPath) || !machineTranslationCloudConfigPath.contains("translationcfg")) {
            return null;
        }
        String translationCloudConfigDirPath = machineTranslationCloudConfigPath.substring(0, machineTranslationCloudConfigPath.indexOf("translationcfg"));
        Resource resource = pageResource.getResourceResolver().getResource(translationCloudConfigDirPath + "smartling-translation");
        if (resource == null) {
            return null;
        }
        for (Resource child : resource.getChildren()) {
            if (child.getName().equals("jcr:content")) continue;
            return child.getPath();
        }
        return null;
    }

    protected void bindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        this.translationCloudConfigUtil = translationCloudConfigUtil;
    }

    protected void unbindTranslationCloudConfigUtil(TranslationCloudConfigUtil translationCloudConfigUtil) {
        if (this.translationCloudConfigUtil == translationCloudConfigUtil) {
            this.translationCloudConfigUtil = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

