/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationObject;
import com.smartling.aem.connector.automation.impl.TranslationObjectType;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.TranslationUtils;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobDetails;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobMetadata;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectDetails;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

@Service(value={TranslationDetailsManager.class})
@Component
public class TranslationDetailsManager {
    @Reference
    private TranslationProjectManager translationProjectManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranslationObjectDetails getTranslationObjectDetails(String aemTranslationJobId, SmartlingFacade.Resource resource) throws SmartlingException {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            TranslationJobMetadata jobMetadata = this.translationProjectManager.getTranslationJobMetadata(resourceResolver, aemTranslationJobId);
            TranslationObjectDetails translationObjectDetails = TranslationObjectDetails.builder().sourcePath(resource.getPath().orElse(null)).aemTranslationJobId(aemTranslationJobId).type(resource.getTranslationObjectType()).aemTargetLanguage(jobMetadata.getAemTargetLanguage()).aemSourceLanguage(jobMetadata.getAemSourceLanguage()).smartlingJobUid(jobMetadata.getSmartlingJobUid()).smartlingBatchUid(jobMetadata.getSmartlingBatchUid()).configSourceLocaleCode(jobMetadata.getConfigSourceLocaleCode()).smartlingProjectUid(jobMetadata.getSmartlingProjectUid()).build();
            return translationObjectDetails;
        }
        catch (TranslationProjectException | LoginException e) {
            throw new SmartlingException(String.format("Couldn't find translation project for aemTranslationJobId=\"%s\"", aemTranslationJobId), e);
        }
    }

    public void setTranslationProjectUid(String aemTranslationJobId, String smartlingJobUid) throws SmartlingException {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            TranslationProject translationProject = this.translationProjectManager.getProjectByTranslationJobId(resourceResolver, aemTranslationJobId);
            translationProject.setJobUid(smartlingJobUid);
        }
        catch (TranslationProjectException | LoginException e) {
            throw new SmartlingException(String.format("Couldn't find translation project for aemTranslationJobId=\"%s\"", aemTranslationJobId), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranslationJobDetails getTranslationJobDetails(String aemTranslationJobId) throws SmartlingException {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            TranslationProject translationProject = this.translationProjectManager.getProjectByTranslationJobId(resourceResolver, aemTranslationJobId);
            TranslationJob translationJob = this.findTranslationJob(aemTranslationJobId, translationProject);
            List<String> translationJobIds = translationJob.getTranslationObjects().stream().map(TranslationObject::getId).filter(Objects::nonNull).collect(Collectors.toList());
            TranslationJobDetails translationJobDetails = TranslationJobDetails.builder().translationObjectIds(translationJobIds).targetLanguage(translationJob.getTargetLanguage()).configSourceLocaleCode(translationProject.getConfigSourceLocaleCode()).projectUid(translationProject.getProjectUid()).pseudo(translationProject.isPseudo()).build();
            return translationJobDetails;
        }
        catch (TranslationProjectException | LoginException e) {
            throw new SmartlingException(String.format("Couldn't find translation job for aemTranslationJobId=\"%s\"", aemTranslationJobId), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranslationObjectType getObjectType(com.adobe.granite.translation.api.TranslationObject obj) throws SmartlingException {
        String path = obj.getTranslationObjectSourcePath();
        String title = obj.getTitle();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            TranslationObjectType type = TranslationUtils.getTranslationObjectType(resourceResolver, obj);
            if (type == null) {
                throw new SmartlingException(String.format("Couldn't determine translation object type for path=\"%s\", title=\"%s\"", path, title));
            }
            TranslationObjectType translationObjectType = type;
            return translationObjectType;
        }
        catch (LoginException e) {
            throw new SmartlingException(String.format("Couldn't login into repository for determining translation object type by path=\"%s\", title=\"%s\"", path, title), e);
        }
    }

    private TranslationJob findTranslationJob(String jobId, TranslationProject translationProject) throws SmartlingException {
        return translationProject.getTranslationJobs().stream().filter(job -> StringUtils.equals((CharSequence)jobId, (CharSequence)job.getJobId())).findFirst().orElseThrow(() -> new SmartlingException(String.format("Couldn't find translation job object for jobId='%s'", jobId)));
    }

    public void writeTranslationJobMetadata(String aemTranslationJobName, String aemTranslationJobId, String aemSourceLanguage, String aemTargetLanguage) throws TranslationProjectException {
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            this.translationProjectManager.writeTranslationJobMetadata(resourceResolver, aemTranslationJobName, aemTranslationJobId, aemSourceLanguage, aemTargetLanguage);
        }
        catch (LoginException e) {
            throw new TranslationProjectException(String.format("Couldn't login into repository for writing translation job metadata jobName=\"%s\", jobId=\"%s\"", aemTranslationJobName, aemTranslationJobId), e);
        }
    }

    protected void bindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        this.translationProjectManager = translationProjectManager;
    }

    protected void unbindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        if (this.translationProjectManager == translationProjectManager) {
            this.translationProjectManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

