/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.adobe.granite.translation.api.TranslationConstants;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationObject;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationObjectResource;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.commons.lang3.EnumUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TranslationJobResource
implements TranslationJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationJobResource.class);
    private static final String TRANSLATION_STATUS_PROP = "translationStatus";
    private static final String CURRENT_POLLER_ACTION_PROP = "currentPollerAction";
    private static final String TARGET_LANGUAGE_PROP = "destinationLanguage";
    private static final String JOB_ID_PROP = "translationObjectID";
    static final String RESOURCE_TYPE = "cq/gui/components/projects/admin/pod/translationjobpod";
    private static final String TRANSLATION_OBJECT_QUERY = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE('%s') and s.[sling:resourceType]='%s'";
    private final Resource resource;
    private final ModifiableValueMap translationJobProperties;

    TranslationJobResource(Resource resource) {
        this.resource = resource;
        this.translationJobProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
    }

    @Override
    public TranslationConstants.TranslationStatus getStatus() {
        String translationStatus = (String)this.translationJobProperties.get(TRANSLATION_STATUS_PROP, String.class);
        return (TranslationConstants.TranslationStatus)EnumUtils.getEnum(TranslationConstants.TranslationStatus.class, (String)translationStatus);
    }

    @Override
    public Collection<TranslationObject> getTranslationObjects() {
        try {
            ResourceResolver resourceResolver = this.resource.getResourceResolver();
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                LOGGER.error("Couldn't take a repository session.");
                return Collections.emptyList();
            }
            String queryString = String.format(TRANSLATION_OBJECT_QUERY, this.resource.getPath(), "cq/gui/components/projects/admin/card/translation_object");
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = query.execute().getNodes();
            LinkedList<Resource> translationResources = new LinkedList<Resource>();
            while (nodes != null && nodes.hasNext()) {
                Node node = nodes.nextNode();
                Resource translationResource = resourceResolver.getResource(node.getPath());
                if (translationResource == null) {
                    LOGGER.error("Couldn't find translation object by path=\"{}\"", (Object)node.getPath());
                    continue;
                }
                translationResources.add(translationResource);
            }
            return translationResources.stream().map(TranslationObjectResource::new).collect(Collectors.toList());
        }
        catch (RepositoryException e) {
            LOGGER.error("Couldn't take translation objects for translation job \"{}\"", (Object)this.resource.getPath(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getCurrentPollerAction() {
        return (String)this.translationJobProperties.get(CURRENT_POLLER_ACTION_PROP, String.class);
    }

    @Override
    public void setCurrentPollerAction(String action) {
        this.translationJobProperties.put((Object)CURRENT_POLLER_ACTION_PROP, (Object)action);
    }

    @Override
    public String getResourcePath() {
        return this.resource.getPath();
    }

    @Override
    public String getTargetLanguage() {
        return (String)this.translationJobProperties.get(TARGET_LANGUAGE_PROP, String.class);
    }

    @Override
    public String getJobId() {
        return (String)this.translationJobProperties.get(JOB_ID_PROP, String.class);
    }
}

