/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.SmartlingDialogConfiguration;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/services/smartling/dialog-options"})
public class DialogOptionsServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DialogOptionsServlet.class);
    @Reference
    private SmartlingFacade facade;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private SmartlingDialogConfiguration smartlingDialogConfiguration;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            OptionsDefaults aemProjectDefaults = OptionsDefaults.builder().autoAuthorize(this.facade.autoAuthorize()).pseudo(this.smartlingDialogConfiguration.isPseudoTranslationEnabledByDefault()).validateTargetContentExistence(this.smartlingDialogConfiguration.isTargetContentExistenceValidationEnabled()).build();
            DialogOptionsServlet.writeJson(response, aemProjectDefaults);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Couldn't get option defaults", (Throwable)e);
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("General error on taking AEM project defaults", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindFacade(SmartlingFacade smartlingFacade) {
        this.facade = smartlingFacade;
    }

    protected void unbindFacade(SmartlingFacade smartlingFacade) {
        if (this.facade == smartlingFacade) {
            this.facade = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        this.smartlingDialogConfiguration = smartlingDialogConfiguration;
    }

    protected void unbindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        if (this.smartlingDialogConfiguration == smartlingDialogConfiguration) {
            this.smartlingDialogConfiguration = null;
        }
    }

    static class OptionsDefaults {
        boolean autoAuthorize;
        boolean validateTargetContentExistence;
        boolean pseudo;

        OptionsDefaults(boolean autoAuthorize, boolean validateTargetContentExistence, boolean pseudo) {
            this.autoAuthorize = autoAuthorize;
            this.validateTargetContentExistence = validateTargetContentExistence;
            this.pseudo = pseudo;
        }

        public static OptionsDefaultsBuilder builder() {
            return new OptionsDefaultsBuilder();
        }

        public boolean isAutoAuthorize() {
            return this.autoAuthorize;
        }

        public boolean isValidateTargetContentExistence() {
            return this.validateTargetContentExistence;
        }

        public boolean isPseudo() {
            return this.pseudo;
        }

        public static class OptionsDefaultsBuilder {
            private boolean autoAuthorize;
            private boolean validateTargetContentExistence;
            private boolean pseudo;

            OptionsDefaultsBuilder() {
            }

            public OptionsDefaultsBuilder autoAuthorize(boolean autoAuthorize) {
                this.autoAuthorize = autoAuthorize;
                return this;
            }

            public OptionsDefaultsBuilder validateTargetContentExistence(boolean validateTargetContentExistence) {
                this.validateTargetContentExistence = validateTargetContentExistence;
                return this;
            }

            public OptionsDefaultsBuilder pseudo(boolean pseudo) {
                this.pseudo = pseudo;
                return this;
            }

            public OptionsDefaults build() {
                return new OptionsDefaults(this.autoAuthorize, this.validateTargetContentExistence, this.pseudo);
            }

            public String toString() {
                return "DialogOptionsServlet.OptionsDefaults.OptionsDefaultsBuilder(autoAuthorize=" + this.autoAuthorize + ", validateTargetContentExistence=" + this.validateTargetContentExistence + ", pseudo=" + this.pseudo + ")";
            }
        }
    }
}

