/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.smartling.aem.connector.automation.impl.ProjectCustomFieldsProvider;
import com.smartling.aem.connector.automation.impl.TranslationRequest;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.CustomFieldValue;
import com.smartling.aem.connector.core.impl.integration.platform.auditlog.AuditLogClientFacade;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true)
public abstract class SmartlingJobWorkflowServlet
extends SmartlingBaseServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingJobWorkflowServlet.class);
    public static final String PAYLOAD_PATH_PARAMETER = "payload";
    public static final String JOB_NAME_PARAMETER = "jobName";
    public static final String JOB_UID_PARAMETER = "jobUid";
    public static final String PROJECT_UID_PARAMETER = "projectUid";
    public static final String TARGET_LOCALE_CODES = "targetLocaleCodes";
    public static final String IS_DEEP = "isDeep";
    public static final String EXCLUDED_PATHS = "excludedPaths";
    public static final String WCM_TRANSLATE_MODEL_PATH = "/etc/workflow/models/smartling/wcm-translate/jcr:content/model";
    public static final String DAM_TRANSLATE_MODEL_PATH = "/etc/workflow/models/smartling/dam-translate/jcr:content/model";
    private static final Gson GSON = new GsonBuilder().create();
    @Reference
    private ProjectCustomFieldsProvider projectCustomFieldsProvider;
    @Reference
    private AuditLogClientFacade auditLogClientFacade;

    protected TranslationRequest getTranslationRequestBuilder(SlingHttpServletRequest request) {
        String pagePath = request.getParameter(PAYLOAD_PATH_PARAMETER);
        String[] paths = Arrays.stream(StringUtils.split((String)pagePath, (String)";")).map(path -> StringUtils.substringBefore((String)path, (String)".html")).collect(Collectors.toList()).toArray(new String[0]);
        boolean isDeep = Boolean.parseBoolean(request.getParameter(IS_DEEP));
        String[] excludedPaths = request.getParameterValues(EXCLUDED_PATHS);
        String jobName = StringUtils.trim((String)((String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(JOB_NAME_PARAMETER), null)));
        String jobUid = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(JOB_UID_PARAMETER), null);
        String[] targetLocaleCodes = request.getParameterValues(TARGET_LOCALE_CODES);
        Date dueDate = SmartlingJobWorkflowServlet.parseDate(request.getParameter("jobDueDate"));
        boolean authJob = Boolean.parseBoolean(request.getParameter("authorizeJob"));
        boolean forceResubmission = Boolean.parseBoolean(request.getParameter("forceResubmission"));
        String userId = request.getResourceResolver().getUserID();
        String projectUid = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter(PROJECT_UID_PARAMETER), null);
        boolean pseudo = Boolean.parseBoolean(request.getParameter("pseudo"));
        return TranslationRequest.builder().projectUid(projectUid).authJob(authJob).dueDate(dueDate).excludedPaths(excludedPaths).forceResubmission(forceResubmission).isDeep(isDeep).jobName(jobName).jobUid(jobUid).paths(paths).targetLocaleCodes(targetLocaleCodes).userId(userId).pseudo(pseudo).build();
    }

    protected void startWorkflow(ResourceResolver resourceResolver, String payload, String workflowModel, Map<String, Object> metadata) throws WorkflowException {
        WorkflowSession workflowSession = (WorkflowSession)resourceResolver.adaptTo(WorkflowSession.class);
        WorkflowData workflowData = workflowSession.newWorkflowData("JCR_PATH", (Object)payload);
        WorkflowModel model = workflowSession.getModel(workflowModel);
        if (model == null) {
            LOGGER.error("Couldn't get workflow model path=\"{}\"", (Object)workflowModel);
            throw new WorkflowException(String.format("Couldn't get workflow model path=\"%s\"", workflowModel));
        }
        this.logStartWorkflow(payload, workflowModel, metadata);
        workflowSession.startWorkflow(model, workflowData, metadata);
    }

    private void logStartWorkflow(String payload, String workflowModel, Map<String, Object> metadata) {
        String metadataMapToString = metadata.entrySet().stream().map(entry -> entry.getValue() != null && entry.getValue().getClass().isArray() ? String.format("%s=\"%s\"", entry.getKey(), ArrayUtils.toString(entry.getValue())) : String.format("%s=\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        LOGGER.info("Start workflow \"{}\" payload=\"{}\" with metadata: {}", new Object[]{workflowModel, payload, metadataMapToString});
    }

    protected void logTranslationRequest(TranslationRequest translationRequest, SmartlingCloudConfig cloudConfig) {
        this.auditLogClientFacade.logStartSmartlingWorkflow(cloudConfig, translationRequest);
    }

    protected Map<String, Object> prepareMetadata(SlingHttpServletRequest request, ResourceResolver resourceResolver, TranslationRequest translationRequest) throws SmartlingException {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(TARGET_LOCALE_CODES, translationRequest.getTargetLocaleCodes());
        metadata.put(JOB_UID_PARAMETER, translationRequest.getJobUid());
        metadata.put(JOB_NAME_PARAMETER, translationRequest.getJobName());
        metadata.put("jobDueDate", translationRequest.getDueDate());
        metadata.put("authorizeJob", translationRequest.isAuthJob());
        metadata.put("forceResubmission", translationRequest.isForceResubmission());
        metadata.put("loggedUser", translationRequest.getUserId());
        metadata.put(PROJECT_UID_PARAMETER, translationRequest.getProjectUid());
        metadata.put("pseudo", translationRequest.isPseudo());
        Resource resource = resourceResolver.getResource(translationRequest.getPaths()[0]);
        List customFields = this.projectCustomFieldsProvider.getAssignedCustomFields(resource, translationRequest.getProjectUid()).stream().map(field -> {
            String fieldValue = (String)StringUtils.defaultIfEmpty((CharSequence)request.getParameter("uid-" + field.getFieldUID()), null);
            return new CustomFieldValue(field.getFieldUID(), field.getFieldName(), fieldValue);
        }).filter(field -> StringUtils.isNotBlank((CharSequence)field.getFieldValue())).collect(Collectors.toList());
        metadata.put("customFields", GSON.toJson(customFields));
        return metadata;
    }

    private static Date parseDate(String dateAsUtcString) {
        if (StringUtils.isNotBlank((CharSequence)dateAsUtcString)) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(dateAsUtcString);
            }
            catch (ParseException e) {
                LOGGER.warn("Could not parse a date {}:", (Object)dateAsUtcString, (Object)e);
            }
        }
        return null;
    }

    protected void bindProjectCustomFieldsProvider(ProjectCustomFieldsProvider projectCustomFieldsProvider) {
        this.projectCustomFieldsProvider = projectCustomFieldsProvider;
    }

    protected void unbindProjectCustomFieldsProvider(ProjectCustomFieldsProvider projectCustomFieldsProvider) {
        if (this.projectCustomFieldsProvider == projectCustomFieldsProvider) {
            this.projectCustomFieldsProvider = null;
        }
    }

    protected void bindAuditLogClientFacade(AuditLogClientFacade auditLogClientFacade) {
        this.auditLogClientFacade = auditLogClientFacade;
    }

    protected void unbindAuditLogClientFacade(AuditLogClientFacade auditLogClientFacade) {
        if (this.auditLogClientFacade == auditLogClientFacade) {
            this.auditLogClientFacade = null;
        }
    }
}

