/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.debug;

import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.debug.dto.Converter;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/debug/translation-project-by-job-id"})
public class TranslationProjectByJobIdServlet
extends SmartlingBaseServlet {
    @Reference
    private TranslationProjectManager translationProjectManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String translationJobId = TranslationProjectByJobIdServlet.getMandatoryParameter(request, "jobId", "Mandatory AEM's \"jobId\" parameter is missing");
        try {
            TranslationProject project = this.translationProjectManager.getProjectByTranslationJobId(resourceResolver, translationJobId);
            TranslationProjectByJobIdServlet.writeJson(response, Converter.convert(project));
        }
        catch (TranslationProjectException e) {
            response.sendError(400, e.getMessage());
        }
    }

    protected void bindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        this.translationProjectManager = translationProjectManager;
    }

    protected void unbindTranslationProjectManager(TranslationProjectManager translationProjectManager) {
        if (this.translationProjectManager == translationProjectManager) {
            this.translationProjectManager = null;
        }
    }
}

