/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.config;

import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.Language;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingDialogConfiguration;
import com.smartling.aem.connector.automation.ui.SmartlingValidationException;
import com.smartling.aem.connector.automation.ui.validator.config.CloudConfigMatchValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

@Service
@Component
public class CloudConfigMatchValidatorImpl
implements CloudConfigMatchValidator {
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    public static final String VALIDATION_ERROR_MESSAGE = "Smartling project configuration for target content '%s' doesn't match to project configuration for current content";
    public static final String VALIDATION_LEGACY_CLOUD_CONFIG_ERROR_MESSAGE = "Content '%s' has legacy translation cloud configuration";
    public static final String VALIDATION_NO_LANGUAGE_ASSIGNED_EXCEPTION = "There is no language assigned to '%s' content";
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private SmartlingDialogConfiguration smartlingDialogConfiguration;

    @Override
    public void validate(ResourceResolver resourceResolver, String path, Set<String> targetLocaleCodes, String projectUid) throws SmartlingException {
        SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
        if (cloudConfig == null) {
            return;
        }
        if (this.smartlingDialogConfiguration.isLegacyConfigValidationEnabled()) {
            this.checkLegacyCloudConfigUsage(resourceResolver, path);
        }
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)ASSET_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        List languageCopies = StreamSupport.stream(languageCopyManager.findLanguageCopies(resourceResolver, path).spliterator(), false).filter(languageCopy -> targetLocaleCodes.contains(languageCopy.getLanguage().getCode().toLowerCase())).collect(Collectors.toList());
        Language sourceLanguage = languageCopyManager.getLanguage(resourceResolver, path);
        if (sourceLanguage == null) {
            throw new SmartlingValidationException(String.format(VALIDATION_NO_LANGUAGE_ASSIGNED_EXCEPTION, path));
        }
        String sourceLanguageCode = sourceLanguage.getCode();
        cloudConfig = StringUtils.isNotBlank((CharSequence)projectUid) ? cloudConfig.getForProject(projectUid) : cloudConfig.getForLocale(sourceLanguageCode);
        for (LanguageCopyManager.LanguageCopy languageCopy2 : languageCopies) {
            String existingPath = this.getExistingContentPath(resourceResolver, languageCopy2.getPath());
            if (StringUtils.isBlank((CharSequence)existingPath)) continue;
            if (this.smartlingDialogConfiguration.isLegacyConfigValidationEnabled()) {
                this.checkLegacyCloudConfigUsage(resourceResolver, existingPath);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)existingPath, (CharSequence)languageCopy2.getPath()) && this.servletUtils.isCloudConfigOverridden(resourceResolver, path)) continue;
            SmartlingCloudConfig targetCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, existingPath, SmartlingCloudConfig.class);
            if (targetCloudConfig != null) {
                SmartlingCloudConfig smartlingCloudConfig = targetCloudConfig = StringUtils.isNotBlank((CharSequence)projectUid) ? targetCloudConfig.getForProject(projectUid) : targetCloudConfig.getForLocale(sourceLanguageCode);
            }
            if (targetCloudConfig != null && StringUtils.equals((CharSequence)targetCloudConfig.getProjectId(), (CharSequence)cloudConfig.getProjectId())) continue;
            throw new SmartlingValidationException(String.format(VALIDATION_ERROR_MESSAGE, languageCopy2.getPath()));
        }
    }

    private String getExistingContentPath(ResourceResolver resourceResolver, String path) {
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            return null;
        }
        String resourcePath = path;
        Resource targetResource = resourceResolver.getResource(resourcePath);
        while (targetResource == null && StringUtils.isNotBlank((CharSequence)resourcePath)) {
            resourcePath = StringUtils.substringBeforeLast((String)resourcePath, (String)"/");
            targetResource = resourceResolver.getResource(resourcePath);
        }
        return targetResource == null ? null : targetResource.getPath();
    }

    private void checkLegacyCloudConfigUsage(ResourceResolver resourceResolver, String path) throws SmartlingValidationException {
        for (Resource resource = resourceResolver.getResource(path); resource != null; resource = resource.getParent()) {
            Stream<String> cloudServiceConfProperty;
            Resource content = resource.getChild("jcr:content");
            ValueMap contentProperties = ResourceUtil.getValueMap((Resource)content);
            Stream<Object> stream = cloudServiceConfProperty = contentProperties.containsKey((Object)"cq:cloudserviceconfigs") ? Arrays.stream((Object[])contentProperties.get("cq:cloudserviceconfigs", String[].class)) : Stream.empty();
            if (content == null || !cloudServiceConfProperty.anyMatch(property -> property.toLowerCase().contains("translation"))) continue;
            throw new SmartlingValidationException(String.format(VALIDATION_LEGACY_CLOUD_CONFIG_ERROR_MESSAGE, resource.getPath()));
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }

    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        this.smartlingDialogConfiguration = smartlingDialogConfiguration;
    }

    protected void unbindSmartlingDialogConfiguration(SmartlingDialogConfiguration smartlingDialogConfiguration) {
        if (this.smartlingDialogConfiguration == smartlingDialogConfiguration) {
            this.smartlingDialogConfiguration = null;
        }
    }
}

