/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.features;

import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.features.CloudConfigFeatureValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/config/features/validator"})
public class CloudConfigFeatureValidatorServlet
extends SmartlingBaseServlet {
    @Reference
    private CloudConfigFeatureValidator cloudConfigFeatureValidator;
    @Reference
    private ServletUtils servletUtils;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        try {
            String path = this.servletUtils.getPayloadPath(request);
            path = StringUtils.substringBefore((String)path, (String)";");
            MachineTranslationCloudConfig machineTranslationCloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, MachineTranslationCloudConfig.class);
            if (machineTranslationCloudConfig == null) {
                this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, "Could not found machine translation cloud config for this page");
                return;
            }
            this.cloudConfigFeatureValidator.validate(machineTranslationCloudConfig);
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    protected void bindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        this.cloudConfigFeatureValidator = cloudConfigFeatureValidator;
    }

    protected void unbindCloudConfigFeatureValidator(CloudConfigFeatureValidator cloudConfigFeatureValidator) {
        if (this.cloudConfigFeatureValidator == cloudConfigFeatureValidator) {
            this.cloudConfigFeatureValidator = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }
}

