/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.locale;

import com.google.common.collect.Sets;
import com.smartling.aem.connector.automation.CloudConfigResolver;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.locale.TargetLocalesValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;

@SlingServlet(paths={"/services/smartling/target/locales/validator"})
public class TargetLocaleValidatorServlet
extends SmartlingBaseServlet {
    @Reference
    private TargetLocalesValidator targetLocalesValidator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private CloudConfigResolver cloudConfigResolver;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String[] targetLocaleCodesParam = request.getParameterValues("targetLocaleCodes");
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, "Target locale codes are missing for checking parent page");
            return;
        }
        Set<String> targetLocaleCodes = Sets.newHashSet((Object[])request.getParameterValues("targetLocaleCodes")).stream().filter(el -> !StringUtils.isEmpty((CharSequence)el)).collect(Collectors.toSet());
        try {
            String path = this.servletUtils.getPayloadPath(request);
            path = StringUtils.substringBefore((String)path, (String)";");
            SmartlingCloudConfig cloudConfig = this.servletUtils.getCloudConfigByPagePath(resourceResolver, path, SmartlingCloudConfig.class);
            if (cloudConfig == null) {
                return;
            }
            String projectUid = request.getParameter("projectUid");
            cloudConfig = this.cloudConfigResolver.getConfigByPath(cloudConfig, resourceResolver, path, projectUid);
            this.targetLocalesValidator.validate(cloudConfig, targetLocaleCodes);
        }
        catch (SmartlingException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    protected void bindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        this.targetLocalesValidator = targetLocalesValidator;
    }

    protected void unbindTargetLocalesValidator(TargetLocalesValidator targetLocalesValidator) {
        if (this.targetLocalesValidator == targetLocalesValidator) {
            this.targetLocalesValidator = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    @Override
    protected void bindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        this.cloudConfigResolver = cloudConfigResolver;
    }

    @Override
    protected void unbindCloudConfigResolver(CloudConfigResolver cloudConfigResolver) {
        if (this.cloudConfigResolver == cloudConfigResolver) {
            this.cloudConfigResolver = null;
        }
    }
}

