/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.name;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.smartling.aem.connector.automation.ui.validator.name.UniqueJobNameValidator;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClientFactory;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@Service
@Component
public class UniqueJobNameValidatorImpl
implements UniqueJobNameValidator {
    @Reference
    private JobApiClientFactory jobApiClientFactory;

    @Override
    public void validate(final String jobName, SmartlingCloudConfig smartlingCloudConfig, String jobUid) throws SmartlingException {
        if (StringUtils.isEmpty((CharSequence)jobName) && StringUtils.isEmpty((CharSequence)jobUid)) {
            throw new SmartlingException("Job name or uid must be provided");
        }
        if (jobName != null && jobName.length() > 170) {
            throw new SmartlingException("Max job name length is 170 chars");
        }
        if (jobName != null && jobUid == null) {
            List<Job> jobs;
            try (JobApiClient jobApiClient = this.jobApiClientFactory.createClient(smartlingCloudConfig);){
                jobs = jobApiClient.listJobsByName(jobName);
            }
            catch (Exception e) {
                throw new SmartlingException("Couldn't list job by name=\"" + jobName + "\".", e);
            }
            if (FluentIterable.from(jobs).firstMatch((Predicate)new Predicate<Job>(){

                public boolean apply(@Nullable Job input) {
                    return jobName.equalsIgnoreCase(input.getName());
                }
            }).isPresent()) {
                throw new SmartlingException("Unique job name must be provided");
            }
        }
    }

    protected void bindJobApiClientFactory(JobApiClientFactory jobApiClientFactory) {
        this.jobApiClientFactory = jobApiClientFactory;
    }

    protected void unbindJobApiClientFactory(JobApiClientFactory jobApiClientFactory) {
        if (this.jobApiClientFactory == jobApiClientFactory) {
            this.jobApiClientFactory = null;
        }
    }
}

