/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.page;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.ui.validator.page.TargetPageExistingValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Service
@Component
public class TargetPageExistingValidatorImpl
implements TargetPageExistingValidator {
    public static final String TARGET_PAGES_MISSED_MESSAGE_FORMAT = "Following target pages are missed: %s";

    @Override
    public void validate(Iterable<LanguageCopyManager.LanguageCopy> languageCopies, Set<String> requestedLocales) throws SmartlingException {
        FluentIterable missedLanguageCopies = FluentIterable.from(languageCopies).filter(WorkflowUtil.byLocaleCode((Predicate<String>)Predicates.in(requestedLocales))).filter(languageCopy -> !languageCopy.exists());
        if (!missedLanguageCopies.isEmpty()) {
            FluentIterable missedPaths = missedLanguageCopies.transform(LanguageCopyManager.LanguageCopy::getPath);
            String missedPathsStr = StringUtils.join((Iterable)missedPaths, (String)",");
            throw new SmartlingException(String.format(TARGET_PAGES_MISSED_MESSAGE_FORMAT, missedPathsStr));
        }
    }
}

