/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.ui.validator.page;

import com.google.common.collect.Sets;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.ui.ServletUtils;
import com.smartling.aem.connector.automation.ui.SmartlingBaseServlet;
import com.smartling.aem.connector.automation.ui.validator.page.TargetPageExistingValidator;
import com.smartling.aem.connector.core.SmartlingException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

@SlingServlet(paths={"/services/smartling/page/target/validator"})
public class TargetPageValidatorServlet
extends SmartlingBaseServlet {
    public static final String THERE_IS_NO_RESOURCE_ERROR_MESSAGE = "There is no resource for checking language copy";
    public static final String TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE = "Target locale codes are missing for checking parent page";
    public static final String ASSET_ROOT_FOLDER = "/content/dam";
    @Reference
    private TargetPageExistingValidator targetParentPageValidator;
    @Reference
    private ServletUtils servletUtils;
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;
    @Reference
    private PageLanguageCopyManager pageLanguageCopyManager;

    @Override
    protected void doGetInternal(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull ResourceResolver resourceResolver) throws ServletException, IOException {
        String payloadPath = this.servletUtils.getPayloadPath(request);
        if (StringUtils.isBlank((CharSequence)payloadPath)) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
            return;
        }
        Object[] targetLocaleCodesParam = request.getParameterValues("targetLocaleCodes");
        if (targetLocaleCodesParam == null) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, TARGET_LOCALE_CODES_MISSING_ERROR_MESSAGE);
            return;
        }
        HashSet targetLocaleCodes = Sets.newHashSet((Object[])targetLocaleCodesParam);
        targetLocaleCodes.remove("");
        try {
            ResourceResolver finalResourceResolver = resourceResolver;
            for (String path2 : Stream.of(StringUtils.split((String)payloadPath, (String)";")).map(path -> this.getResource((String)path, finalResourceResolver).getPath()).collect(Collectors.toSet())) {
                this.validate(path2, resourceResolver, targetLocaleCodes);
            }
        }
        catch (SmartlingException | ResourceNotFoundException e) {
            this.servletUtils.addErrorDetails((HttpServletResponse)response, 400, e.getMessage());
        }
    }

    protected void validate(String path, ResourceResolver resourceResolver, Set<String> targetLocaleCodes) throws ResourceNotFoundException, SmartlingException {
        LanguageCopyManager languageCopyManager = StringUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)ASSET_ROOT_FOLDER) ? this.assetLanguageCopyManager : this.pageLanguageCopyManager;
        Iterable<LanguageCopyManager.LanguageCopy> languageCopies = languageCopyManager.findLanguageCopies(resourceResolver, path);
        this.targetParentPageValidator.validate(languageCopies, targetLocaleCodes);
    }

    private Resource getResource(String path, ResourceResolver resourceResolver) {
        Resource resource = this.servletUtils.getResource(resourceResolver, path);
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new ResourceNotFoundException(path, THERE_IS_NO_RESOURCE_ERROR_MESSAGE);
        }
        return resource;
    }

    protected void bindTargetParentPageValidator(TargetPageExistingValidator targetPageExistingValidator) {
        this.targetParentPageValidator = targetPageExistingValidator;
    }

    protected void unbindTargetParentPageValidator(TargetPageExistingValidator targetPageExistingValidator) {
        if (this.targetParentPageValidator == targetPageExistingValidator) {
            this.targetParentPageValidator = null;
        }
    }

    @Override
    protected void bindServletUtils(ServletUtils servletUtils) {
        this.servletUtils = servletUtils;
    }

    @Override
    protected void unbindServletUtils(ServletUtils servletUtils) {
        if (this.servletUtils == servletUtils) {
            this.servletUtils = null;
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }

    protected void bindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.pageLanguageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindPageLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.pageLanguageCopyManager == pageLanguageCopyManager) {
            this.pageLanguageCopyManager = null;
        }
    }
}

