/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Service(value={SmartlingCredentialsConfiguration.class})
@Component(label="Smartling - Credentials (Touch)", description="Allows to set up Smartling credentials for the whole environment.", metatype=true)
public class SmartlingCredentialsConfiguration {
    @Property(label="Project ID", description="Specify Smartling project Id.")
    private static final String PROJECT_ID_PROP = "smartling.credentials.project.id";
    @Property(label="User Identifier", description="Specify Smartling user identifier.")
    private static final String USER_IDENTIFIER_PROP = "smartling.credentials.user.identifier";
    @Property(label="Token Secret", passwordValue={""}, description="Specify Smartling token secret.")
    private static final String TOKEN_SECRET_PROP = "smartling.credentials.token.secret";
    private String projectId;
    private String userIdentifier;
    private String tokenSecret;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this.projectId = PropertiesUtil.toString((Object)properties.get(PROJECT_ID_PROP), (String)"");
        this.userIdentifier = PropertiesUtil.toString((Object)properties.get(USER_IDENTIFIER_PROP), (String)"");
        this.tokenSecret = PropertiesUtil.toString((Object)properties.get(TOKEN_SECRET_PROP), (String)"");
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public boolean isSpecified() {
        return StringUtils.isNotBlank((CharSequence)this.projectId) && StringUtils.isNotBlank((CharSequence)this.userIdentifier) && StringUtils.isNotBlank((CharSequence)this.tokenSecret);
    }
}

