/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import com.smartling.aem.connector.core.ConfigurationManager;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import com.smartling.aem.connector.core.SmartlingCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
@Properties(value={@Property(name="event.topics", value={"org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/REMOVED"}), @Property(name="event.filter", value={"(path=/conf/*/settings/cloudconfigs/translation/smartling-translation/jcr:content)"})})
public class CloudConfigurationManager
implements ConfigurationManager,
EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudConfigurationManager.class);
    public static final String CLOUD_CONFIG_ROOT = "/conf";
    public static final String CLOUD_CONFIG_RELATIVE_PATH = "settings/cloudconfigs/translation/smartling-translation";
    @Reference
    private ResourceResolverFactory resolverFactory;
    private final Collection<Runnable> listeners = new CopyOnWriteArraySet<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SmartlingCredentials> getConfigurations() {
        ArrayList<SmartlingCredentials> configurations = new ArrayList<SmartlingCredentials>();
        try (ResourceResolver resolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());){
            Resource rootResource = resolver.resolve(CLOUD_CONFIG_ROOT);
            for (Resource rootChild : rootResource.getChildren()) {
                Resource configurationResource = rootChild.getChild(CLOUD_CONFIG_RELATIVE_PATH);
                if (configurationResource == null) continue;
                for (Resource child : configurationResource.getChildren()) {
                    SmartlingCloudConfig config = (SmartlingCloudConfig)child.adaptTo(SmartlingCloudConfig.class);
                    if (config != null && config.isValid()) {
                        configurations.add(config);
                        config.getLocaleProjectConfigs().stream().filter(SmartlingCredentials::isValid).forEach(configurations::add);
                        continue;
                    }
                    LOGGER.warn("Skipped invalid Cloud Configuration at {}", (Object)child.getPath());
                }
            }
        }
        catch (LoginException e) {
            LOGGER.error(String.format("Failed to load available cloud configurations: %s. Check service user mappings for Smartling Bundles", e.getMessage()));
        }
        return configurations;
    }

    @Override
    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    public void handleEvent(Event event) {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

