/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={TranslatableContentConfigurationsService.class})
@Component(metatype=true, label="Smartling - Translatable Content Configuration (Touch)", description="ATTENTION! This configuration should be set during initial setup as changing it may result in new content for translation or loss of existing translations on a page.")
public class TranslatableContentConfigurationsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslatableContentConfigurationsService.class);
    public static final String CUSTOM_PLACEHOLDER_FORMAT_DEFAULT = "\\{\\d(,(number|date|time)(,[^,\\{\\}]+?)?)?}";
    @Property(value={"\\{\\d(,(number|date|time)(,[^,\\{\\}]+?)?)?}"}, label="Custom Placeholder", description="Valid regular expression (https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html) which will be used by File API for masking content")
    public static final String PROPERTY_CUSTOM_PLACEHOLDER_FORMAT = "custom.placeholder.format";
    @Property(label="Custom Directives list", description="List of custom directives that will be sent within a file. An example \"smartling.include_translatable_attributes = title\".", cardinality=20)
    public static final String PROPERTY_CUSTOM_DIRECTIVES_LIST = "custom.directives.list";
    private String customPlaceholderFormatValue;
    private Map<String, String> customDirectives;

    @Activate
    public void activate(Map<String, Object> properties) {
        this.customPlaceholderFormatValue = PropertiesUtil.toString((Object)properties.get(PROPERTY_CUSTOM_PLACEHOLDER_FORMAT), (String)CUSTOM_PLACEHOLDER_FORMAT_DEFAULT);
        String[] customDirectivesArray = PropertiesUtil.toStringArray((Object)properties.get(PROPERTY_CUSTOM_DIRECTIVES_LIST), (String[])new String[0]);
        this.parseCustomDirectives(customDirectivesArray);
    }

    public String getCustomPlaceholderFormatValue() {
        return this.customPlaceholderFormatValue;
    }

    public Map<String, String> getCustomDirectives() {
        return this.customDirectives;
    }

    private void parseCustomDirectives(String[] directivesArray) {
        this.customDirectives = new HashMap<String, String>();
        for (String directive : directivesArray) {
            String[] keyValuePair = StringUtils.split((String)directive, (String)"=");
            if (keyValuePair.length != 2) {
                LOGGER.warn("Invalid directive \"{}\" was skipped from upload.", (Object)directive);
                continue;
            }
            String key = StringUtils.trim((String)keyValuePair[0]);
            String value = StringUtils.trim((String)keyValuePair[1]);
            if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
                LOGGER.warn("Invalid directive \"{}\" was skipped from upload.", (Object)directive);
                continue;
            }
            this.customDirectives.put(key, value);
        }
    }
}

