/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration;

import com.adobe.cq.wcm.launches.utils.LaunchUtils;
import com.day.cq.commons.Language;
import com.day.cq.wcm.api.LanguageManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.smartling.aem.connector.automation.impl.TranslationObjectType;
import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.integration.ResourceNamespaceResolver;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class LaunchAwareNamespaceResolver
implements ResourceNamespaceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchAwareNamespaceResolver.class);
    public static final String EXPERIENCE_FRAGMENTS_START_PATH = "/content/experience-fragments/";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private LanguageManager languageManager;

    @Override
    public String resolveNamespace(SmartlingConfig smartlingConfig, SmartlingFacade.Resource resource, String fileUri, String sourceLanguageCode, String targetLanguage, boolean shouldShareStrings, boolean shouldUseUniqueStrings) throws SmartlingException {
        if (shouldUseUniqueStrings && (LaunchAwareNamespaceResolver.isDamAsset(resource) || LaunchAwareNamespaceResolver.isContentFragment(resource) || LaunchAwareNamespaceResolver.isExperienceFragment(resource))) {
            return fileUri;
        }
        Optional<String> path = resource.getPath();
        String baseNamespacePath = path.isPresent() ? this.resolvePath(path.get(), smartlingConfig, sourceLanguageCode) : resource.getTitle();
        return shouldShareStrings ? baseNamespacePath : baseNamespacePath + "-" + targetLanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolvePath(String path, SmartlingConfig smartlingConfig, String sourceLanguageCode) throws SmartlingException {
        String string;
        ResourceResolver resolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
        try {
            String targetPath = this.tryFindLaunchTargetPath(resolver, path);
            Optional<String> sourcePathIfExist = this.getSourcePathIfExist(resolver, targetPath, smartlingConfig, sourceLanguageCode);
            string = sourcePathIfExist.orElse(targetPath);
        }
        catch (Throwable throwable) {
            try {
                resolver.close();
                throw throwable;
            }
            catch (LoginException e) {
                throw new SmartlingException("Internal connector error: could not build namespace for a file", e);
            }
        }
        resolver.close();
        return string;
    }

    private String tryFindLaunchTargetPath(ResourceResolver resolver, String path) {
        Resource pathResource = resolver.getResource(path);
        if (pathResource != null) {
            if ("dam:Asset".equals(pathResource.getResourceType())) {
                return this.getDamAssetTargetResourcePath(pathResource);
            }
            return LaunchUtils.getTargetResourcePath((Resource)pathResource, null);
        }
        return path;
    }

    private Optional<String> getSourcePathIfExist(ResourceResolver resolver, String path, SmartlingConfig smartlingConfig, String sourceLanguageCode) {
        final Set<String> aemLanguageCodes = smartlingConfig.mapSmartlingCodeToLocale(sourceLanguageCode);
        FluentIterable<Map.Entry<Language, LanguageManager.Info>> languageVersions = this.getLanguageVersions(resolver, path);
        ImmutableList candidatePaths = languageVersions.filter((Predicate)new Predicate<Map.Entry<Language, LanguageManager.Info>>(){

            public boolean apply(Map.Entry<Language, LanguageManager.Info> entry) {
                return aemLanguageCodes.contains(entry.getKey().toString().toLowerCase());
            }
        }).transform((Function)new Function<Map.Entry<Language, LanguageManager.Info>, String>(){

            public String apply(Map.Entry<Language, LanguageManager.Info> entry) {
                return entry.getValue().getPath();
            }
        }).toSortedList((Comparator)Ordering.natural());
        if (aemLanguageCodes.size() > 1) {
            LOGGER.warn("Ambiguous namespace may be used, as Smartling locale code {} corresponds to all of AEM language codes {}. Please fix it there /apps/granite/translation/connector/config/smartling/languageMapping", (Object)sourceLanguageCode, aemLanguageCodes);
        }
        return candidatePaths.isEmpty() ? Optional.empty() : Optional.of(candidatePaths.get(0));
    }

    private FluentIterable<Map.Entry<Language, LanguageManager.Info>> getLanguageVersions(ResourceResolver resolver, String path) {
        Map languageInfo = this.languageManager.getAdjacentLanguageInfo(resolver, path);
        if (languageInfo != null) {
            return FluentIterable.from(languageInfo.entrySet());
        }
        return FluentIterable.from(Collections.emptySet());
    }

    private String getDamAssetTargetResourcePath(Resource pathResource) {
        ValueMap content = pathResource.getChild("jcr:content").getValueMap();
        return (String)content.get("dam:destinationLanguageCopy", (Object)pathResource.getPath());
    }

    private static boolean isExperienceFragment(SmartlingFacade.Resource resource) {
        return resource.getPath().isPresent() && StringUtils.containsIgnoreCase((CharSequence)resource.getPath().get(), (CharSequence)EXPERIENCE_FRAGMENTS_START_PATH);
    }

    private static boolean isContentFragment(SmartlingFacade.Resource resource) {
        return resource.getTranslationObjectType() == TranslationObjectType.CONTENTFRAGMENT;
    }

    private static boolean isDamAsset(SmartlingFacade.Resource resource) {
        return resource.getTranslationObjectType() == TranslationObjectType.ASSET;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindLanguageManager(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    protected void unbindLanguageManager(LanguageManager languageManager) {
        if (this.languageManager == languageManager) {
            this.languageManager = null;
        }
    }
}

