/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.smartling.aem.connector.core.NetworkSettings;
import com.smartling.aem.connector.core.SmartlingConfig;
import com.smartling.aem.connector.core.impl.config.ProjectMetadata;
import com.smartling.api.v2.authentication.AuthenticationApiFactory;
import com.smartling.api.v2.client.AbstractApiFactory;
import com.smartling.api.v2.client.ClientConfiguration;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.DefaultClientConfiguration;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.Authenticator;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import com.smartling.api.v2.client.useragent.LibNameVersionHolder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={ApiInstanceBuilder.class})
@Component(label="Smartling - API SDK Configuration (Touch)", immediate=true, metatype=true, description="Allows to set custom API endpoint and manage API Authentication cache.")
public class ApiInstanceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiInstanceBuilder.class);
    private static final long CACHE_TTL = 7L;
    public static final String DEFAULT_API_HOST = "https://api.smartling.com";
    @Property(label="API Host", description="If empty then default 'https://api.smartling.com' will be used.", value={"https://api.smartling.com"})
    public static final String API_HOST = "api.host";
    private String apiHost;
    public static final boolean DEFAULT_ENABLED_API_AUTH_CACHE = true;
    @Property(label="Enable API Authentication Cache", description="Enables Auth cache over all API clients", boolValue={true})
    public static final String ENABLED_API_AUTH_CACHE = "api.cache.auth.enabled";
    private boolean useAuthCache;
    @Reference
    private NetworkSettings networkSettings;
    @Reference
    private ProjectMetadata projectMetadata;
    private ClientFactory clientFactory;
    private ClientConfiguration clientConfiguration;
    private Cache<String, Authenticator> authenticatorCache;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.apiHost = (String)StringUtils.defaultIfEmpty((CharSequence)PropertiesUtil.toString((Object)properties.get(API_HOST), null), (CharSequence)DEFAULT_API_HOST);
        this.useAuthCache = PropertiesUtil.toBoolean((Object)properties.get(ENABLED_API_AUTH_CACHE), (boolean)true);
        this.authenticatorCache = CacheBuilder.newBuilder().expireAfterWrite(7L, TimeUnit.HOURS).build();
        this.clientFactory = new ClientFactory();
        this.clientConfiguration = this.getClientConfiguration();
    }

    public ClientFactory getClientFactory() {
        return this.clientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T buildClient(AbstractApiFactory<T> apiFactory, SmartlingConfig config) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(apiFactory.getClass().getClassLoader());
            T t = this.buildApi(apiFactory, config.getUserIdentifier(), config.getTokenSecret());
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public String getApiHost() {
        return this.apiHost;
    }

    private <T> T buildApi(AbstractApiFactory<T> apiFactory, String userIdentifier, String userSecret) {
        Objects.requireNonNull(userIdentifier, "userIdentifier must be defined");
        Objects.requireNonNull(userSecret, "userSecret must be defined");
        Authenticator authenticator = this.getAuthenticator(userIdentifier, userSecret);
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(authenticator);
        return (T)apiFactory.buildApi((AuthorizationRequestFilter)bearerAuthSecretFilter, this.clientConfiguration);
    }

    private ClientConfiguration getClientConfiguration() {
        DefaultClientConfiguration.DefaultClientConfigurationBuilder defaultClientConfigurationBuilder = DefaultClientConfiguration.builder();
        if (this.networkSettings.isProxyEnabled()) {
            HttpClientConfiguration httpClientConfiguration = new HttpClientConfiguration();
            httpClientConfiguration.setProxyHost(this.networkSettings.getProxyHost());
            httpClientConfiguration.setProxyPort(this.networkSettings.getProxyPort().intValue());
            if (this.networkSettings.requireProxyAuthentication()) {
                httpClientConfiguration.setProxyUser(this.networkSettings.getProxyUser());
                httpClientConfiguration.setProxyPassword(this.networkSettings.getProxyPassword());
            }
            defaultClientConfigurationBuilder.httpClientConfiguration(httpClientConfiguration);
        }
        LibNameVersionHolder libNameVersionHolder = new LibNameVersionHolder(this.projectMetadata.getName(), this.projectMetadata.getVersion());
        defaultClientConfigurationBuilder.libNameVersionHolder(libNameVersionHolder);
        try {
            defaultClientConfigurationBuilder.baseUrl(new URL(this.apiHost));
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Couldn't set apiHost=\"{}\" for client API configuration", (Object)this.apiHost, (Object)ex);
        }
        return defaultClientConfigurationBuilder.build();
    }

    private Authenticator getAuthenticator(String userIdentifier, String userSecret) {
        if (!this.useAuthCache) {
            return this.createAuthenticator(userIdentifier, userSecret);
        }
        String key = this.createCacheKey(userIdentifier, userSecret);
        try {
            return (Authenticator)this.authenticatorCache.get((Object)key, () -> this.createAuthenticator(userIdentifier, userSecret));
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to obtain token provider from cache by key {}", (Object)key, (Object)e);
            return new Authenticator(userIdentifier, userSecret, new AuthenticationApiFactory(this.clientFactory).buildApi());
        }
    }

    private Authenticator createAuthenticator(String userIdentifier, String userSecret) {
        return new Authenticator(userIdentifier, userSecret, new AuthenticationApiFactory(this.clientFactory).buildApi(this.clientConfiguration));
    }

    private String createCacheKey(String userIdentifier, String userSecret) {
        return userIdentifier.concat(userSecret);
    }

    protected void bindNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    protected void unbindNetworkSettings(NetworkSettings networkSettings) {
        if (this.networkSettings == networkSettings) {
            this.networkSettings = null;
        }
    }

    protected void bindProjectMetadata(ProjectMetadata projectMetadata) {
        this.projectMetadata = projectMetadata;
    }

    protected void unbindProjectMetadata(ProjectMetadata projectMetadata) {
        if (this.projectMetadata == projectMetadata) {
            this.projectMetadata = null;
        }
    }
}

