/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.jobs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.integration.platform.CustomField;
import com.smartling.aem.connector.core.impl.integration.platform.CustomFieldValue;
import com.smartling.aem.connector.core.impl.integration.platform.Job;
import com.smartling.aem.connector.core.impl.integration.platform.JobApiClient;
import com.smartling.api.jobs.v3.TranslationJobsApi;
import com.smartling.api.jobs.v3.pto.AddLocaleCommandPTO;
import com.smartling.api.jobs.v3.pto.PagingCommandPTO;
import com.smartling.api.jobs.v3.pto.ProjectCustomFieldFilterPTO;
import com.smartling.api.jobs.v3.pto.SortCommandPTO;
import com.smartling.api.jobs.v3.pto.SourceFilePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobAddFileCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobAuthorizeCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCancelCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCreateCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCreateResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobCustomFieldPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobGetResponsePTO;
import com.smartling.api.jobs.v3.pto.TranslationJobListCommandPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobListItemPTO;
import com.smartling.api.jobs.v3.pto.TranslationJobUpdateCommandPTO;
import com.smartling.api.v2.client.exception.RestApiRuntimeException;
import com.smartling.api.v2.response.Error;
import com.smartling.api.v2.response.ListResponse;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;

class JobApiV3Client
implements JobApiClient {
    private final TranslationJobsApi jobApi;
    private final String projectId;

    JobApiV3Client(TranslationJobsApi jobApi, String projectId) {
        this.jobApi = Objects.requireNonNull(jobApi);
        this.projectId = Objects.requireNonNull(projectId);
    }

    @Override
    public String createJob(String name, Collection<String> languageCodes, Date dueDate) throws SmartlingException {
        return this.createJob(name, languageCodes, dueDate, null);
    }

    @Override
    public String createJob(String name, Collection<String> languageCodes, Date dueDate, List<CustomFieldValue> customFields) throws SmartlingException {
        TranslationJobCreateCommandPTO jobCreateCommand = new TranslationJobCreateCommandPTO();
        jobCreateCommand.setJobName(name);
        jobCreateCommand.setTargetLocaleIds((List)Lists.newArrayList(languageCodes));
        jobCreateCommand.setDueDate(JobApiV3Client.toGmtString(dueDate));
        if (customFields != null && !customFields.isEmpty()) {
            List fields = customFields.stream().map(field -> new TranslationJobCustomFieldPTO(field.getFieldUid(), field.getFieldName(), field.getFieldValue())).collect(Collectors.toList());
            jobCreateCommand.setCustomFields(fields);
        }
        try {
            TranslationJobCreateResponsePTO response = this.jobApi.createTranslationJob(this.projectId, jobCreateCommand);
            return response.getTranslationJobUid();
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to create job for project %s: %s", this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public void cancelJob(String jobUid, String reason) throws SmartlingException {
        TranslationJobCancelCommandPTO jobCancelCommand = new TranslationJobCancelCommandPTO();
        jobCancelCommand.setReason(reason);
        try {
            this.jobApi.cancelTranslationJob(this.projectId, jobUid, jobCancelCommand);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to cancel job %s for project %s: %s", jobUid, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    private static String toGmtString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(date);
    }

    @Override
    public void updateJob(String translationJobUid, String jobName, String description, Date dueDate, List<CustomFieldValue> customFields) throws SmartlingException {
        TranslationJobUpdateCommandPTO translationJobUpdateCommand = new TranslationJobUpdateCommandPTO();
        translationJobUpdateCommand.setJobName(jobName);
        translationJobUpdateCommand.setDescription(description);
        translationJobUpdateCommand.setDueDate(JobApiV3Client.toGmtString(dueDate));
        if (customFields != null) {
            translationJobUpdateCommand.setCustomFields(customFields.stream().map(fieldValue -> new TranslationJobCustomFieldPTO(fieldValue.getFieldUid(), fieldValue.getFieldName(), fieldValue.getFieldValue())).collect(Collectors.toList()));
        }
        try {
            this.jobApi.updateTranslationJob(this.projectId, translationJobUid, translationJobUpdateCommand);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to update job %s for project %s: %s", translationJobUid, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public void addLocaleToJob(String translationJobUid, String locale) {
        this.jobApi.addLocaleToTranslationJob(this.projectId, translationJobUid, locale, new AddLocaleCommandPTO(Boolean.valueOf(false)));
    }

    @Override
    public void addFileToJob(String jobUid, String fileUri, String locale) throws SmartlingException {
        TranslationJobAddFileCommandPTO jobFileCommand = new TranslationJobAddFileCommandPTO();
        jobFileCommand.setFileUri(fileUri);
        jobFileCommand.setTargetLocaleIds((List)ImmutableList.of((Object)locale));
        try {
            this.jobApi.addFileToTranslationJob(this.projectId, jobUid, jobFileCommand);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to add file %s to job %s for project %s: %s", fileUri, jobUid, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public void authorizeJob(String jobUid) throws SmartlingException {
        TranslationJobAuthorizeCommandPTO authorizeCommand = new TranslationJobAuthorizeCommandPTO();
        authorizeCommand.setLocaleWorkflows(Collections.emptyList());
        try {
            this.jobApi.authorizeTranslationJob(this.projectId, jobUid, authorizeCommand);
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to authorize job %s for project %s: %s", jobUid, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public Job loadJob(String jobUid) throws SmartlingException {
        try {
            TranslationJobGetResponsePTO translationJobResponse = this.jobApi.getTranslationJob(this.projectId, jobUid);
            Job job = new Job();
            job.setUid(translationJobResponse.getTranslationJobUid());
            job.setName(translationJobResponse.getJobName());
            job.setDueDate(translationJobResponse.getDueDate());
            job.setTargetLocaleIds(translationJobResponse.getTargetLocaleIds());
            job.setState(Job.State.valueOf(translationJobResponse.getJobStatus()));
            job.setDescription(translationJobResponse.getDescription());
            if (translationJobResponse.getSourceFiles() != null) {
                job.setSourceFiles(translationJobResponse.getSourceFiles().stream().map(SourceFilePTO::getUri).collect(Collectors.toList()));
            }
            if (translationJobResponse.getCustomFields() != null) {
                job.setCustomFields(translationJobResponse.getCustomFields().stream().map(fieldValue -> new CustomFieldValue(fieldValue.getFieldUid(), fieldValue.getFieldName(), fieldValue.getFieldValue())).collect(Collectors.toList()));
            }
            return job;
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to load job %s for project %s: %s", jobUid, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public List<Job> listJobsByState(Collection<Job.State> states) throws SmartlingException {
        TranslationJobListCommandPTO listCommand = new TranslationJobListCommandPTO();
        listCommand.setTranslationJobStatus((List)Lists.newArrayList(this.mapToName(states)));
        try {
            PagingCommandPTO pagingCommand = new PagingCommandPTO();
            pagingCommand.setOffset(Integer.valueOf(0));
            pagingCommand.setLimit(Integer.valueOf(Integer.MAX_VALUE));
            ListResponse listResponse = this.jobApi.listTranslationJobs(this.projectId, listCommand, pagingCommand, new SortCommandPTO());
            return listResponse.getItems().stream().map(JobApiV3Client.toJob()).collect(Collectors.toList());
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to list jobs for project %s: %s", this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public List<Job> listJobsByName(String name) throws SmartlingException {
        TranslationJobListCommandPTO listCommand = new TranslationJobListCommandPTO();
        listCommand.setJobName(name);
        try {
            ListResponse listResponse = this.jobApi.listTranslationJobs(this.projectId, listCommand, new PagingCommandPTO(), new SortCommandPTO());
            return listResponse.getItems().stream().map(JobApiV3Client.toJob()).collect(Collectors.toList());
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to list jobs contained name=\"%s\" for project %s: %s", name, this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    @Override
    public List<CustomField> listProjectCustomFields(String projectUID) throws SmartlingException {
        try {
            ListResponse customFields = this.jobApi.getAssignedCustomFieldsToProject(projectUID, new ProjectCustomFieldFilterPTO());
            return customFields.getItems().stream().map(field -> new CustomField(field.getFieldUid(), field.getFieldName(), field.getType(), field.getDefaultValue(), field.getDescription())).collect(Collectors.toList());
        }
        catch (RestApiRuntimeException e) {
            throw new SmartlingException(String.format("Failed to list custom fields for project %s: %s", this.projectId, Joiner.on((String)", ").join(this.mapErrorsToStrings(e.getErrors()))), e);
        }
    }

    private List<String> mapErrorsToStrings(List<Error> errors) {
        return errors.stream().map(input -> input.getKey() + ":" + input.getMessage()).collect(Collectors.toList());
    }

    private Collection<String> mapToName(Collection<Job.State> states) {
        ArrayList<String> result = new ArrayList<String>();
        for (Job.State state : states) {
            result.add(state.name());
        }
        return result;
    }

    private static Function<TranslationJobListItemPTO, Job> toJob() {
        return item -> {
            Job job = new Job();
            job.setUid(item.getTranslationJobUid());
            job.setName(item.getJobName());
            job.setTargetLocaleIds(item.getTargetLocaleIds());
            job.setDueDate(item.getDueDate());
            job.setState(Job.State.valueOf(item.getJobStatus()));
            job.setCreatedDate(item.getCreatedDate());
            return job;
        };
    }

    @Override
    public void close() throws Exception {
        this.jobApi.close();
    }
}

