/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.platform.processor;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.smartling.aem.connector.core.impl.integration.platform.processor.PostDownloadProcessor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ProcessorService {
    private List<PostDownloadProcessor> processors = Lists.newLinkedList();

    public ProcessorService(PostDownloadProcessor ... processors) {
        Collections.addAll(this.processors, processors);
    }

    public byte[] process(final byte[] content) {
        FluentIterable supportedProcessors = FluentIterable.from(this.processors).filter((Predicate)new Predicate<PostDownloadProcessor>(){

            public boolean apply(@Nullable PostDownloadProcessor input) {
                return input.supports(content);
            }
        });
        byte[] processedContent = content;
        for (PostDownloadProcessor processor : supportedProcessors) {
            processedContent = processor.process(processedContent);
        }
        return processedContent;
    }
}

