/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl;

import com.smartling.aem.connector.context.ContextConnectionManager;
import com.smartling.aem.connector.core.TranslationStartedEvent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
@Property(name="event.topics", value={"com/smartling/aem/connector/TranslationStarted"})
public class TranslationStartEventHandler
implements EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationStartedEvent.class);
    @Reference
    private ContextConnectionManager contextConnectionManager;

    public void handleEvent(Event event) {
        try {
            LOGGER.trace("Translation is started. Initialization of context");
            this.contextConnectionManager.initializeContext().get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.warn("Failed to wait for context initialization:", (Throwable)e);
        }
    }

    protected void bindContextConnectionManager(ContextConnectionManager contextConnectionManager) {
        this.contextConnectionManager = contextConnectionManager;
    }

    protected void unbindContextConnectionManager(ContextConnectionManager contextConnectionManager) {
        if (this.contextConnectionManager == contextConnectionManager) {
            this.contextConnectionManager = null;
        }
    }
}

