/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection.config;

import com.smartling.aem.connector.context.impl.ContextLockSettings;
import com.smartling.aem.connector.context.impl.connection.config.ContextLockService;
import java.util.Calendar;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ContextLockService.class})
public class SmartlingContextContextLockService
implements ContextLockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingContextContextLockService.class);
    public static final String CONTEXT_LOCK_NODE_PATH = "/var/smartling-connector/contextLock";
    private static final String FLAG_TIMESTAMP_PROP_NAME = "flagTimestamp";
    private static final String OWNER_PROP_NAME = "owner";
    @Reference
    private ResourceResolverFactory resolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(ContextLockSettings captureSettings) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            Resource configResource = resourceResolver.resolve(CONTEXT_LOCK_NODE_PATH);
            Node node = (Node)configResource.adaptTo(Node.class);
            Node lockNode = this.getOrCreateLockNode(node, captureSettings.getProjectUid());
            if (lockNode == null) {
                boolean bl = false;
                return bl;
            }
            if (this.isFlagTimestampExceeded(lockNode, captureSettings.getExpirationPeriodInSeconds())) {
                this.writeTimestamp(lockNode);
                if (!this.writeOwner(lockNode, captureSettings.getOwnerName())) {
                    boolean bl = false;
                    return bl;
                }
                boolean isOwner = StringUtils.equalsIgnoreCase((CharSequence)lockNode.getProperty(OWNER_PROP_NAME).getString(), (CharSequence)captureSettings.getOwnerName());
                if (isOwner) {
                    LOGGER.info("\"{}\" is new context lock owner for projectUid=\"{}\".", (Object)captureSettings.getOwnerName(), (Object)captureSettings.getProjectUid());
                }
                boolean bl = isOwner;
                return bl;
            }
        }
        catch (RepositoryException ex) {
            LOGGER.error("General repository error.", (Throwable)ex);
        }
        catch (LoginException ex) {
            LOGGER.error("Couldn't login for a new resource resolver.", (Throwable)ex);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renewLock(ContextLockSettings captureSettings) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            Resource configResource = resourceResolver.resolve(CONTEXT_LOCK_NODE_PATH);
            Node node = (Node)configResource.adaptTo(Node.class);
            Node lockNode = this.getOrCreateLockNode(node, captureSettings.getProjectUid());
            if (lockNode == null) {
                boolean bl = false;
                return bl;
            }
            if (!lockNode.hasProperty(OWNER_PROP_NAME) || !StringUtils.equalsIgnoreCase((CharSequence)lockNode.getProperty(OWNER_PROP_NAME).getString(), (CharSequence)captureSettings.getOwnerName())) {
                LOGGER.warn("User \"{}\" wasn't able to keep context lock for projectUid=\"{}\".", (Object)captureSettings.getOwnerName(), (Object)captureSettings.getProjectUid());
                boolean bl = false;
                return bl;
            }
            if (this.isFlagTimestampExceeded(lockNode, captureSettings.getKeepAlivePeriodInSeconds())) {
                this.writeTimestamp(lockNode);
            }
            boolean bl = StringUtils.equalsIgnoreCase((CharSequence)lockNode.getProperty(OWNER_PROP_NAME).getString(), (CharSequence)captureSettings.getOwnerName());
            return bl;
        }
        catch (RepositoryException ex) {
            LOGGER.error("General repository error.", (Throwable)ex);
        }
        catch (LoginException ex) {
            LOGGER.error("Couldn't login for a new resource resolver.", (Throwable)ex);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unlock(ContextLockSettings captureSettings) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.emptyMap());
            Resource configResource = resourceResolver.resolve(CONTEXT_LOCK_NODE_PATH);
            Node node = (Node)configResource.adaptTo(Node.class);
            Node lockNode = this.getOrCreateLockNode(node, captureSettings.getProjectUid());
            if (lockNode == null) {
                boolean bl = true;
                return bl;
            }
            if (lockNode.hasProperty(OWNER_PROP_NAME) && !StringUtils.equalsIgnoreCase((CharSequence)lockNode.getProperty(OWNER_PROP_NAME).getString(), (CharSequence)captureSettings.getOwnerName())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.removeTimestamp(lockNode);
            return bl;
        }
        catch (RepositoryException ex) {
            LOGGER.error("General repository error.", (Throwable)ex);
        }
        catch (LoginException ex) {
            LOGGER.error("Couldn't login for a new resource resolver.", (Throwable)ex);
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return false;
    }

    private Node getOrCreateLockNode(Node contextNode, String projectUid) {
        try {
            if (contextNode == null) {
                return null;
            }
            Node lockNode = JcrUtils.getOrAddNode((Node)contextNode, (String)projectUid, (String)"nt:unstructured");
            lockNode.getSession().save();
            return lockNode;
        }
        catch (RepositoryException ex) {
            LOGGER.info("Couldn't get tryLock node.", (Throwable)ex);
            return null;
        }
    }

    private boolean isFlagTimestampExceeded(Node lockNode, int flagLifetimeInSeconds) {
        try {
            if (!lockNode.hasProperty(FLAG_TIMESTAMP_PROP_NAME)) {
                return true;
            }
            Calendar timestamp = lockNode.getProperty(FLAG_TIMESTAMP_PROP_NAME).getDate();
            if (timestamp == null) {
                return true;
            }
            timestamp.add(13, flagLifetimeInSeconds);
            return Calendar.getInstance().compareTo(timestamp) > 0;
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    private boolean writeTimestamp(Node lockNode) {
        try {
            Session session = lockNode.getSession();
            lockNode.setProperty(FLAG_TIMESTAMP_PROP_NAME, Calendar.getInstance());
            session.save();
            return true;
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    private boolean removeTimestamp(Node lockNode) {
        try {
            if (!lockNode.hasProperty(FLAG_TIMESTAMP_PROP_NAME) || !lockNode.hasProperty(OWNER_PROP_NAME)) {
                return false;
            }
            Session session = lockNode.getSession();
            lockNode.getProperty(FLAG_TIMESTAMP_PROP_NAME).remove();
            lockNode.getProperty(OWNER_PROP_NAME).remove();
            session.save();
            return true;
        }
        catch (RepositoryException ex) {
            return false;
        }
    }

    private boolean writeOwner(Node node, String ownerName) {
        try {
            node.setProperty(OWNER_PROP_NAME, ownerName);
            node.getSession().save();
            Thread.sleep(100L);
            return StringUtils.equalsIgnoreCase((CharSequence)node.getProperty(OWNER_PROP_NAME).getString(), (CharSequence)ownerName);
        }
        catch (InterruptedException | RepositoryException ex) {
            return false;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

