/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources.http;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingConnectionException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingCredentialsException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceLoadingLoginException;
import com.smartling.aem.connector.context.impl.resources.ResourceStream;
import com.smartling.aem.connector.core.NetworkSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(label="Smartling - Context Preview Settings (Touch)", metatype=true, description="Configure, how translators will preview pages in TMS. Mandatory to have context working.")
public class HttpResourceLoader
implements ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceLoader.class);
    static final String CONFIGURATION_NAME = "Smartling - Context Preview Settings (Touch)";
    public static final String MISSING_CREDENTIAL_CONFIGURATION_ERROR_MESSAGE = "Missing credential configuration for resource loading";
    public static final String INTERNAL_ERROR_MESSAGE = "Failed to load resource: internal error";
    public static final String URL_WRONG_FORMAT_ERROR = "Failed to load resource: URL \"%s\" has wrong format";
    @Property(label="Server URL", description="Format: http://<host>:<port> OR https://<host>:<port>. Please, note that localhost and 127.0.0.1 are NOT supported.")
    private static final String SERVER_URL_PROP = "server.url";
    @Property(label="User", description="AEM User, used to capture context")
    private static final String USER_NAME_PROP = "user.name";
    @Property(label="Password", passwordValue={""}, description="Password for this user. It's RECOMMENDED TO PROTECT password using Crypto Support tool.")
    private static final String USER_PASSWORD_PROP = "user.password";
    private static final int CONNECTION_TIMEOUT_MIN = 2000;
    private static final int CONNECTION_TIMEOUT_MAX = 10000;
    @Property(label="Connection timout", intValue={2000}, description="Connection timout for loading context from AEM instance in ms. Min 2000ms, Max 10000ms")
    private static final String CONNECTION_TIMEOUT_PROP = "connection.timeout";
    private static final int SOCKET_TIMEOUT_MIN = 10000;
    private static final int SOCKET_TIMEOUT_MAX = 20000;
    @Property(label="Socket timeout", intValue={10000}, description="Socket timout for loading context from AEM instance in ms.  Min 10000ms, Max 20000ms")
    private static final String SOCKET_TIMEOUT_PROP = "socket.timout";
    private static final String WCMMODE_DEFAULT = "disabled";
    @Property(label="Preview WCMMODE", description="This mode is used for requesting a context", value={"disabled"})
    private static final String WCMMODE_PROP = "request.wcmmode";
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private NetworkSettings networkSettings;
    private String serverUrl;
    private String username;
    private String password;
    private int connectionTimeout;
    private int socketTimeout;
    private String wcmmode;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        String rawServerUrl = PropertiesUtil.toString((Object)properties.get(SERVER_URL_PROP), (String)"");
        this.serverUrl = StringUtils.removeEnd((String)rawServerUrl, (String)"/");
        this.username = PropertiesUtil.toString((Object)properties.get(USER_NAME_PROP), (String)"");
        this.password = PropertiesUtil.toString((Object)properties.get(USER_PASSWORD_PROP), (String)"");
        this.connectionTimeout = PropertiesUtil.toInteger((Object)properties.get(CONNECTION_TIMEOUT_PROP), (int)2000);
        this.connectionTimeout = Math.max(this.connectionTimeout, 2000);
        this.connectionTimeout = Math.min(this.connectionTimeout, 10000);
        this.socketTimeout = PropertiesUtil.toInteger((Object)properties.get(SOCKET_TIMEOUT_PROP), (int)10000);
        this.socketTimeout = Math.max(this.socketTimeout, 10000);
        this.socketTimeout = Math.min(this.socketTimeout, 20000);
        if (StringUtils.isEmpty((CharSequence)this.serverUrl) || StringUtils.isEmpty((CharSequence)this.username) || StringUtils.isEmpty((CharSequence)this.password)) {
            LOGGER.error("Missing mandatory configuration");
        }
        try {
            if (this.cryptoSupport.isProtected(this.password)) {
                this.password = this.cryptoSupport.unprotect(this.password);
            } else {
                LOGGER.warn("Unprotected password is used in '{}' configuration.", (Object)CONFIGURATION_NAME);
            }
        }
        catch (CryptoException e) {
            LOGGER.error("Failed to unprotect password.", (Throwable)e);
        }
        this.wcmmode = PropertiesUtil.toString((Object)properties.get(WCMMODE_PROP), (String)WCMMODE_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceStream loadResource(String uri) throws ResourceLoadingException {
        String url = this.buildFullUrl(uri);
        try {
            Throwable throwable = null;
            try (CloseableHttpClient httpClient = this.createHttpClient();){
                ResourceStream resourceStream;
                this.logIn(httpClient);
                LOGGER.info("Started to load resource for fileUri=\"{}\"", (Object)url);
                long startTime = System.nanoTime();
                try {
                    resourceStream = this.loadResource(url, httpClient);
                }
                catch (Throwable throwable2) {
                    try {
                        long elapsedTime = (System.nanoTime() - startTime) / 1000000L;
                        LOGGER.info("Loading of resource fileUri=\"{}\" is completed in elapsedTime=\"{}\" ms", (Object)url, (Object)elapsedTime);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                long elapsedTime = (System.nanoTime() - startTime) / 1000000L;
                LOGGER.info("Loading of resource fileUri=\"{}\" is completed in elapsedTime=\"{}\" ms", (Object)url, (Object)elapsedTime);
                return resourceStream;
            }
        }
        catch (HttpHostConnectException e) {
            throw new ResourceLoadingConnectionException(INTERNAL_ERROR_MESSAGE, (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(INTERNAL_ERROR_MESSAGE, e);
        }
        catch (URISyntaxException e) {
            throw new ResourceLoadingException(String.format(URL_WRONG_FORMAT_ERROR, url), e);
        }
    }

    @Override
    public String getWcmmode() {
        return this.wcmmode;
    }

    private ResourceStream loadResource(String url, CloseableHttpClient httpClient) throws ResourceLoadingException, IOException, URISyntaxException {
        URI uri = this.getEncodedUri(url);
        LOGGER.debug("Loading resource uri=\"{}\"", (Object)uri);
        HttpGet request = new HttpGet(uri);
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                ResourceStream resourceStream = HttpResourceLoader.createResourceStream((HttpResponse)response, url);
                return resourceStream;
            }
            try {
                throw new ResourceLoadingException(String.format("Could not load resource url=\"%s\". HTTP code: %d. Response headers %s. Body:\n%s", url, status, HttpResourceLoader.getHeaders((HttpMessage)response), HttpResourceLoader.getContentFirstPart((HttpResponse)response, 500)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private URI getEncodedUri(String url) throws ResourceLoadingException, IOException, URISyntaxException {
        try {
            while (StringUtils.contains((CharSequence)url, (CharSequence)"%")) {
                url = URLDecoder.decode(url, StandardCharsets.UTF_8.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ResourceLoadingException(String.format(URL_WRONG_FORMAT_ERROR, url), e);
        }
        URL parsedUrl = new URL(url);
        return new URI(parsedUrl.getProtocol(), parsedUrl.getUserInfo(), parsedUrl.getHost(), parsedUrl.getPort(), parsedUrl.getPath(), parsedUrl.getQuery(), parsedUrl.getRef());
    }

    private void logIn(CloseableHttpClient httpClient) throws ResourceLoadingException, IOException {
        LOGGER.debug("Logging in to host=\"{}\" as user=\"{}\"", (Object)this.serverUrl, (Object)this.username);
        if (StringUtils.isEmpty((CharSequence)this.serverUrl) || StringUtils.isEmpty((CharSequence)this.username) || StringUtils.isEmpty((CharSequence)this.password)) {
            LOGGER.error(MISSING_CREDENTIAL_CONFIGURATION_ERROR_MESSAGE);
            throw new ResourceLoadingCredentialsException("Failed to log in. Missing credential configuration for resource loading");
        }
        HttpPost loginRequest = new HttpPost(this.serverUrl + "/libs/granite/core/content/login/j_security_check");
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("j_username", this.username));
        parameters.add(new BasicNameValuePair("j_password", this.password));
        loginRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)loginRequest);){
            int status = response.getStatusLine().getStatusCode();
            if (status >= 400) {
                throw new ResourceLoadingLoginException(String.format("Failed to log in. HTTP code: %d. Response headers %s. Body:\n%s", status, HttpResourceLoader.getHeaders((HttpMessage)response), HttpResourceLoader.getContentFirstPart((HttpResponse)response, 500)));
            }
        }
    }

    private CloseableHttpClient createHttpClient() {
        RequestConfig requestConfigWithTimeouts = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigWithTimeouts);
        if (this.networkSettings.isProxyEnabled()) {
            HttpHost proxyHost = new HttpHost(this.networkSettings.getProxyHost(), this.networkSettings.getProxyPort().intValue());
            httpClientBuilder = httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxyHost));
            if (this.networkSettings.requireProxyAuthentication()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.networkSettings.getProxyUser(), this.networkSettings.getProxyPassword()));
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return httpClientBuilder.build();
    }

    private static ResourceStream createResourceStream(HttpResponse response, String url) throws IOException {
        String contentType = HttpResourceLoader.getHeaderValueOrNull(response.getEntity().getContentType());
        String encoding = HttpResourceLoader.getEncoding(response);
        ByteArrayInputStream stream = new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        ResourceStream resourceStream = new ResourceStream(stream, encoding, contentType);
        resourceStream.setBaseUrl(url);
        return resourceStream;
    }

    private static String getHeaderValueOrNull(Header header) {
        return header != null ? header.getValue() : null;
    }

    private static String getEncoding(HttpResponse response) {
        String encoding = HttpResourceLoader.getHeaderValueOrNull(response.getEntity().getContentEncoding());
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            ContentType contentType = ContentType.get((HttpEntity)response.getEntity());
            encoding = contentType != null && contentType.getCharset() != null ? contentType.getCharset().name() : Consts.UTF_8.name();
        }
        return encoding;
    }

    private static String getContentFirstPart(HttpResponse response, int size) throws IOException {
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)HttpResourceLoader.getEncoding(response));
        return StringUtils.substring((String)responseBody, (int)0, (int)size);
    }

    private static String getHeaders(HttpMessage message) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Header header : message.getAllHeaders()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(String.format("name=\"%s\": value=\"%s\"", header.getName(), header.getValue()));
        }
        return sb.toString();
    }

    private String buildFullUrl(String uri) {
        if (uri.matches("/[\\w,\\W]*")) {
            if (this.serverUrl.startsWith("http://localhost")) {
                LOGGER.warn("Using localhost as a server URL may break page context. See {} OSGi configuration", (Object)CONFIGURATION_NAME);
            }
            return this.serverUrl + uri;
        }
        return uri;
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    protected void unbindNetworkSettings(NetworkSettings networkSettings) {
        if (this.networkSettings == networkSettings) {
            this.networkSettings = null;
        }
    }
}

