/*
 ADOBE CONFIDENTIAL

 Copyright 2016 Adobe Systems Incorporated
 All Rights Reserved.

 NOTICE:  All information contained herein is, and remains
 the property of Adobe Systems Incorporated and its suppliers,
 if any.  The intellectual and technical concepts contained
 herein are proprietary to Adobe Systems Incorporated and its
 suppliers and may be covered by U.S. and Foreign Patents,
 patents in process, and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material
 is strictly forbidden unless prior written permission is obtained
 from Adobe Systems Incorporated.
 */
(function(document, XSS, $) {

    "use strict";
    var saveWizardSelector = '.foundation-wizard-control-save-button';
    var cancelWizard = '#rules-edit-form coral-panel-content a';
    var contextSelector = '.foundation-collection-context-selector';
    var pathBrowserClass = '.context-selector-pathbrowser';
    var pathBrowserType = 'pathbrowser-type';
    var accordionItemSelector = 'coral-accordion-item';
    var accordionLabelSelector = 'coral-accordion-item-label i';
    var addComponentButtonClass = '.addComponentDialogButton';
    var pathBrowserButtonSelector = '#context-selection-pathbrowser-button';
    var componentsSelector = '.context-properties-accordion';
    var filtersSelector = '.filter-properties-list';
    var assetNodeSelector = '.assetnode-properties-list';
    var componentnameattr = "componentname";
    var newPropertyNameSelector = '.newPropertyName';
    var deletePropertySelector = '.deleteProp';
    var componentPathField = '#componentPath';
    var addPropertyButtonSelector = '.addComponentProperty';
    var assetNodeResourceType = '.assetNodeResourceType';
    var assetReferenceType = '.assetReferenceType';
    var addReferenceButton = '.addReferenceButton';
    var filterProperty = '.propertyName';
    var filterValue = '.filterValue';
    var addFilterButton = '.addFiltersButton';
    var inheritCheckBoxSelector = ".inheritCheck";
    var checkBoxSelector = 'coral-checkbox';
    var translateAsTextColumn = 2; // Changed by Smartling
    var inheritColumn = 3; // Changed by Smartling
    var isDeepColumn = 2;
    var checkInChildNodesColumn = 1;
    var createLangCopyColumn = 2;
    var contextJson;
    var isRuleModified = false;
    var queryParam;
    var rulesActionBarSelector = '.rulesActionBar';
    var pageURL = "/libs/cq/translation/translationrules/contexts.translationRulesEditor.html";
    var changeContextURL = "/libs/cq/translation/translationrules/contextproperties.html?context=";
    var contextListURL = Granite.HTTP.getContextPath() + '/libs/cq/translation/translationrules/contexts.html';
    var footer = '<button is="coral-button" variant="primary" coral-close="" size="M">' + Granite.I18n.get("Close") + '</button>';
    var data = {
        ":operation" : "GET_CONTEXT_RULES",
        ":context" : getURLParameter("context")
    };

    // Smartling customizations

    var smartlingPropertyMappingURL = "/services/smartling/property-mappings";
    var parserDefaultValue = 'html';
    function initializeSmartlingPropertyMapping() {
        $.ajax({
            url: smartlingPropertyMappingURL,
            type: "get",
            data: data,
            success: function(response) {
                initialize(response);
            },
            error: function(xhr) {
                $(cancelWizard).attr('href',contextListURL);
                var errorContent = 'No Smartling Property mapping Found. Try to <a href="/libs/granite/ui/content/dumplibs.rebuild.html">flush</a> AEM UI cache';
                showDialog("ErrorLoadingContexts", "error", Granite.I18n.get("Failed to Load Smartling Property mapping"), errorContent, footer);
            }
        });
    }

    function applySmartlingPropertyMappings(mappings) {
        for(var compName in contextJson['properties']) {
            for(var propName in contextJson['properties'][compName]) {
                if (propName !== 'componentName') {
                    var component = ((mappings || {}).components || []).filter(function(cmp) { return cmp.type === compName; })[0] || {};
                    var property = (component.mappings || []).filter(function(m) { return m.propertyName === propName; })[0] || {};
                    contextJson['properties'][compName][propName].parser = property.smartlingParser || parserDefaultValue;
                }
            }
        }
    }

    function saveSmartlingPropertyMapping() {
        var contextName = getURLParameter("context");
        var smartlingData = { 'path' : contextName, 'components': [] };

        for(var comp in contextJson['properties']) {
            var component = { 'type': comp, 'mappings': [] };
            for(var prop in contextJson['properties'][comp]) {
                component.mappings.push({ 'propertyName': prop, 'smartlingParser': contextJson['properties'][comp][prop].parser, 'inherit': contextJson['properties'][comp][prop].inherit });
                delete contextJson['properties'][comp][prop].parser;
            }
            smartlingData.components.push(component);
        }

        var data = {
            "data" : JSON.stringify(smartlingData),
            "_charset_" : "utf-8"
        };
        $.ajax({
            url: smartlingPropertyMappingURL,
            type: "post",
            data: data,
            success: function(response) {
                redirect(contextListURL);
            },
            error: function(xhr) {
                //Do Something to handle error
                showDialog("ErrorAddingContexts", "error", Granite.I18n.get("Failed"), Granite.I18n.get("Error saving smartling property mappings"), footer);
            }
        });
    }

    // End of Smartling custom functions

    $.ajax({
        url: pageURL,
        type: "get",
        data: data,
        success: function(response) {
            contextJson = response;
            initializeSmartlingPropertyMapping(); // Changed by Smartling
        },
        error: function(xhr) {
            $(cancelWizard).attr('href',contextListURL);
            showDialog("ErrorLoadingContexts", "error", Granite.I18n.get("Failed to Load Properties"), Granite.I18n.get("No Properties Found"), footer);
        }
    });

    function initialize(smartlingMappings) {
        $(document).ready(function() {
            Coral.commons.ready(document, function () {
                var pathbrowser = $.find(pathBrowserClass);
                setContextTitle();
                setContextProperties();
                createPathBrowser(pathbrowser[0]);
                applySmartlingPropertyMappings(smartlingMappings);
                $(inheritCheckBoxSelector).hide();
                contextJson["contexts"].sort();
                $(document).on("keyup", [assetNodeResourceType, assetReferenceType], setAddReferenceButton);
                $(document).on("keyup", [filterProperty, filterValue], setAddFilterButton);
                $(document).on("keyup", componentPathField, setAddComponentButton);
                $(componentsSelector).on("keyup", (newPropertyNameSelector), function() {
                    setAddPropertyButton(this);
                });

                $('coral-tablist').on("coral-tablist:change", function(e) {
                    toggleAddComponentButton(e);
                });

                $(document).on("click", cancelWizard, function() {
                    footer = '<button is="coral-button" variant="primary" class="cancelSavingContext" size="M">' + Granite.I18n.get('Yes') + '</button>'
                        + '<button is="coral-button" variant="secondary" coral-close="" size="M">' + Granite.I18n.get('No') + '</button>';
                    showDialog("exitContext", "warning", Granite.I18n.get("Cancel"), Granite.I18n.get("Are you sure you want to exit ?"), footer);
                });

                $(document).on("click", '.cancelSavingContext', function() {
                    redirect(contextListURL);
                });

                $('.selectFilterType').on("change", function() {
                    var filterType = $('.selectFilterType')[0].value;
                    if ( "node-filter" == filterType) {
                        $('.filterCriteria').attr("hidden", false);
                        $('.propertyName').attr("hidden", false);
                        $($('.filterStmt')[0]).html(Granite.I18n.get("Filter out nodes containing property "));
                        $($('.filterCriteria')[0]).html(Granite.I18n.get(" equal to "));
                        $('.filterValue').attr("placeholder", Granite.I18n.get("property value"));
                        $('.filterValue').removeAttr("value");
                    }
                    else if ( "property-filter" == filterType){
                        $('.filterCriteria').attr("hidden", false);
                        $('.propertyName').attr("hidden", false);
                        $($('.filterStmt')[0]).html(Granite.I18n.get("Filter out property "));
                        $($('.filterCriteria')[0]).html(Granite.I18n.get(" if path contains "));
                        $('.filterValue').attr("placeholder", Granite.I18n.get("path value"));
                        $('.filterValue').removeAttr("value");
                    } else {
                        $($('.filterStmt')[0]).html(Granite.I18n.get("Filter out content from translation jobs where property cq:tags contains "));
                        $('.filterCriteria').attr("hidden", true);
                        $('.filterValue').attr("placeholder", Granite.I18n.get("tag name"));
                        $('.filterValue').attr("value", "do-not-translate");
                        $('.propertyName').attr("hidden", true);
                    }
                    setAddFilterButton();
                });

                $('.addReferenceButton').click(function() {
                    var resourceType = $('.assetNodeResourceType')[0].value;
                    var referenceType = $('.assetReferenceType')[0].value;
                    if (!bCheckIfReferenceExists(resourceType, referenceType)) {
                        var assetNode = {};
                        assetNode.resourceType = resourceType;
                        assetNode.referenceType = referenceType;
                        contextJson['references']['assetNodes'].push(assetNode);
                        addRowToAssetNodeListTable(resourceType, referenceType, false, true);
                    } else {
                        var footer = '<button is="coral-button" variant="primary" coral-close="" size="M">' + Granite.I18n.get('Close') + '</button>';
                        var message = $('<p>').text(Granite.I18n.get("Reference with ") + resourceType + ", " + referenceType + Granite.I18n.get(" already exists"))[0].outerHTML;
                        showDialog("duplicate", "warning", Granite.I18n.get("Reference Exists"), message, footer);
                    }
                    $('.assetNodeResourceType')[0].value = "";
                    $('.assetReferenceType')[0].value = "";
                    $(addReferenceButton).prop("disabled", true);
                });

                $('.addFiltersButton').click(function() {
                    var propertyName = $('.propertyName')[0].value;
                    var filterValue = $('.filterValue')[0].value;
                    var filterType = $('.selectFilterType')[0].value;
                    var customCheck = $('.customCheck').checked;
                    var isNode = false;
                    var isProperty = false;
                    if (filterType=="node-filter") {
                        filterType = "Node";
                        isNode = true;
                    } else if (filterType=="property-filter") {
                        filterType = "Property";
                        isProperty = true;
                    } else {
                        $('.propertyName')[0].value = 'cq:tags'
                        propertyName = $('.propertyName')[0].value
                        filterType = "Content";
                    }
                    if (!bCheckIfFilterExists(propertyName, filterValue, filterType)) {
                        var filter={};
                        if (isNode) {
                            filter.propertyName = propertyName;
                            filter.value = filterValue;
                            filter.isDeep = customCheck;
                            contextJson['filter'][filterType].push(filter);
                            addRowToFiltersListTable(propertyName ,filterValue, filterType + " Filter", true);
                        } else if(isProperty){
                            filter.propertyName = propertyName;
                            filter.Path = filterValue;
                            contextJson['filter'][filterType].push(filter);
                            addRowToFiltersListTable(propertyName ,filterValue, filterType + " Filter", true);
                        } else {
                            filter.key = propertyName;
                            filter.value = filterValue;
                            filter.createLanguageCopy = true;
                            contextJson['filter'][filterType].push(filter);
                            addRowToFiltersListTable(propertyName ,filterValue, filterType + " Filter", true);
                        }

                    } else {
                        var footer = '<button is="coral-button" variant="primary" coral-close="" size="M">' + Granite.I18n.get("Close") + '</button>';
                        var message = $('<p>').text(Granite.I18n.get("Filter with ") + propertyName + ", " + filterValue + Granite.I18n.get(" already exists"))[0].outerHTML;
                        showDialog("duplicate", "warning", Granite.I18n.get("Filter Exists"), message, footer);
                    }
                    $('.propertyName')[0].value = "";
                    $('.filterValue')[0].value = "";
                    $(addFilterButton).prop("disabled", true);
                });

                for (var key in contextJson['properties']) {
                    addComponentPropertyToAccordion(key, contextJson['properties'][key]);
                }

                for (var index in contextJson["references"]["assetNodes"]) {
                    var resourceType = contextJson["references"]["assetNodes"][index].resourceType;
                    var referenceType = contextJson["references"]["assetNodes"][index].referenceType;
                    var checkInChildNodes = contextJson["references"]["assetNodes"][index].checkInChildNodes;
                    var createLangCopy = contextJson["references"]["assetNodes"][index].createLangCopy;
                    if (typeof checkInChildNodes === "undefined") {
                        checkInChildNodes = false;
                    }
                    if (typeof createLangCopy === "undefined") {
                        createLangCopy = true;
                    }
                    addRowToAssetNodeListTable(resourceType, referenceType, checkInChildNodes, createLangCopy);
                }

                for (var index in contextJson["filter"]["Node"]) {
                    var nodeFilter = contextJson["filter"]["Node"][index];
                    var propertyName = nodeFilter.propertyName;
                    var propertyValue = nodeFilter.value;
                    var isDeep = nodeFilter.isDeep;
                    addRowToFiltersListTable(propertyName ,propertyValue, "Node Filter", isDeep);
                }

                for (var index in contextJson["filter"]["Property"]) {
                    var propertyFilter = contextJson["filter"]["Property"][index];
                    var propertyName = propertyFilter.propertyName;
                    var path = propertyFilter.Path;
                    addRowToFiltersListTable(propertyName, path, "Property Filter", true);
                }

                for (var index in contextJson["filter"]["Content"]) {
                    var contentFilter = contextJson["filter"]["Content"][index];
                    var createLangCopy = contentFilter.createLanguageCopy;
                    var propertyName = contentFilter.key;
                    var propertyValue = contentFilter.value;
                    addRowToFiltersListTable(propertyName, propertyValue, "Content Filter", createLangCopy);
                }

                $(document).on('click', saveWizardSelector, function() {
                    saveContextRules();
                });

                $(document).on('click', ".addNewComponent", function() {
                    addComponentDialog();
                });

                $(document).on('click', ".addComponentDialogButton", function() {
                    addNewComponentToContext(contextJson);
                });

                $(filtersSelector).on("change", checkBoxSelector , function() {
                    updateFilterRowValues(this);
                });

                $(assetNodeSelector).on("change", checkBoxSelector , function() {
                    updateAssetNodeRowValues(this);
                });

                $(rulesActionBarSelector).on("change", checkBoxSelector , function() {
                    setInherit(this);
                });

                $(componentsSelector).on("change", checkBoxSelector , function() {
                    updateComponentPropertyRowValues(this);
                });

                $(componentsSelector).on("click", ".addComponentProperty", function() {
                    addPropertyToComponent(contextJson, this);
                });

                $(componentsSelector).on("click", ".deleteComponent", function() {
                    deleteSelectedComponent(contextJson, this);
                });

                $(componentsSelector).on("click", deletePropertySelector, function() {
                    removeSelectedProperty(contextJson, this);
                });

                $(componentsSelector).on("click", ".editProp", function() {
                    editSelectedProperty(contextJson, this);
                });

                $(componentsSelector).on("click", ".saveProperty", function() {
                    var propertySelected = this.closest('tr');
                    saveSelectedProperty(contextJson, propertySelected);
                });

                $('.filter-properties-list').on("click", ".filterDeleteIcon", function() {
                    removeFilter(this, contextJson);
                });

                $('.filter-properties-list').on("click", ".filterEditIcon", function() {
                    editFilter(this, contextJson);
                });

                $('.filter-properties-list').on("click", ".doneEditing", function() {
                    $('.filterEditIcon').show();
                    $('.filterDeleteIcon').show();
                    saveFilter(this, contextJson);
                });

                $(assetNodeSelector).on("click", ".referenceDeleteIcon", function() {
                    removeReference(this, contextJson);
                });

                $(assetNodeSelector).on("click", ".referenceEditIcon", function() {
                    editReference(this, contextJson);
                });

                $(assetNodeSelector).on("click", ".doneEditing", function() {
                    saveReference(this, contextJson);
                });

                if (contextJson["inherit"]) {
                    addInheritItemToCheckBox(contextJson["parent"]);
                }

            });

        });
    }

    function redirect(URL) {
        window.location.href = URL;
    }

    function toggleAddComponentButton(e) {
        var selection = e.detail.selection.innerText;
        if (selection == "Filters" || selection == "References") {
            $('.addNewComponent').hide();
        } else {
            if (!contextJson["inherit"]) {
                $('.addNewComponent').show();
            }
        }
    }

    function getURLParameter(sParam) {
        var sPageURL = window.location.search.substring(1);
        var sURLVariables = sPageURL.split('?');
        for (var i = 0; i < sURLVariables.length; i++) {
            var sParameterName = sURLVariables[i].split('=');
            if (sParameterName[0] == sParam) {
                return sParameterName[1];
            }
        }
        return null;
    }

    function saveContextRules() {
        if (contextJson['inherit']) {
            redirect(contextListURL);
        } else {
            var data = {
                ":operation" : "UPDATE_CONTEXT_RULES",
                ":context" : getURLParameter("context"),
                ":data" : JSON.stringify(contextJson),
                "_charset_" : "utf-8"
            };
            $.ajax({
                url: pageURL,
                type: "post",
                data: data,
                success: function(response) {
                    redirect(contextListURL);
                },
                error: function(xhr) {
                    //Do Something to handle error
                    showDialog("ErrorAddingContexts", "error", Granite.I18n.get("Failed"), Granite.I18n.get("Error saving context properties"), footer);
                }
            });
            saveSmartlingPropertyMapping(); // Added by Smartling
        }
    }

    function setContextProperties() {
        for (var key in contextJson['inheritedProperties']) {
            var inheritedContextProperty = contextJson['inheritedProperties'][key];
            mergeInheritedProperties(inheritedContextProperty['properties']);
            mergeInheritedFilters(inheritedContextProperty['filter']);
        }
    }

    function mergeInheritedProperties(inheritedParentProperties) {
        for (var key in inheritedParentProperties) {
            if (contextJson['properties'][key]) {
                mergeProperties(key, inheritedParentProperties[key]);
            } else {
                contextJson['properties'][key] = inheritedParentProperties[key];
            }
        }
    }

    function mergeProperties(component, inheritedProperties) {
        for (var key in inheritedProperties) {
            if (!contextJson['properties'][component][key]) {
                contextJson['properties'][component][key] = inheritedProperties[key];
            }
        }
    }

    function mergeInheritedFilters(inheritedFilters) {
        if (inheritedFilters['Node']) {
            if (contextJson['filter']['Node'].length > 0) {
                mergeFilters(inheritedFilters['Node'], 'Node');
            } else {
                contextJson['filter']['Node'] = inheritedFilters['Node'];
            }
        }
        if (inheritedFilters['Property']) {
            if (contextJson['filter']['Property'].length > 0) {
                mergeFilters(inheritedFilters['Property'], 'Property');
            } else  {
                contextJson['filter']['Property'] = inheritedFilters['Property'];
            }
        }
    }

    function mergeFilters(inheritedFilters, filterType) {
        for (var index in inheritedNodeFilters) {
            var filter = inheritedNodeFilters[index];
            if (filterType == 'Node') {
                if (!bCheckIfFilterExists(filter.propertyName, filter.value, filterType)) {
                    contextJson['filter'][filterType].push(filter);
                }
            } else if (filterType == 'Property'){
                if (!bCheckIfFilterExists(filter.propertyName, filter.Path, filterType)) {
                    contextJson['filter'][filterType].push(filter);
                }
            }
        }
    }

    function updateFilterRowValues(selection) {
        var nodeFilterRow = selection.closest('tr');
        var editableFields = $(nodeFilterRow).find('i');
        var propertyName = editableFields[0].innerText;
        var filterVal = editableFields[1].innerText;
        var filterType = nodeFilterRow.cells[1].innerText;
        var customCheck = false;
        if (selection.checked) {
            customCheck = true;
        }
        if("Node Filter" == filterType) {
            for (var index in contextJson['filter']['Node']) {
                var filter = contextJson['filter']['Node'][index];
                if (filter.propertyName == propertyName && filter.value == filterVal){
                    filter.isDeep = customCheck;
                    break;
                }
            }
        } else if("Content Filter" == filterType) {
            for (var index in contextJson['filter']['Content']) {
                var filter = contextJson['filter']['Content'][index];
                if (filter.key == propertyName && filter.value == filterVal){
                    filter.createLanguageCopy = customCheck;
                    break;
                }
            }
        }

        isRuleModified = true;
    }

    function updateAssetNodeRowValues(selection) {
        var assetNodeRow = selection.closest('tr');
        var editableFields = $(assetNodeRow).find('i');
        var resourceType = editableFields[0].innerText;
        var referenceType = editableFields[1].innerText;
        var checkInChildNodes = false;
        var createLangCopy = false;
        var currentCell = selection.closest('td');
        var currentCellIndex = $(currentCell).index();
        if (currentCellIndex == checkInChildNodesColumn) {
            if (selection.checked) {
                checkInChildNodes = true;
            }
            createLangCopy = $(assetNodeRow.childNodes[createLangCopyColumn]).find(checkBoxSelector)[0].checked;
        } else {
            if (selection.checked) {
                createLangCopy = true;
            }
            checkInChildNodes = $(assetNodeRow.childNodes[checkInChildNodesColumn]).find(checkBoxSelector)[0].checked;
        }
        for (var index in contextJson["references"]["assetNodes"]) {
            var assetNode = contextJson["references"]["assetNodes"][index];
            if (assetNode.resourceType == resourceType && assetNode.referenceType == referenceType){
                assetNode.checkInChildNodes = checkInChildNodes;
                assetNode.createLangCopy = createLangCopy;
                break;
            }
        }
        isRuleModified = true;
    }

    function updateComponentPropertyRowValues(selection) {
        var accordion = selection.closest(accordionItemSelector);
        var componentName = $(accordion).find(accordionLabelSelector).attr(componentnameattr);
        var propertyRow = selection.closest('tr');
        var propertyName = propertyRow.childNodes[0].innerText;
        var parserName = propertyRow.childNodes[1].childNodes[0].value; // Added by Smartling
        var inherit = false;
        var translateAsText = false;
        var updateDestinationLanguage = false;
        if (propertyName != "") {
            var currentCell = selection.closest('td');
            var currentCellIndex = $(currentCell).index();
            if (currentCellIndex == translateAsTextColumn) {
                // Translate As Text --  Disable the Update Language cell
                if (selection.checked) {
                    translateAsText = true;
                    updateDestinationLanguage = false;
                    if (propertyName == "cq:language" || propertyName == "jcr:language") {
                        updateDestinationLanguage = translateAsText;
                        translateAsText = false;
                    }
                }
                inherit = $(propertyRow.childNodes[inheritColumn]).find(checkBoxSelector)[0].checked;
            } else {
                // Inherit update performed
                if (selection.checked) {
                    inherit = true;
                }
                translateAsText = $(propertyRow.childNodes[translateAsTextColumn]).find(checkBoxSelector)[0].checked;
                if (propertyName == "cq:language" || propertyName == "jcr:language") {
                    updateDestinationLanguage = translateAsText;
                    translateAsText = false;
                }
            }
            // To-Do Instead of Updaing the entire property Node update only the value that gets changed
            var newPropertyNode = {"parser": parserName, "translateAsText": translateAsText, "inherit": inherit, "updateDestinationLanguage" : updateDestinationLanguage}; // Changed by Smartling
            contextJson['properties'][componentName][propertyName] = newPropertyNode;
        }
        isRuleModified = true;
    }

    function bCheckIfComponentExists(newComponentName) {
        var existingComponentsArray = Object.keys(contextJson['properties']);
        for (var index in existingComponentsArray) {
            if (existingComponentsArray[index] == newComponentName) {
                return true;
            }
        }
        return false;
    }

    function bCheckIfReferenceExists(resourceType, referenceType) {
        for (var index in contextJson["references"]["assetNodes"]) {
            var assetNode = contextJson["references"]["assetNodes"][index];
            if (resourceType == assetNode.resourceType && referenceType == assetNode.referenceType) {
                return true;
            }
        }
        return false;
    }

    function bCheckIfFilterExists(propertyName, filterValue, filterType) {
        var nodeFlag = false;
        var propertyFlag = false;
        if (filterType == "Node") {
            nodeFlag = true;
        } else if (filterType == "Property") {
            propertyFlag = true;
        }
        for (var index in contextJson["filter"][filterType]) {
            var filter = contextJson["filter"][filterType][index];
            if (nodeFlag) {
                if (propertyName == filter.propertyName && filterValue == filter.value) {
                    return true;
                }
            } else if(propertyFlag) {
                if (propertyName == filter.propertyName && filterValue == filter.Path) {
                    return true;
                }
            } else {
                if (propertyName == filter.key && filterValue == filter.value) {
                    return true;
                }
            }
        }
        return false;
    }

    function bCheckIfPropertyInComponentExists(componentName, propertyToAdd) {
        var exisitingPropertiesArray = Object.keys(contextJson['properties'][componentName]);
        for (var index in exisitingPropertiesArray) {
            if (exisitingPropertiesArray[index] == propertyToAdd) {
                return true;
            }
        }
        return false;
    }

    function setAddPropertyButton(selection) {
        var addPropertyRow = selection.closest('tr');
        var propertyField = $(addPropertyRow).find(newPropertyNameSelector)[0];
        var addPropertyButton = $(addPropertyRow).find('.addComponentProperty');
        if (propertyField.value != "") {
            addPropertyButton.attr("disabled", false);
            $(addPropertyRow).find(checkBoxSelector).attr("disabled", false);
            $(addPropertyRow).find(checkBoxSelector).attr("checked", true);
        } else {
            addPropertyButton.attr("disabled", true);
            $(addPropertyRow).find(checkBoxSelector).attr("disabled", true);
            $(addPropertyRow).find(checkBoxSelector).attr("checked", false);
        }
    }

    function setAddFilterButton() {
        var filterType = $('.selectFilterType')[0].value;
        if("content-filter" == filterType) {
            if ($(filterValue)[0].value != "") {
                $(addFilterButton).attr("disabled", false);
            } else {
                $(addFilterButton).attr("disabled", true);
            }
        } else {
            if ($(filterProperty)[0].value !="" && $(filterValue)[0].value != "") {
                $(addFilterButton).attr("disabled", false);
            } else {
                $(addFilterButton).attr("disabled", true);
            }
        }
    }

    function setAddReferenceButton() {
        if ($(assetNodeResourceType)[0].value !="" && $(assetReferenceType)[0].value != "") {
            $(addReferenceButton).attr("disabled", false);
        } else {
            $(addReferenceButton).attr("disabled", true);
        }
    }

    function setAddComponentButton() {
        if ($('#componentPath')[0].value !="") {
            $(addComponentButtonClass).attr("disabled", false);
        } else {
            $(addComponentButtonClass).attr("disabled", true);
        }
    }

    function deleteSelectedComponent(contextJson, selection) {
        var componentAccordion = selection.closest(accordionItemSelector);
        var componentName = $(componentAccordion).find(accordionLabelSelector).attr(componentnameattr);
        delete contextJson['properties'][componentName];
        selection.closest(accordionItemSelector).remove();
        isRuleModified = true;
    }

    function getComponentNameFromPath(componentPath) {
        return componentPath.substring(componentPath.lastIndexOf('/') + 1);
    }

    function addNewComponentToContext(contextJson) {
        var componentPath = $('#componentPath')[0].value;
        if (!bCheckIfComponentExists(componentPath)) {
            $('#newComponent')[0].open = false;
            contextJson['properties'][componentPath] = {};
            var componentName = getComponentNameFromPath(componentPath);
            addComponentPropertyToAccordion(componentPath, {"componentName": componentName});
            isRuleModified = true;
        } else {
            $('#newComponent')[0].open = false;
            var footer = '<button is="coral-button" type="button" coral-close="" class="addComponentDialogButton" variant="primary">' + Granite.I18n.get("Close")+ '</button>';
            var message = $('<p>').text(Granite.I18n.get("Component {0} already exists", componentPath, "Component name inserted"))[0].outerHTML;
            showDialog("duplicate", "warning", Granite.I18n.get("Component Already Exists"), message, footer);
        }
    }

    function addComponentDialog() {
        var dialogId = "newComponent";
        var variant = "default";
        var header = Granite.I18n.get("Add New Component");
        var componentPath = '<label class="coral-Form-fieldlabel">' + Granite.I18n.get('Component Path') + '</label> <input id="componentPath" class="coral-Form-field coral-Textfield" type="text" placeholder="' + Granite.I18n.get('Enter component path') + '">';
        var content = '<form class="coral-Form coral-Form--vertical" style="width: 500px;"> <section id="vtest-form-fieldset" class="coral-Form-fieldset"> <div class="coral-Form-fieldwrapper">';
        content += componentPath;
        content += '</div> </section> </form>';
        var footer = '<button is="coral-button" class="addComponentDialogButton" variant="primary" disabled="true" >' + Granite.I18n.get("Add")+ '</button>';
        showDialog(dialogId, variant, header, content, footer);
    }

    function saveReference(selection, contextJson) {
        var referenceRow = selection.closest('tr');
        var button = referenceRow.childNodes[4];
        $(button).html('<coral-icon icon="delete" class="referenceDeleteIcon" size="XS"></coral-icon>');
        var fields = $('.editReference');
        var resourceTypeOld = $(fields[0]).attr('resourceType');
        var referenceTypeOld = $(fields[1]).attr('referenceType');
        var resourceTypeNew = fields[0].value;
        var referenceTypeNew = fields[1].value;
        for (var index in contextJson['references']['assetNodes']) {
            var assetNode = contextJson['references']['assetNodes'][index];
            if (assetNode.resourceType == resourceTypeOld && assetNode.referenceType == referenceTypeOld){
                assetNode.resourceType = resourceTypeNew;
                assetNode.referenceType = referenceTypeNew;
                break;
            }
        }
        var referenceStmt = Granite.I18n.get('assetNode with resource type ') + $('<i>').text(resourceTypeNew)[0].outerHTML  + Granite.I18n.get('referenced as ') + $('<i>').text(referenceTypeNew)[0].outerHTML;
        $(referenceRow.childNodes[0]).html(referenceStmt);
        $('.referenceDeleteIcon').show();
        $('.referenceEditIcon').show();
        isRuleModified = true;
    }

    function bCheckIfContextExists(contextAdded) {
        for (var index in contextJson["contexts"]) {
            if (contextJson["contexts"][index] == contextAdded) {
                return true;
            }
        }
        return false;
    }

    function addContext(e) {
        var pathBrowser = e.target;
        var $pathBrowser = $(pathBrowser);
        var selections = $pathBrowser.find('.is-active');
        var context = selections[selections.length-1].getAttribute('data-value');
        if (!bCheckIfContextExists(context)) {
            // Ajax Call to Server to Add the Selected Context
            // Reload the page as well
            var operationAndContext = {
                ":operation" : "ADD_CONTEXT",
                ":context" : context
            };
            $.ajax({
                url: pageURL,
                type: "post",
                data: operationAndContext,
                success: function(response) {
                    location.reload();
                },
                error: function(xhr) {
                    //Do Something to handle error
                    showDialog("ErrorAddingContexts", "error", Granite.I18n.get("Failed"), Granite.I18n.get("Error Adding Context"), footer);
                }
            });
            isRuleModified = true;
        } else {
            var footer = '<button is="coral-button" variant="primary" coral-close="" size="M">' + Granite.I18n.get('Close') + '</button>';
            showDialog("duplicate", "warning", Granite.I18n.get("Context Already Exists"), Granite.I18n.get("Node with context path:") + context + Granite.I18n.get(" already exists"), footer);
        }
    }

    function getComponentPathFromLabel(label) {
        var start_pos = label.indexOf('-');
        if (start_pos != -1) {
            return label.substring(start_pos + 2);
        } else if ("General" == label) {
            return "General";
        }
        return null;

    }

    function createPathBrowser(pathBrowserElement) {
        pathBrowserElement = $(pathBrowserElement);
        var pickerTabs = undefined;

        if (pathBrowserElement.data('picker-allow-search')) {
            pickerTabs = [{
                panelURL: pathBrowserElement.data('picker-search-src'),
                tabContent: '<i class="coral-Icon coral-Icon-sizeXS ' + pathBrowserElement.data('picker-search-icon')
                    + '"></i>'
            }];
        }

        var pathBrowser = new CUI.PathBrowser({
            element: pathBrowserElement,
            pickerTitle: Granite.I18n.getVar(pathBrowserElement.data('picker-title')),
            crumbRoot: Granite.I18n.getVar(pathBrowserElement.data('crumb-root')),
            rootPath: pathBrowserElement.data('root-path'),
            pickerAdditionalTabs: pickerTabs,
            pickerSrc: pathBrowserElement.data('picker-src')
        });
        pathBrowser.$picker.data(pathBrowserType, pathBrowserElement.data(pathBrowserType));
        pathBrowser.$picker.on("coral-pathbrowser-picker-confirm", addContext);
    }

    function editReference(selection, contextJson) {
        var referenceRow = selection.closest('tr');
        var editableFields = $(referenceRow).find('i');
        var resourceType = editableFields[0].innerText;
        var assetReference = editableFields[1].innerText;
        $('.referenceEditIcon').hide();
        $('.referenceDeleteIcon').hide();
        var resourceTypeInput = $('<input>').attr('class','editReference').attr('is','coral-textfield').attr('resourceType', resourceType).attr('placeholder',Granite.I18n.get('resource type')).attr('value', resourceType)[0];
        var referenceTypeInput = $('<input>').attr('class','editReference').attr('is','coral-textfield').attr('referenceType', assetReference).attr('placeholder',Granite.I18n.get('reference type')).attr('value', assetReference)[0];
        // Set new td for the reference table selected row
        $(referenceRow.childNodes[0]).html(Granite.I18n.get('assetNode with resource type ') + resourceTypeInput.outerHTML + Granite.I18n.get(' with asset reference as ') + referenceTypeInput.outerHTML);
        $(referenceRow.childNodes[4]).html('<button is="coral-button" type="button" class="doneEditing" variant="secondary">' + Granite.I18n.get("Done") + '</button>');
        isRuleModified = true;
    }

    function saveFilter(selection, contextJson) {
        var filterRow = selection.closest('tr');
        var button = filterRow.childNodes[4];
        $(button).html('<coral-icon icon="delete" class="filterDeleteIcon" size="XS"></coral-icon>');
        var filterType = filterRow.childNodes[1].innerText;
        var filterStmt;
        if (filterType != "Content Filter") {
            var fields = $('.editFilter');
            var propertyNameOld = $(fields[0]).attr('propertyName');
            var filterValOld = $(fields[1]).attr('filterVal');
            var propertyNameNew = fields[0].value;
            var filterValNew = fields[1].value;


            if (filterType == "Property Filter") {
                for (var index in contextJson['filter']['Property']) {
                    var filter = contextJson['filter']['Property'][index];
                    if (filter.propertyName == propertyNameOld && filter.Path == filterValOld) {
                        filter.propertyName = propertyNameNew;
                        filter.Path = filterValNew;
                        break;
                    }
                }
                filterStmt = Granite.I18n.get('Filter property') + $('<i>').text(propertyNameNew)[0].outerHTML + Granite.I18n.get(' if path contains ') + $('<i>').text(filterValNew)[0].outerHTML;
            } else if (filterType == "Node Filter") {
                for (var index in contextJson['filter']['Node']) {
                    var filter = contextJson['filter']['Node'][index];
                    if (filter.propertyName == propertyNameOld && filter.value == filterValOld){
                        filter.propertyName = propertyNameNew;
                        filter.propertyName = propertyNameNew;
                        filter.value = filterValNew;
                        break;
                    }
                }
                filterStmt = Granite.I18n.get('Filter out nodes containing property') + $('<i>').text(propertyNameNew)[0].outerHTML + Granite.I18n.get('equal to ') + $('<i>').text(filterValNew)[0].outerHTML ;
            }
        } else {
            var fields = $('.editFilter');
            var filterValOld = $(fields[0]).attr('filterVal');
            var filterValNew = fields[0].value;
            for (var index in contextJson['filter']['Content']) {
                var filter = contextJson['filter']['Content'][index];
                if (filter.value == filterValOld){
                    filter.value = filterValNew;
                    break;
                }
            }
            filterStmt = Granite.I18n.get('Filter out content where ') + $('<i>').text('cq:tags')[0].outerHTML + Granite.I18n.get(' contains ') + $('<i>').text(filterValNew)[0].outerHTML ;
        }
        $(filterRow).find(checkBoxSelector).attr("disabled", false);
        $(filterRow.childNodes[0]).html(filterStmt);
        $('.filterEditIcon').show();
        $('.filterDeleteIcon').show();
        isRuleModified = true;
    }

    function editFilter(selection, contextJson) {
        var filterRow = selection.closest('tr');
        // get all the italics field in the tr
        var editableFields = $(filterRow).find('i');
        var propertyName = editableFields[0].innerText;
        var filterVal = editableFields[1].innerText;
        var propertyNameInput = $('<input>').attr('class','editFilter').attr('is','coral-textfield').attr('propertyName', propertyName).attr('placeholder',Granite.I18n.get('property name')).attr('value', propertyName)[0];
        var filterValInput = $('<input>').attr('class','editFilter').attr('is','coral-textfield').attr('filterVal', filterVal).attr('placeholder',Granite.I18n.get('path')).attr('value', filterVal)[0];
        // Set New td fdr the child node
        $(filterRow.childNodes[0]).html(Granite.I18n.get('Filter property ') + propertyNameInput.outerHTML + Granite.I18n.get(' if path contains ') + filterValInput.outerHTML);
        if (filterRow.childNodes[1].innerText == "Node Filter") {
            $(filterRow.childNodes[0]).html(Granite.I18n.get('Filter out nodes containing property ') + propertyNameInput.outerHTML + Granite.I18n.get(' equal to ') + filterValInput.outerHTML);
        } else if (filterRow.childNodes[1].innerText == "Content Filter") {
            var propertyNameElement = $('<i>').text(propertyName)[0];
            $(filterRow.childNodes[0]).html(Granite.I18n.get('Filter out content where ') + propertyNameElement.outerHTML + Granite.I18n.get(' contains ') + filterValInput.outerHTML);
        }
        $(filterRow.childNodes[4]).html('<button is="coral-button" type="button" class="doneEditing" variant="secondary">' + Granite.I18n.get("Done") + '</button>');
        $(filterRow).find(checkBoxSelector).attr("disabled", true);
        $('.filterEditIcon').hide();
        $('.filterDeleteIcon').hide();
        isRuleModified = true;
    }

    function addPropertyToComponent(contextJson, selection) {
        var accordion = selection.closest(accordionItemSelector);
        var componentName = $(accordion).find(accordionLabelSelector).attr(componentnameattr);
        var tableRow = selection.closest('tr');
        var propertyName = $(tableRow.childNodes[0]).find('.newPropertyName')[0].value;
        var parserName = $(tableRow.childNodes[1]).find('.newParser')[0].value; // Added by Smartling
        var translateCheckBox = $(tableRow.childNodes[translateAsTextColumn]).find('coral-checkbox')[0];
        var updateDestinationLanguage = false;
        var translateAsText = translateCheckBox.checked;
        if (propertyName == "cq:language" || propertyName == "jcr:language") {
            updateDestinationLanguage = translateAsText;
            translateAsText = false;
        }
        var inheritCheckBox = $(tableRow.childNodes[inheritColumn]).find('coral-checkbox')[0];
        var inherit = inheritCheckBox.checked;
        if (!bCheckIfPropertyInComponentExists(componentName, propertyName)) {
            var newPropertyNode = {"parser": parserName, "translateAsText": translateAsText, "inherit": inherit, "updateDestinationLanguage" : updateDestinationLanguage}; // Changed by Smartling
            contextJson['properties'][componentName][propertyName] = newPropertyNode;
            var row = generateTableRow(propertyName, parserName, translateAsText, inherit, updateDestinationLanguage); // Changed by Smartling
            selection.closest('.component-properties').items.add($(row)[0]);
            isRuleModified = true;
        } else {
            var footer = '<button is="coral-button" variant="primary" coral-close="" size="M">' + Granite.I18n.get("Close") + '</button>';
            var message = $('<p>').text(componentName + Granite.I18n.get(" already has ") + propertyName)[0].outerHTML;
            showDialog("duplicate", "warning", Granite.I18n.get("Property Already Exists"), message, footer);
        }
        // Reset property values
        $(tableRow.childNodes[0]).find('.newPropertyName')[0].value = "";
        // Reset the checkboxes and disable them
        translateCheckBox.checked = false;
        inheritCheckBox.checked = false;
        $(tableRow).find(checkBoxSelector).attr("disabled", true);
        // Disabled Add property Button
        $(addPropertyButtonSelector).attr("disabled", true);
    }

    function removeFilter(selection, contextJson) {
        var filterRow = selection.closest('tr');
        var filterStmt = filterRow.childNodes[0];
        var filterFields = $(filterStmt).find('i');
        var propertyName = filterFields[0].innerText;
        var filterValue = filterFields[1].innerText;
        var filterType = filterRow.childNodes[1].innerText;
        if ("Node Filter" == filterType) {
            for (var index in contextJson['filter']['Node']) {
                var filter = contextJson['filter']['Node'][index];
                if (filter.propertyName == propertyName && filter.value == filterValue) {
                    contextJson['filter']['Node'].splice(index, 1);
                    break;
                }
            }
        } else if ("Property Filter" == filterType){
            for (var index in contextJson['filter']['Property']) {
                var filter = contextJson['filter']['Property'][index];
                if (filter.propertyName == propertyName && filter.Path == filterValue) {
                    contextJson['filter']['Property'].splice(index, 1);
                    break;
                }
            }
        } else {
            for (var index in contextJson['filter']['Content']) {
                var filter = contextJson['filter']['Content'][index];
                if (filter.key == propertyName && filter.value == filterValue) {
                    contextJson['filter']['Content'].splice(index, 1);
                    break;
                }
            }
        }
        filterRow.remove();
        isRuleModified = true;
    }

    function removeReference(selection, contextJson) {
        var referenceRow = selection.closest('tr');
        var referenceStmt = referenceRow.childNodes[0];
        var referenceFields = $(referenceStmt).find('i');
        var resourceType = referenceFields[0].innerText;
        var referenceType = referenceFields[1].innerText;
        for (var index in contextJson['references']['assetNodes']) {
            var assetNode = contextJson['references']['assetNodes'][index];
            if (assetNode.resourceType == resourceType && assetNode.referenceType == referenceType){
                contextJson['references']['assetNodes'].splice(index, 1);
                break;
            }
        }
        referenceRow.remove();
        isRuleModified = true;
    }

    function saveSelectedProperty(contextJson, selection) {
        var propertyRow = selection.closest('tr');
        var button = propertyRow.childNodes[5];
        var componentAccordionItem = propertyRow.closest('coral-accordion-item');
        var componentName = $(componentAccordionItem).find('coral-accordion-item-label i').attr('componentname'); // Changed by Smartling
        $(button).html('<coral-icon icon="delete" class="deleteProp" size="XS"></coral-icon>');
        var editedPropertyField = $('.editProperty');
        var oldPropertyName = $(editedPropertyField[0]).attr('propertyName');
        var newPropertyName = editedPropertyField[0].value;
        var parserName = editedPropertyField[1].value; // Added by Smartling
        var updateDestinationLanguage = false;
        var translateAsText = $(propertyRow.childNodes[2]).find('coral-checkbox')[0].checked; // Changed by Smartling
        var inherit = $(propertyRow.childNodes[3]).find('coral-checkbox')[0].checked; // Changed by Smartling
        if (newPropertyName == "cq:language" || newPropertyName == "jcr:language") {
            updateDestinationLanguage = translateAsText;
            translateAsText = false;
        }
        var newPropertyNode = {"parser": parserName, "translateAsText": translateAsText, "inherit": inherit, "updateDestinationLanguage" : updateDestinationLanguage}; // Changed by Smartling
        // Delete the old property object and add the new object with the with the new property name
        delete contextJson['properties'][componentName][oldPropertyName];
        contextJson['properties'][componentName][newPropertyName] = newPropertyNode;
        $(propertyRow.childNodes[0]).text(newPropertyName);
        $(propertyRow.childNodes[1]).innerHtml = getParserSelect(parserName); // Added by Smartling
        $(propertyRow.childNodes[1]).find('coral-select').attr('disabled', true); // Added by Smartling
        $(propertyRow).find(checkBoxSelector).attr("disabled", false);
        $('.editProp').show();
        $('.deleteProp').show();
        isRuleModified = true;
    }

    function editSelectedProperty(contextJson, selection) {
        var propertyRow = selection.closest('tr');
        var componentAccordionItem = selection.closest(accordionItemSelector);
        var componentName = $(componentAccordionItem).find(accordionLabelSelector).attr(componentnameattr);
        var propertyName = propertyRow.childNodes[0].innerText;
        // Make the propertyName as editable
        var input = $('<input>').attr('class','editProperty').attr('is','coral-textfield').attr('propertyName', propertyName).attr('placeholder',Granite.I18n.get('property name')).attr('value', propertyName)[0];
        $(propertyRow.childNodes[0]).html(input.outerHTML);

        var parserSelect = $(propertyRow.childNodes[1]).find('coral-select')[0]; // Added by Smartling
        parserSelect.disabled = false; // Added by Smartling
        $(parserSelect).addClass('editProperty'); // Added by Smartling

        $(propertyRow.childNodes[5]).html('<button is="coral-button" type="button" class="saveProperty" variant="secondary">'+ Granite.I18n.get("Done") +'</button>'); // Changed by Smartling
        $(propertyRow).find(checkBoxSelector).attr("disabled", true);
        $('.editProp').hide();
        $('.deleteProp').hide();
    }

    function removeSelectedProperty(contextJson, selection) {
        var propertyRow = selection.closest('tr');
        var componentAccordionItem = propertyRow.closest(accordionItemSelector);
        var componentName = $(componentAccordionItem).find(accordionLabelSelector).attr(componentnameattr);
        var propertyName = propertyRow.childNodes[0].innerText;
        // Delete the property from the contextJson
        delete contextJson["properties"][componentName][propertyName];
        propertyRow.remove();
        isRuleModified = true;
    }

    function setReadableFields() {
        Coral.commons.ready($(document), function(el) {
            $('.context-properties-accordion input').attr("disabled", true);
            $('.filter-properties-list input').attr("disabled", true);
            $('.addFilterActionBar input').attr("disabled", true);
            $('.assetNodeResourceType').attr("disabled", true);
            $('.assetReferenceType').attr("disabled", true);
            $('.editProp').hide();
            $('.deleteProp').hide();
            $('.filterEditIcon').hide();
            $('.filterDeleteIcon').hide();
            $('.deleteProp').hide();
            $('.referenceEditIcon').hide();
            $('.referenceDeleteIcon').hide();
            $('.addNewComponent').hide();
            $('.deleteComponent').hide();
            contextJson['inherit'] = true;
        });
    }

    function setInherit(selection) {
        if (selection.checked) {
            setReadableFields();
        } else {
            setWritableFields();
        }
    }

    function setWritableFields() {
        Coral.commons.ready($(document), function(el) {
            $('.context-properties-accordion input').attr("disabled", false);
            $('.filter-properties-list input').attr("disabled", false);
            $('.addFilterActionBar input').attr("disabled", false);
            $('.assetNodeResourceType').attr("disabled", false);
            $('.assetReferenceType').attr("disabled", false);
            $('.editProp').show();
            $('.deleteProp').show();
            $('.filterEditIcon').show();
            $('.filterDeleteIcon').show();
            $('.referenceEditIcon').show();
            $('.referenceDeleteIcon').show();
            if (($('coral-tablist .is-selected')[0].innerText) == Granite.I18n.get("Properties")) {
                $('.addNewComponent').show();
            }
            $('.deleteComponent').show();
            contextJson['inherit'] = false;
        });
    }

    function addInheritItemToCheckBox(parentName) {
        setReadableFields();
        $(inheritCheckBoxSelector)[0].label.textContent = Granite.I18n.get("Inherit From ") + parentName;
        $(inheritCheckBoxSelector)[0].checked = true;
        $(inheritCheckBoxSelector).show();
        $(inheritCheckBoxSelector).attr("disabled", false);

    }

    function setSelectedItemOnContextSelector(currentContext) {
        Coral.commons.ready($('.foundation-collection-context-selector')[0], function(el) {
            el.value = currentContext;
        });
    }

    function addRowToFiltersListTable(propertyName, filterVal, filterType, customCheck) {
        var filterStmt = Granite.I18n.get("Filter out nodes containing property ");
        var filterCriteria = Granite.I18n.get(" equal to ");
        var propertyNameElement = $('<i>').text(propertyName)[0];
        var filterValueElement = $('<i>').text(filterVal)[0];
        if ("Property Filter" == filterType) {
            filterStmt = Granite.I18n.get("Filter out Property ");
            filterCriteria = Granite.I18n.get(" if path contains ");
        } else if ("Content Filter" == filterType) {
            filterStmt = Granite.I18n.get("Filter out content where ");
            filterCriteria = Granite.I18n.get(" contains ");
        }
        filterStmt += propertyNameElement.outerHTML + filterCriteria + filterValueElement.outerHTML;
        var filterListTable = document.querySelector('.filter-properties-list');
        var td = '<td is="coral-table-cell">';
        var table_content_text = td + filterStmt + '</td>' + td + Granite.I18n.getVar(filterType) + '</td>';
        var table_row_text = getTableRow();

        var checkBoxCell = $(getTableCell()).append(getCheckBoxWithAttr(false,true,"", "property"))[0];
        if ("Node Filter" == filterType) {
            checkBoxCell = (customCheck==true) ? $(getTableCell()).append(getCheckBoxWithAttr(true,false,"Is Deep", "node"))[0] : $(getTableCell()).append(getCheckBoxWithAttr(false,false,"Is Deep", ""))[0];

        } else if("Content Filter" == filterType) {
            checkBoxCell = (customCheck==true) ? $(getTableCell()).append(getCheckBoxWithAttr(true,false,"Create Language Copy", "content"))[0] : $(getTableCell()).append(getCheckBoxWithAttr(false,false,"Create Language Copy", ""))[0];
        }
        var editIcon = getCoralIcon();
        editIcon.setAttribute("class", "filterEditIcon")
        editIcon.setAttribute("icon", "edit");
        editIcon.setAttribute("size", "XS");
        var editCell = $(getTableCell()).append(editIcon)[0];

        var deleteIcon = getCoralIcon();
        deleteIcon.setAttribute("class", "filterDeleteIcon");
        deleteIcon.setAttribute("icon", "delete");
        deleteIcon.setAttribute("size", "XS");
        var deleteCell = $(getTableCell()).append(deleteIcon)[0];

        $(table_row_text).append(table_content_text);
        $(table_row_text).append(checkBoxCell);
        $(table_row_text).append(editCell);
        $(table_row_text).append(deleteCell);
        //since adding label to check box before appending to table is not working
        var checkboxadded = $(table_row_text).find('coral-checkbox');
        checkboxadded[0].classList.add("cb-left-align");
        if ("Node Filter" == filterType) {
            checkboxadded[0].innerText = "Is Deep";
        } else if("Content Filter" == filterType) {
            checkboxadded[0].innerText = "Create Language Copy";
        } else if ("Property Filter" == filterType){
            checkboxadded[0].hidden = true;
        }
        var table_row = table_row_text.outerHTML;
        filterListTable.items.add($(table_row)[0]);

    }


    function addRowToAssetNodeListTable(resourceType, assetReferenceAttribute, checkInChildNodes, createLangCopy) {
        var assetNodeListTable = document.querySelector('.assetnode-properties-list');
        var table_row_text = getTableRow();
        var resTypeElement = $('<i>').text(resourceType)[0];
        var assetRefElement = $('<i>').text(assetReferenceAttribute)[0];
        var td = '<td is="coral-table-cell" >';
        var table_content_text = td + Granite.I18n.get('assetNode with resource type ') + resTypeElement.outerHTML + Granite.I18n.get(' referenced as ') +
            assetRefElement.outerHTML + '</td>';
        var checkInChildNodesCell = (checkInChildNodes==true) ? $(getTableCell()).append(getCheckedCheckbox())[0] : $(getTableCell()).append(getCheckbox())[0];
        var createLanguageCopyCell = (createLangCopy==true) ? $(getTableCell()).append(getCheckedCheckbox())[0] : $(getTableCell()).append(getCheckbox())[0];

        var editIcon = getCoralIcon();
        editIcon.setAttribute("class", "referenceEditIcon")
        editIcon.setAttribute("icon", "edit");
        editIcon.setAttribute("size", "XS");
        var editCell = $(getTableCell()).append(editIcon)[0];

        var deleteIcon = getCoralIcon();
        deleteIcon.setAttribute("class", "referenceDeleteIcon");
        deleteIcon.setAttribute("icon", "delete");
        deleteIcon.setAttribute("size", "XS");
        var deleteCell = $(getTableCell()).append(deleteIcon)[0];

        $(table_row_text).append(table_content_text);
        $(table_row_text).append(checkInChildNodesCell);
        $(table_row_text).append(createLanguageCopyCell);
        $(table_row_text).append(editCell);
        $(table_row_text).append(deleteCell);

        var table_row = table_row_text.outerHTML;
        assetNodeListTable.items.add($(table_row)[0]);
    }

    function generateTableRow(propertyName, parserValue, translateAsText, inherit, updateDestinationLanguage) {  // Changed by Smartling
        var tr = getTableRow();
        var propertyCell = $(getTableCell()).text(propertyName)[0];
        var parserCell = getParserCell(parserValue);  // Added by Smartling
        var translateAsTextCell =  (translateAsText==true) ? $(getTableCell()).append(getCheckedCheckbox())[0] : $(getTableCell()).append(getCheckbox())[0];
        if (propertyName == "jcr:language" || propertyName == "cq:language") {
            translateAsTextCell = (updateDestinationLanguage==true) ? $(getTableCell()).append(getCheckedCheckbox())[0] : $(getTableCell()).append(getCheckbox())[0];
        }
        var inheritCell = (inherit==true) ? $(getTableCell()).append(getCheckedCheckbox())[0] : $(getTableCell()).append(getCheckbox())[0];
        var editIcon = getCoralIcon();
        editIcon.setAttribute("class", "editProp")
        editIcon.setAttribute("icon", "edit");
        editIcon.setAttribute("size", "XS");
        var editCell = $(getTableCell()).append(editIcon)[0];

        var deleteIcon = getCoralIcon();
        deleteIcon.setAttribute("class", "deleteProp");
        deleteIcon.setAttribute("icon", "delete");
        deleteIcon.setAttribute("size", "XS");
        var deleteCell = $(getTableCell()).append(deleteIcon)[0];

        $(tr).append(propertyCell);
        $(tr).append(parserCell); // Added by Smartling
        $(tr).append(translateAsTextCell);
        $(tr).append(inheritCell);
        $(tr).append(editCell);
        $(tr).append(deleteCell);

        return tr.outerHTML;
    }

    function getCoralIcon() {
        return new Coral.Icon();
    }

    function getTableRow() {
        return new Coral.Table.Row();
    }

    function getTableCell() {
        return new Coral.Table.Cell();
    }

    function getCheckbox() {
        return new Coral.Checkbox();
    }

    function getCheckedCheckbox() {
        var checkbox = getCheckbox();
        checkbox.checked = true;
        return checkbox;
    }

    function getCheckBoxWithAttr(checked, disabled, label, value) {
        var checkbox = getCheckbox();
        checkbox.checked = checked;
        checkbox.disabled = disabled;
        checkbox.label.innerHTML = label;
        checkbox.value = value;
        return checkbox;
    }

    // Smartling custom utility functions
    function getSelect(options, disabled) {
        var select = new Coral.Select().set({
            name: "Select",
            placeholder: "Choose an item"
        });

        for(var opt in options) {
            select.items.add({
                value: options[opt].val,
                content: {
                    textContent: options[opt].title
                }
            });
        }

        select.disabled = (disabled === undefined) ? true : disabled;

        return select;
    }

    function getParserSelect(selectedValue, disabled) {
        var parserSelect = getSelect([{val: 'html', title: 'Html'},{val: 'text', title: 'Text'}], disabled);
        parserSelect.value = selectedValue || parserDefaultValue;
        $(parserSelect).addClass('newParser');
        $(parserSelect).css('width', '30%');
        $(parserSelect).css('min-width', '70px');
        return parserSelect;
    }

    function getParserCell(selectedValue) {
        var parserSelect = getParserSelect(selectedValue);
        return $(getTableCell()).append(parserSelect)[0];
    }
    // End of Smartling custom utility functions

    function generateTableHeaderWithColumns() {
        var thead = '<thead is="coral-table-head" sticky><tr is="coral-table-row"  class="smartling-property-mapping-row smartling-property-mapping-header">'; // Changed by Smartling
        thead += '<th is="coral-table-headercell">' + Granite.I18n.get("Property") + '</th>';
        thead += '<th is="coral-table-headercell">' + Granite.I18n.get("Smartling Parser") + '</th>'; // Added by Smartling
        thead += '<th is="coral-table-headercell">' + Granite.I18n.get("Translate") + '</th>';
        thead += '<th is="coral-table-headercell">' + Granite.I18n.get("Inherit") + '</th>';
        thead  += '</tr></thead>';
        return thead;
    }

    function setContextTitle() {
        Coral.commons.ready($('betty-titlebar-title'), function(el) {
            var context = getURLParameter("context");
            var spanTag = $('<span>').addClass('granite-title').text(decodeURIComponent(context));
            $($('betty-titlebar-title')[0]).append(spanTag);
        });
    }

    function addNewPropertyRow() {
        var uncheckedCheckbox = '<coral-checkbox disabled></coral-checkbox>';
        var tr = '<tr is="coral-table-row" class="smartling-property-mapping-row">'; // Changed by Smartling
        var td = '<td is="coral-table-cell">';
        var propertyCell = td + '<input is="coral-textfield" class="newPropertyName" placeholder="' + Granite.I18n.get('New property') + '" name="property">' + '</td>';
        var parserCell = td + $(getParserSelect(undefined, false))[0].outerHTML  + '</td>'; // Added by Smartling
        var translateAsTextCell = td + uncheckedCheckbox + '</td>';
        var inheritCell = td + uncheckedCheckbox + '</td>';
        var button = '<button is="coral-button" type="button" class="addComponentProperty" variant="secondary" disabled=true>'+ Granite.I18n.get('Add') + '</button>';
        return tr + propertyCell + parserCell + translateAsTextCell + inheritCell + td + '</td>' + td + button + '</tr>'; // Changed by Smartling
    }

    function addButtonOption() {
        var tr = '<tr is="coral-table-row">';
        var td = '<td is="coral-table-cell">';
        var button = '<button is="coral-button" type="button" class="addComponentProperty" variant="quiet">'+ Granite.I18n.get("Add") + '</button>';
        return tr + td + button + '</td>' + td + '</td>' + td  + '</td>' + td + '</td>' + td + '</td>' + td + '</td>' +'</tr>';
    }

    function generateTableWithColumns(componentPropertyJson) {
        var table_html = '<table is="coral-table" class="component-properties">';
        table_html += generateTableHeaderWithColumns();
        table_html += '<tbody is="coral-table-body">';
        table_html += addNewPropertyRow();
        for (var property in componentPropertyJson) {
            if (property != "componentName") {
                table_html += generateTableRow(property, componentPropertyJson[property]['parser'], componentPropertyJson[property]['translateAsText'],componentPropertyJson[property]['inherit'],componentPropertyJson[property]['updateDestinationLanguage']); // Changed by Smartling
            }
        }
        table_html += '</tbody></table>';
        return table_html;
    }

    function addComponentPropertyToAccordion (label, componentPropertyJson) {
        var componentName, componentPath;
        if ("General" != label) {
            var deleteComponentButton = '<coral-icon class="deleteComponent" icon="delete" size="XS"></coral-icon>';
            componentName = componentPropertyJson["componentName"];
            var componentElement = $('<i>').attr('componentname', label).text(label)[0];
            componentPath = componentElement.outerHTML;
            label = componentName + ' - ' + componentPath + deleteComponentButton;
        } else {
            componentPath = '<i componentname="General"></i>';
            label = Granite.I18n.get("General") + componentPath;
        }
        $('.context-properties-accordion')[0].items.add({
            label: {
                innerHTML: label
            },
            content: {
                innerHTML: generateTableWithColumns(componentPropertyJson)
            },
            disabled: false
        });
    }

    function showDialog(id, variant, header, content, footer) {
        var $dialog = $('#' + id);
        var dialog;
        if ($dialog.length === 0) {
            dialog = new Coral.Dialog().set({
                id: id,
                variant: variant,
                closable: "on",
                header: {
                    innerHTML: header
                },
                content: {
                    innerHTML: content
                },
                footer: {
                    innerHTML: footer
                }
            });
            document.body.appendChild(dialog);
        } else {
            dialog = $dialog[0];
            dialog.header.innerHTML = header;
            dialog.content.innerHTML = content;
            dialog.footer.innerHTML = footer;
        }
        dialog.show();
    }
})(document, _g.XSS, Granite.$);
