;(function (document, $) {
    var LANGUAGE_SELECTOR_CLASS = '.smartling-touch-js-coral3-language-selector-field';
    var POPUP_BUTTON = 'smartling-touch-js-coral3-language-selector-popup-button';
    var CLOSE_ALL_BUTTON = 'smartling-touch-js-coral3-language-selector-close-all-button';

    $(document).on("foundation-contentloaded", function(e) {
        $(LANGUAGE_SELECTOR_CLASS).each(function (idx, selectorElement) {
            Coral.commons.ready(selectorElement, function(component){
            
                var $selector = $(selectorElement);

                var $pickerButtonGroup = $selector.find('div.coral-InputGroup .coral-InputGroup-button');

                if ($pickerButtonGroup.length === 0){
                    return;
                }

                var isStandaloneAemInstance = $pickerButtonGroup.find('._coral-Button').length === 0;

                if ($selector.find('button.' + POPUP_BUTTON).length === 0){
                    var popupButtonStandalone = '<span class="coral-InputGroup-button">' +
                        '<button class="coral3-Button coral3-Button--secondary ' + POPUP_BUTTON + '" size="M" variant="secondary" ' +
                        'title="Select Languages" type="button" aria-label="Select Languages">' +
                        '<coral-icon class="coral3-Icon coral3-Icon--sizeS coral3-Icon--chevronDown" icon="chevronDown" size="S" ' +
                        'autoarialabel="on" role="img" aria-label="chevronDown">' +
                        '</coral-icon>' +
                        '<coral-button-label></coral-button-label>' +
                        '</button>' +
                        '</span>';
                    var popupButtonCloud = '<span class="coral-InputGroup-button">' +
                        '<button tracking="off" variant="_custom" handle="button" type="button"' +
                        ' class="_coral-FieldButton _coral-Dropdown-trigger ' + POPUP_BUTTON + '" size="M">' +
                            '<svg focusable="false" aria-hidden="true" class="_coral-Icon--svg _coral-Icon _coral-UIIcon-ChevronDownMedium">' +
                                '<use xlink:href="/libs/clientlibs/granite/coralui3/resources/spectrum-css-icons.svg#spectrum-css-icon-ChevronDownMedium"></use>' +
                            '</svg>' +
                        '</button></span>';
                    var popupButton = isStandaloneAemInstance ? popupButtonStandalone : popupButtonCloud;
                    $pickerButtonGroup.before(popupButton);
                    $selector.find('button.' + POPUP_BUTTON).on('click', function(event){
                        event.stopPropagation();
                        // Coral UI applies this class for tag list without items.
                        // But it prevents from showing tag list elements.
                        $selector.find('coral-taglist').removeClass('u-coral-screenReaderOnly');
                        $selector[0]._onUserInput();
                    });
                }

                if ($selector.find('button.' + CLOSE_ALL_BUTTON).length === 0) {
                    var closeAllButtonStandalone = '<span class="coral-InputGroup-button">' +
                        '<button class="coral3-Button coral3-Button--secondary ' + CLOSE_ALL_BUTTON + '" size="M" variant="secondary" ' +
                        'title="Deselect All Languages" type="button" aria-label="Deselect All Languages">' +
                        '<coral-icon class="coral3-Icon coral3-Icon--sizeS coral3-Icon--close" icon="close" size="S" ' +
                        'autoarialabel="on" role="img" aria-label="close">' +
                        '</coral-icon>' +
                        '<coral-button-label></coral-button-label>' +
                        '</button>' +
                        '</span>';
                    var closeAllButtonCloud = '<span class="coral-InputGroup-button">' +
                        '<button tracking="off" variant="_custom" handle="button" type="button"' +
                        ' class="_coral-FieldButton _coral-Dropdown-trigger ' + CLOSE_ALL_BUTTON + '" size="M">' +
                            '<svg focusable="false" aria-hidden="true" class="_coral-Icon--svg _coral-Icon _coral-UIIcon-CrossMedium">' +
                                '<use xlink:href="/libs/clientlibs/granite/coralui3/resources/spectrum-css-icons.svg#spectrum-css-icon-CrossMedium"></use>' +
                            '</svg>' +
                        '</button></span>';
                    var closeAllButton = isStandaloneAemInstance ? closeAllButtonStandalone : closeAllButtonCloud;
                    $pickerButtonGroup.before(closeAllButton);
                    $selector.find('button.' + CLOSE_ALL_BUTTON).on('click', function(event){
                        event.stopPropagation();
                        $selector.find('coral-tagList coral-tag button').click();
                    });
                }

                $selector[0].reset = function() {
                    $selector[0].required = false;
                    $selector.find('coral-tagList coral-tag button').click();
                    setTimeout(function () {
                        $selector[0].required = true;
                    }, 200);
                    $selector[0]._getSuggestionAPI(function(api) {
                        api.cancel();
                    });
                }
            });
        });
    });

})(document, Granite.$);
