<%--
Copied and modified from /libs/granite/ui/components/coral/foundation/form/pathfield/suggestion/suggestion.jsp
--%>
<%--
  ADOBE CONFIDENTIAL
  ___________________

  Copyright 2016 Adobe
  All Rights Reserved.

  NOTICE: All information contained herein is, and remains
  the property of Adobe and its suppliers, if any. The intellectual
  and technical concepts contained herein are proprietary to Adobe
  and its suppliers and are protected by all applicable intellectual
  property laws, including trade secret and copyright laws.
  Dissemination of this information or reproduction of this material
  is strictly forbidden unless prior written permission is obtained
  from Adobe.
--%><%
%><%@ include file="/libs/granite/ui/global.jsp" %><%
%><%@ page session="false"
          import="java.util.Collections,
                  java.util.Comparator,
                  java.util.Iterator,
                  java.util.List,
                  org.apache.jackrabbit.util.Text,
                  org.apache.commons.lang3.StringUtils,
                  com.adobe.granite.ui.components.AttrBuilder,
                  com.adobe.granite.ui.components.Config,
                  com.adobe.granite.ui.components.ExpressionHelper,
                  com.adobe.granite.ui.components.PagingIterator" %><%

final ExpressionHelper ex = cmp.getExpressionHelper();
final Config cfg = cmp.getConfig();

final String query = ex.getString(cfg.get("query", String.class));

final String searchName = Text.getName(query);

%><coral-buttonlist><%
    String[] selectors = slingRequest.getRequestPathInfo().getSelectors();
    boolean isNextPage = selectors.length > 0 && Integer.parseInt(selectors[0]) > 0;
    boolean matched = isNextPage;
    for (Iterator<Resource> it = cmp.getItemDataSource().iterator(); it.hasNext();) {
        Resource r = it.next();
        //String path = r.getPath();
        String val = r.getValueMap().get("value", String.class);
        String text = r.getValueMap().get("text", String.class);

        AttrBuilder attrs = new AttrBuilder(request, xssAPI);
        attrs.add("type", "button");
        attrs.add("is", "coral-buttonlist-item");
        attrs.add("value", val);
        attrs.add("role", "option");

        if (StringUtils.containsIgnoreCase(text, searchName) || StringUtils.containsIgnoreCase(val, searchName)) {
            if (!matched){
                %><button type="button" is="coral-buttonlist-item" value="select-all" role="option">Select All</button><%
            }
        	%><button <%= attrs %>><%= mark(text, searchName, xssAPI) %></button><%
            matched = true;
        }
    }
%></coral-buttonlist><%!

private String mark(String text, String searchName, XSSAPI xssAPI) {
    StringBuilder sb = new StringBuilder();

    int index = StringUtils.isBlank(text) || StringUtils.isBlank(searchName)
            ? -1
            : StringUtils.indexOfIgnoreCase(text, searchName);

    if (index >= 0) {
        sb.append(xssAPI.encodeForHTML(text.substring(0, index)));
        String matchedSegment = text.substring(index, index + searchName.length());
        if (matchedSegment.length() > 0) {
            sb.append("<mark>" + xssAPI.encodeForHTML(matchedSegment) + "</mark>");
        }

        sb.append(xssAPI.encodeForHTML(text.substring(index + searchName.length())));
    } else {
        sb.append(xssAPI.encodeForHTML(text));
    }

    return sb.toString();
}
%>
