/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.context.impl.ConnectionSettings;
import com.smartling.aem.connector.core.NetworkSettings;
import com.smartling.api.client.authentication.Authenticator;
import com.smartling.api.client.authentication.HttpClientSettings;
import com.smartling.cms.gateway.client.CmsGatewayClient;
import com.smartling.cms.gateway.client.CmsGatewayClientBuilder;
import com.smartling.cms.gateway.client.CmsGatewayClientException;
import com.smartling.cms.gateway.client.internal.CommandChannelTransport;
import com.smartling.cms.gateway.client.internal.CommandChannelWebsocketTransport;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.websocket.WebSocketContainer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.container.grizzly.client.GrizzlyClientContainer;
import org.glassfish.tyrus.core.Base64Utils;

@Service(value={GatewayClientFactory.class})
@Component(label="Smartling - Context API Connection Configuration (Touch)", metatype=true, description="Configure endpoints for Smartling Context API.")
public class GatewayClientFactory {
    private static final String TOKEN_TYPE = "Bearer";
    private static final String DEFAULT_COMMAND_URL = "wss://cms.smartling.com/command/websocket";
    @Property(label="Command", description="Command endpoint URL", value={"wss://cms.smartling.com/command/websocket"})
    private static final String COMMAND_URL_PROP = "command.url";
    public static final long DEFAULT_COMMAND_HEARTBEAT = 40000L;
    public static final long MINIMUM_COMMAND_HEARTBEAT = 15000L;
    @Property(label="Command endpoint heartbeat", description="How often send PING message from AEM to Smartling. Value in milliseconds, minimum 15000, recommended 40000", longValue={40000L})
    private static final String COMMAND_HEARTBEAT_PROP = "command.heartbeat";
    private static final String DEFAULT_UPLOAD_URL = "https://cms.smartling.com/upload";
    @Property(label="Upload", description="Upload endpoint URL", value={"https://cms.smartling.com/upload"})
    private static final String UPLOAD_URL_PROP = "upload.url";
    private String commandChannelEndpointUrl;
    private String uploadChannelEndpointUrl;
    private long heartbeatInterval;
    @Reference
    private NetworkSettings networkSettings;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.commandChannelEndpointUrl = PropertiesUtil.toString((Object)properties.get(COMMAND_URL_PROP), (String)DEFAULT_COMMAND_URL);
        this.uploadChannelEndpointUrl = PropertiesUtil.toString((Object)properties.get(UPLOAD_URL_PROP), (String)DEFAULT_UPLOAD_URL);
        this.heartbeatInterval = Math.max(PropertiesUtil.toLong((Object)properties.get(COMMAND_HEARTBEAT_PROP), (long)40000L), 15000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsGatewayClient createClient(ConnectionSettings settings, Executor executor) throws CmsGatewayClientException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            CmsGatewayClient cmsGatewayClient = CmsGatewayClientBuilder.create().setProjectId(settings.getProjectId()).setTokenType(TOKEN_TYPE).setAuthenticator(this.createAuthenticator(settings)).setCommandChannelEndpoint(this.commandChannelEndpointUrl).setUploadChannelEndpoint(this.uploadChannelEndpointUrl).setUploadChannelTransport(this.createUploadChannelHttpClient()).setCommandChannelTransport(this.createCommandChannelTransport()).setDefaultHeartbeatInterval(this.heartbeatInterval).setCommandExecutor(executor).build();
            return cmsGatewayClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
        }
    }

    private Authenticator createAuthenticator(ConnectionSettings settings) {
        HttpClientSettings httpClientSettings = new HttpClientSettings();
        if (this.networkSettings.isProxyEnabled()) {
            HttpClientSettings.Proxy proxy = this.networkSettings.requireProxyAuthentication() ? HttpClientSettings.Proxy.withAuthentication((String)this.networkSettings.getProxyHost(), (int)this.networkSettings.getProxyPort(), (String)this.networkSettings.getProxyUser(), (String)this.networkSettings.getProxyPassword()) : HttpClientSettings.Proxy.anonymous((String)this.networkSettings.getProxyHost(), (int)this.networkSettings.getProxyPort());
            httpClientSettings.setProxy(proxy);
        }
        return new Authenticator(settings.getUserIdentifier(), settings.getTokenSecret(), httpClientSettings);
    }

    private CommandChannelTransport createCommandChannelTransport() {
        ClientManager clientManager = ClientManager.createClient((String)GrizzlyClientContainer.class.getName());
        if (this.networkSettings.isProxyEnabled()) {
            clientManager.getProperties().put("org.glassfish.tyrus.client.proxy", "http://" + this.networkSettings.getProxyHost() + ":" + this.networkSettings.getProxyPort());
            if (this.networkSettings.requireProxyAuthentication()) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Proxy-Authorization", this.generateAuthorizationHeader());
                clientManager.getProperties().put("org.glassfish.tyrus.client.proxy.headers", headers);
            }
        }
        return new CommandChannelWebsocketTransport((WebSocketContainer)clientManager);
    }

    private String generateAuthorizationHeader() {
        byte[] bytes = (this.networkSettings.getProxyUser() + ":" + this.networkSettings.getProxyPassword()).getBytes(Charset.forName("UTF-8"));
        return "Basic " + Base64Utils.encodeToString((byte[])bytes, (boolean)false);
    }

    private CloseableHttpAsyncClient createUploadChannelHttpClient() {
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create();
        if (this.networkSettings.isProxyEnabled()) {
            HttpHost proxyHost = new HttpHost(this.networkSettings.getProxyHost(), this.networkSettings.getProxyPort().intValue());
            clientBuilder = clientBuilder.setProxy(proxyHost);
            if (this.networkSettings.requireProxyAuthentication()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.networkSettings.getProxyUser(), this.networkSettings.getProxyPassword()));
                clientBuilder = clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return clientBuilder.build();
        }
        return clientBuilder.useSystemProperties().build();
    }

    protected void bindNetworkSettings(NetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    protected void unbindNetworkSettings(NetworkSettings networkSettings) {
        if (this.networkSettings == networkSettings) {
            this.networkSettings = null;
        }
    }
}

