/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.smartling.aem.connector.context.ContextConnection;
import com.smartling.aem.connector.context.impl.ConnectionSettings;
import com.smartling.aem.connector.context.impl.ContextLockSettings;
import com.smartling.aem.connector.context.impl.connection.ClientProducer;
import com.smartling.aem.connector.context.impl.connection.ContextGatewayConnection;
import com.smartling.aem.connector.context.impl.connection.GatewayClientFactory;
import com.smartling.aem.connector.context.impl.connection.ResourceLoadingHandlerImpl;
import com.smartling.aem.connector.context.impl.connection.config.ContextLockService;
import com.smartling.aem.connector.context.impl.resources.ResourceLoader;
import com.smartling.aem.connector.core.FileUriResolver;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;

@Service(value={GatewayConnectionFactory.class})
@Component(metatype=true, label="Smartling - Context Advanced Settings (Touch)", description="Various settings, affecting context capturing details and performance")
public class GatewayConnectionFactory {
    private static final int DEFAULT_POOL_SIZE = 5;
    @Property(label="Pool Size", description="Number of parallel threads used to capture context", intValue={5})
    private static final String POOL_SIZE_PROPERTY = "pool-size";
    @Reference
    private ResourceLoader resourcesFacade;
    @Reference
    private GatewayClientFactory clientFactory;
    @Reference
    private FileUriResolver fileUriResolver;
    @Reference
    private ContextLockService contextLocker;
    private Executor executor;

    @Activate
    protected void activate(Map<String, Object> properties) {
        int poolSize = PropertiesUtil.toInteger((Object)properties.get(POOL_SIZE_PROPERTY), (int)5);
        this.executor = GatewayConnectionFactory.createThreadPool(poolSize);
    }

    private static Executor createThreadPool(int maximumPoolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("context-loader-%d").build();
        return new ThreadPoolExecutor(0, maximumPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public ContextConnection createConnection(ConnectionSettings settings, ContextLockSettings captureConnectionConfig) {
        ClientProducer clientProducer = new ClientProducer(settings, this.clientFactory, this.executor);
        ResourceLoadingHandlerImpl loadingHandler = new ResourceLoadingHandlerImpl(this.resourcesFacade, this.fileUriResolver);
        return new ContextGatewayConnection(clientProducer, loadingHandler, this.contextLocker, captureConnectionConfig);
    }

    protected void bindResourcesFacade(ResourceLoader resourceLoader) {
        this.resourcesFacade = resourceLoader;
    }

    protected void unbindResourcesFacade(ResourceLoader resourceLoader) {
        if (this.resourcesFacade == resourceLoader) {
            this.resourcesFacade = null;
        }
    }

    protected void bindClientFactory(GatewayClientFactory gatewayClientFactory) {
        this.clientFactory = gatewayClientFactory;
    }

    protected void unbindClientFactory(GatewayClientFactory gatewayClientFactory) {
        if (this.clientFactory == gatewayClientFactory) {
            this.clientFactory = null;
        }
    }

    protected void bindFileUriResolver(FileUriResolver fileUriResolver) {
        this.fileUriResolver = fileUriResolver;
    }

    protected void unbindFileUriResolver(FileUriResolver fileUriResolver) {
        if (this.fileUriResolver == fileUriResolver) {
            this.fileUriResolver = null;
        }
    }

    protected void bindContextLocker(ContextLockService contextLockService) {
        this.contextLocker = contextLockService;
    }

    protected void unbindContextLocker(ContextLockService contextLockService) {
        if (this.contextLocker == contextLockService) {
            this.contextLocker = null;
        }
    }
}

