/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.resources.render;

import com.smartling.aem.connector.context.impl.resources.ResourceLoadingException;
import com.smartling.aem.connector.context.impl.resources.ResourceStream;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderRequest;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderRequestBuilder;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderResponse;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderer;
import com.smartling.aem.connector.context.impl.resources.render.ResourceRenderingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.Consts;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class NativeResourceRenderer
implements ResourceRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeResourceRenderer.class);
    @Reference
    private SlingRequestProcessor slingRequestProcessor;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public ResourceStream renderResource(String srcPath) throws ResourceLoadingException {
        try {
            ResourceRenderResponse renderResponse;
            ByteArrayOutputStream renderStream;
            int status;
            ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.emptyMap());
            String path = srcPath;
            int i = 5;
            do {
                ResourceRenderRequest renderRequest = ResourceRenderRequestBuilder.create().setMethod("GET").setPath(path).build();
                renderStream = new ByteArrayOutputStream();
                renderResponse = new ResourceRenderResponse(renderStream);
                LOGGER.info("Native loading resource by path=\"{}\"", (Object)path);
                this.slingRequestProcessor.processRequest((HttpServletRequest)renderRequest, (HttpServletResponse)renderResponse, resourceResolver);
                renderResponse.flushBuffer();
                status = renderResponse.getStatus();
                LOGGER.info("Got status=\"{}\" for path=\"{}\"", (Object)status, (Object)path);
                path = renderResponse.getHeader("Location");
            } while (301 <= status && status <= 303 && StringUtils.isNotBlank((CharSequence)path) && i-- > 0);
            if (status != 200) {
                throw new ResourceRenderingException(String.format("Could not load resource url=\"%s\". HTTP code: %d. Response headers %s. Body:\n%s", srcPath, status, NativeResourceRenderer.getHeaders(renderResponse), NativeResourceRenderer.getContentFirstPart(renderResponse, new ByteArrayInputStream(renderStream.toByteArray()), 500)));
            }
            String contentType = renderResponse.getContentType();
            String encoding = NativeResourceRenderer.getEncoding(renderResponse.getCharacterEncoding());
            ByteArrayInputStream stream = new ByteArrayInputStream(renderStream.toByteArray());
            ResourceStream resourceStream = new ResourceStream(stream, encoding, contentType);
            resourceStream.setBaseUrl(srcPath);
            return resourceStream;
        }
        catch (LoginException e) {
            throw new ResourceRenderingException(String.format("Failed to get an access to resource \"%s\"", srcPath), (Exception)((Object)e));
        }
        catch (IOException | ServletException e) {
            throw new ResourceRenderingException(String.format("Failed to loadResource resource \"%s\"", srcPath), (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new ResourceRenderingException(String.format("Resource path \"%s\" is invalid", srcPath), e);
        }
    }

    private static String getEncoding(String encoding) {
        if (StringUtils.isBlank((CharSequence)encoding)) {
            return Consts.UTF_8.name();
        }
        return encoding;
    }

    private static String getContentFirstPart(HttpServletResponse response, InputStream stream, int size) throws IOException {
        String responseBody = IOUtils.toString((InputStream)stream, (String)NativeResourceRenderer.getEncoding(response.getCharacterEncoding()));
        return StringUtils.substring((String)responseBody, (int)0, (int)size);
    }

    private static String getHeaders(HttpServletResponse response) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String header : response.getHeaderNames()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(String.format("name=\"%s\": value=\"%s\"", header, response.getHeader(header)));
        }
        return sb.toString();
    }

    protected void bindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        this.slingRequestProcessor = slingRequestProcessor;
    }

    protected void unbindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        if (this.slingRequestProcessor == slingRequestProcessor) {
            this.slingRequestProcessor = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

