/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl;

import com.day.cq.commons.LanguageUtil;
import java.util.Locale;
import java.util.Objects;

public final class Language {
    private final String code;
    private final String displayName;

    private Language(String code, String displayName) {
        this.code = Objects.requireNonNull(code, "Language code can not be null");
        this.displayName = Objects.requireNonNull(displayName, "Language display name can not be null");
    }

    public static Language forCode(String code) {
        Locale locale = LanguageUtil.getLocale((String)code);
        return Language.create(code, locale != null ? locale.getDisplayName() : code);
    }

    public static Language create(String code, String displayName) {
        return new Language(code, displayName);
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Language anotherLanguage = (Language)object;
        return Objects.equals(this.code, anotherLanguage.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return this.displayName + " [" + this.code + "]";
    }
}

