/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.property.mapping.service;

import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationObject;
import com.smartling.aem.connector.automation.impl.TranslationObjectType;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingException;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingService;
import com.smartling.aem.connector.automation.impl.property.mapping.PropertyMappingTranslationService;
import com.smartling.aem.connector.automation.impl.property.mapping.data.PropertyMappingRule;
import com.smartling.aem.connector.core.SmartlingException;
import com.smartling.aem.connector.core.impl.SmartlingFacade;
import com.smartling.aem.connector.core.impl.TranslationObjectToResourceAdapter;
import com.smartling.aem.connector.core.impl.integration.NoTranslatableContentException;
import com.smartling.aem.connector.core.impl.integration.NotSupportedFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component
@Service
public class SmartlingPropertyMappingTranslationService
implements PropertyMappingTranslationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartlingPropertyMappingTranslationService.class);
    @Reference
    private PropertyMappingService propertyMappingService;

    @Override
    public SmartlingFacade.Resource getTranslationResource(TranslationObject translationObject, TranslationObjectType translationObjectType) throws SmartlingException {
        try {
            InputStream translationObjectInputStream = translationObject.getTranslationObjectXMLInputStream();
            String originalContent = IOUtils.toString((InputStream)translationObjectInputStream, (Charset)StandardCharsets.UTF_8);
            LOGGER.trace("Property mapping will be applied to original source content={}", (Object)originalContent);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(originalContent));
            Document doc = db.parse(inputSource);
            Node rootNode = doc.getElementsByTagName("translationObjectFile").item(0);
            if (rootNode == null) {
                throw new NotSupportedFormatException("Couldn't not find \"translationObjectFile\" root element in translation object");
            }
            NodeList translationObjectPropertyNodes = ((Element)rootNode).getElementsByTagName("property");
            int propertyNodesLength = translationObjectPropertyNodes.getLength();
            LOGGER.debug("Found propertyCount={} properties in original XML", (Object)propertyNodesLength);
            if (propertyNodesLength == 0) {
                throw new NoTranslatableContentException("No translatable properties found");
            }
            for (int i = 0; i < propertyNodesLength; ++i) {
                Node propertyNode = translationObjectPropertyNodes.item(i);
                String propertyName = ((Element)propertyNode).getAttribute("propertyName");
                String nodePath = ((Element)propertyNode).getAttribute("nodePath");
                String content = propertyNode.getTextContent();
                Optional<PropertyMappingRule> rule = this.propertyMappingService.getRuleByProperty(nodePath, propertyName, content);
                String parserName = rule.map(PropertyMappingRule::getSmartlingParser).orElse("html");
                doc.renameNode(propertyNode, propertyNode.getNamespaceURI(), "property-" + parserName);
            }
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            String translatingObjectContent = writer.toString();
            InputStream stream = IOUtils.toInputStream((String)translatingObjectContent, (Charset)StandardCharsets.UTF_8);
            String fileType = ((Element)rootNode).getAttribute("fileType");
            SmartlingFacade.Type type = StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"I18NDICTIONARY") ? SmartlingFacade.Type.I18N : SmartlingFacade.Type.XML;
            return new TranslationObjectToResourceAdapter(translationObject, stream, type, translationObjectType);
        }
        catch (TranslationException e) {
            throw new PropertyMappingException("Translation object is invalid", (Exception)((Object)e));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NotSupportedFormatException("Couldn't parse translation object content", e);
        }
        catch (TransformerException e) {
            throw new PropertyMappingException("Couldn't translate object's DOM into stream", e);
        }
    }

    @Override
    public InputStream removeCustomizations(InputStream stream) throws PropertyMappingException {
        try {
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            content = content.replace("property-html", "property");
            content = content.replace("property-text", "property");
            InputStream cleanStream = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);
            LOGGER.trace("Property mapping is removed from translated content={}", (Object)content);
            return cleanStream;
        }
        catch (IOException e) {
            throw new PropertyMappingException("Couldn't remove smartling customizations", e);
        }
    }

    protected void bindPropertyMappingService(PropertyMappingService propertyMappingService) {
        this.propertyMappingService = propertyMappingService;
    }

    protected void unbindPropertyMappingService(PropertyMappingService propertyMappingService) {
        if (this.propertyMappingService == propertyMappingService) {
            this.propertyMappingService = null;
        }
    }
}

