/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.related;

import com.smartling.aem.connector.automation.impl.related.RelatedAssetUtils;
import com.smartling.aem.connector.automation.impl.related.RelatedDamAssetUtils;
import com.smartling.aem.connector.automation.impl.related.TranslatableNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatableNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslatableNode.class);
    public static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    public static final String JCR_CONTENT = "jcr:content";
    private final Node node;
    private final TranslatableNodeType type;

    TranslatableNode(Node node, TranslatableNodeType type) {
        this.node = node;
        this.type = type;
    }

    public static TranslatableNode build(Node node, TranslatableNodeType type) {
        return new TranslatableNode(node, type);
    }

    public static TranslatableNode build(Node node) {
        TranslatableNodeType type = RelatedAssetUtils.isPageNode(node) ? TranslatableNodeType.PAGE : TranslatableNodeType.ASSET;
        return new TranslatableNode(node, type);
    }

    public Node getNode() {
        return this.node;
    }

    public TranslatableNodeType getType() {
        return this.type;
    }

    public String getNodePrimaryType() {
        return RelatedAssetUtils.getStringAttribute(LOGGER, this.node, JCR_PRIMARY_TYPE, null);
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public Iterable<TranslatableNode> getChildNodes() throws RepositoryException {
        ArrayList nodeList = new ArrayList();
        this.node.getNodes().forEachRemaining(nodeList::add);
        return nodeList.stream().map(TranslatableNode::build).collect(Collectors.toList());
    }

    public boolean isContentFragment() {
        return RelatedAssetUtils.isContentFragment(this.node);
    }

    public List<TranslatableNode> getContentFragmentAssociatedAssets(ResourceResolver resourceResolver) throws RepositoryException {
        return RelatedDamAssetUtils.getContentFragmentAssociatedAssets(this.node, resourceResolver).stream().map(asset -> (TranslatableNode)asset.adaptTo(TranslatableNode.class)).collect(Collectors.toList());
    }

    public boolean isPageNode() {
        return RelatedAssetUtils.isPageNode(this.node);
    }

    public String getNodeResourceType() {
        return RelatedAssetUtils.getNodeResourceType(LOGGER, this.node, null);
    }

    public String getStringAttribute(String strAttributeName) {
        return RelatedAssetUtils.getStringAttribute(LOGGER, this.node, strAttributeName, null);
    }

    public TranslatableNode getBinaryNode() throws RepositoryException {
        return TranslatableNode.build(this.getBinaryNode(this.node));
    }

    private Node getBinaryNode(Node currentNode) throws RepositoryException {
        Node retVal;
        block1: {
            Node childNode;
            retVal = currentNode;
            if (currentNode == null || RelatedAssetUtils.isBinaryNode(currentNode)) break block1;
            NodeIterator nodeIterator = currentNode.getNodes();
            while (nodeIterator.hasNext() && (retVal = this.getBinaryNode(childNode = (Node)nodeIterator.next())) == null) {
            }
        }
        return retVal;
    }

    public List<TranslatableNode> getEmbeddedAssets(ResourceResolver resourceResolver) throws RepositoryException, IOException {
        return RelatedAssetUtils.getEmbeddedAssets(this.node.getPath(), resourceResolver).stream().map(asset -> (TranslatableNode)asset.adaptTo(TranslatableNode.class)).collect(Collectors.toList());
    }

    public boolean hasProperty(String propName) throws RepositoryException {
        return this.node.hasProperty(propName);
    }

    public TranslatableNode getParent() throws RepositoryException {
        Node parent = this.node.getParent();
        if (parent == null) {
            return null;
        }
        return TranslatableNode.build(parent);
    }

    public Property getProperty(String propName) throws RepositoryException {
        return this.node.getProperty(propName);
    }

    public TranslatableNode getNode(String name) throws RepositoryException {
        Node node = this.node.getNode(name);
        if (node == null) {
            return null;
        }
        return TranslatableNode.build(node);
    }

    public boolean isNodeOfPrimaryType(String strNodePrimaryType) {
        return RelatedAssetUtils.isNodeOfPrimaryType(this.node, strNodePrimaryType);
    }

    public List<String> getStringListAttribute(String strAttributeName) {
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            Property property;
            if (this.hasProperty(strAttributeName) && (property = this.getProperty(strAttributeName)) != null) {
                if (property.isMultiple()) {
                    Value[] values = property.getValues();
                    if (values != null) {
                        for (Value val : values) {
                            retVal.add(val.getString());
                        }
                    }
                } else {
                    Value value = property.getValue();
                    if (value != null) {
                        retVal.add(value.getString());
                    }
                }
            }
        }
        catch (RepositoryException ex) {
            LOGGER.error("Error while fetching string attribute " + strAttributeName, (Throwable)ex);
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslatableNode that = (TranslatableNode)o;
        try {
            return StringUtils.equalsAnyIgnoreCase((CharSequence)this.node.getPath(), (CharSequence[])new CharSequence[]{that.node.getPath()}) && this.type == that.type;
        }
        catch (RepositoryException e) {
            LOGGER.error("Couldn't check equality", (Throwable)e);
            return this.node.equals(that.node);
        }
    }

    public int hashCode() {
        try {
            return Objects.hash(new Object[]{StringUtils.lowerCase((String)this.node.getPath()), this.type});
        }
        catch (RepositoryException e) {
            LOGGER.error("Couldn't calculate hash for JCR Node", (Throwable)e);
            return Objects.hash(new Object[]{this.node, this.type});
        }
    }
}

