/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.day.cq.commons.Language;
import com.day.cq.commons.LanguageUtil;
import com.day.text.Text;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LanguageCopyManagerImpl
implements LanguageCopyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageCopyManagerImpl.class);
    public static final String AEM_CONFIGURED_LANGUAGES = "wcm/core/resources/languages";
    public static final String LANGUAGE_PROPERTY_NAME = "language";
    public static final String COUNTRY_PROPERTY_NAME = "country";
    public static final String CONTENT_LANGUAGE_PROPERTY_PATH = "jcr:content/jcr:language";

    protected static Function<LanguageCopyManager.LanguageCopy, String> languageCopyPath() {
        return languageCopy -> languageCopy.getPath();
    }

    protected static <T, V> Predicate<T> equalBy(Function<T, V> function, V value) {
        return Predicates.compose((Predicate)Predicates.equalTo(value), function);
    }

    protected static <T> T getProperty(ResourceResolver resourceResolver, String path, Class<T> type, String propertyName) {
        Resource resolved = resourceResolver.resolve(path);
        if (ResourceUtil.isNonExistingResource((Resource)resolved)) {
            return null;
        }
        Resource contentResource = resolved.getChild("jcr:content");
        if (contentResource != null) {
            return (T)contentResource.getValueMap().get(propertyName, type);
        }
        return null;
    }

    protected static Calendar getSourceLastModifiedTime(ResourceResolver resourceResolver, String path) {
        Resource contentResource = resourceResolver.resolve(path).getChild("jcr:content");
        if (contentResource == null) {
            return null;
        }
        ModifiableValueMap properties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        Calendar cqLastModified = LanguageCopyManagerImpl.getProperty(properties, "cq:lastModified", Calendar.class);
        Calendar jcrLastModified = LanguageCopyManagerImpl.getProperty(properties, "jcr:lastModified", Calendar.class);
        if (cqLastModified != null && jcrLastModified != null) {
            return cqLastModified.compareTo(jcrLastModified) > 0 ? cqLastModified : jcrLastModified;
        }
        if (jcrLastModified != null) {
            return jcrLastModified;
        }
        if (cqLastModified != null) {
            return cqLastModified;
        }
        return null;
    }

    protected static Calendar getTargetLastModifiedTime(ResourceResolver resourceResolver, String path) {
        Resource contentResource = resourceResolver.resolve(path).getChild("jcr:content");
        if (contentResource == null) {
            return null;
        }
        ModifiableValueMap properties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        return LanguageCopyManagerImpl.getProperty(properties, "cq:lastTranslationUpdate", Calendar.class);
    }

    protected static <T> T getProperty(ModifiableValueMap properties, String name, Class<T> type) {
        if (properties.containsKey((Object)name)) {
            return (T)properties.get(name, type);
        }
        return null;
    }

    protected static String getLanguageDisplayName(ResourceResolver resolver, String langCode) {
        String langDisplayName = null;
        String countryDisplayName = "*";
        Resource languagesHome = resolver.getResource(AEM_CONFIGURED_LANGUAGES);
        Resource language = LanguageCopyManagerImpl.getLanguage(languagesHome, langCode);
        if (language != null) {
            ValueMap langProperties = (ValueMap)language.adaptTo(ValueMap.class);
            langDisplayName = (String)langProperties.get(LANGUAGE_PROPERTY_NAME, String.class);
            countryDisplayName = (String)langProperties.get(COUNTRY_PROPERTY_NAME, String.class);
        }
        if (StringUtils.isBlank(langDisplayName)) {
            return langCode;
        }
        String displayName = langDisplayName;
        if (StringUtils.isNotBlank((CharSequence)countryDisplayName) && !StringUtils.equals((CharSequence)countryDisplayName, (CharSequence)"*")) {
            displayName = displayName + " (" + countryDisplayName + ")";
        }
        return displayName + " [" + langCode + "]";
    }

    @Override
    public String getCqLanguage(Resource res) {
        String path = res.getPath();
        int idx = path.indexOf("/jcr:content");
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        try {
            for (Node node = (hr = res.getResourceResolver().getResource(path)) == null ? null : (Node)hr.adaptTo(Node.class); node != null && node.getDepth() > 2; node = node.getParent()) {
                if (!node.hasProperty(CONTENT_LANGUAGE_PROPERTY_PATH)) continue;
                String iso = node.getProperty(CONTENT_LANGUAGE_PROPERTY_PATH).getString();
                Language locale = LanguageUtil.getLanguage((String)iso);
                if (locale == null) {
                    LOGGER.warn("Invalid iso code stored in {}: {}", (Object)node.getPath(), (Object)iso);
                    continue;
                }
                return locale.toString();
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.warn("The current session does not have sufficient access to retrieve the parent of this item.", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOGGER.warn("Error while retrieving language property.", (Throwable)e);
        }
        String languageRoot = LanguageUtil.getLanguageRoot((String)path);
        if (languageRoot != null) {
            return Text.getName((String)languageRoot);
        }
        return null;
    }

    private static Resource getLanguage(Resource languagesHome, String languageCode) {
        if (languagesHome != null) {
            languageCode = languageCode.toLowerCase();
            String langWithUnderscore = languageCode.replace("-", "_");
            String langWithHyphen = languageCode.replace("_", "-");
            Resource languageRes = languagesHome.getChild(langWithUnderscore);
            if (languageRes == null) {
                languageRes = languagesHome.getChild(langWithHyphen);
            }
            return languageRes;
        }
        return null;
    }

    protected Resource skipRootContentResource(Resource root) {
        return root != null && StringUtils.equalsIgnoreCase((CharSequence)root.getName(), (CharSequence)"jcr:content") ? root.getParent() : root;
    }

    @Override
    public boolean isSourceChangedAfterTranslation(ResourceResolver resourceResolver, String sourcePath, String targetPath) {
        Calendar sourceLastModifiedTime = LanguageCopyManagerImpl.getSourceLastModifiedTime(resourceResolver, sourcePath);
        Calendar targetLastModifiedTime = LanguageCopyManagerImpl.getTargetLastModifiedTime(resourceResolver, targetPath);
        return targetLastModifiedTime == null || sourceLastModifiedTime != null && sourceLastModifiedTime.getTimeInMillis() - targetLastModifiedTime.getTimeInMillis() > 2000L;
    }
}

