/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.localization;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.smartling.aem.connector.automation.impl.OrderResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Service
@Component
public class OrderResolverImpl
implements OrderResolver {
    @Override
    public String getNextPageName(Resource sourcePage, Resource targetPage) {
        Resource sourcePageParent = sourcePage.getParent();
        Resource targetPageParent = targetPage.getParent();
        if (sourcePageParent != null && targetPageParent != null) {
            ArrayList pagesOnSameLevelInSourceTree = Lists.newArrayList((Iterator)sourcePageParent.listChildren());
            ArrayList pagesOnSameLevelInTargetTree = Lists.newArrayList((Iterator)targetPageParent.listChildren());
            Iterable<Resource> nextPagesToSourceInSourceTree = this.getPagesAfter(sourcePage.getName(), pagesOnSameLevelInSourceTree);
            Optional<Resource> nextPageInTargetTree = this.getNextPageInTargetTree(nextPagesToSourceInSourceTree, pagesOnSameLevelInTargetTree);
            return nextPageInTargetTree.isPresent() ? ((Resource)nextPageInTargetTree.get()).getName() : null;
        }
        return null;
    }

    private Optional<Resource> getNextPageInTargetTree(Iterable<Resource> nextPagesToSourceInSourceTree, List<Resource> pagesOnSameLevelInTargetTree) {
        return FluentIterable.from(nextPagesToSourceInSourceTree).firstMatch(this.hasPageWithSameNameInTargetTree(pagesOnSameLevelInTargetTree));
    }

    private Predicate<? super Resource> hasPageWithSameNameInTargetTree(final List<Resource> pagesOnSameLevelInTargetTree) {
        return new Predicate<Resource>(){

            public boolean apply(Resource nextPageInSourceTree) {
                return FluentIterable.from((Iterable)pagesOnSameLevelInTargetTree).anyMatch(this.hasPageWithSameName(nextPageInSourceTree));
            }

            private Predicate<? super Resource> hasPageWithSameName(final Resource nextPageInSourceTree) {
                return new Predicate<Resource>(){

                    public boolean apply(Resource pageInTargetTree) {
                        return pageInTargetTree.getName().equals(nextPageInSourceTree.getName());
                    }
                };
            }
        };
    }

    private Iterable<Resource> getPagesAfter(final String name, List<Resource> pagesOnSameLevelInSourceTree) {
        return Iterables.filter(pagesOnSameLevelInSourceTree, (Predicate)new Predicate<Resource>(){
            private boolean pageFound;

            public boolean apply(Resource input) {
                if (input.getName().equals(name)) {
                    this.pageFound = true;
                    return false;
                }
                return this.pageFound;
            }
        });
    }
}

