/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.project;

import com.day.cq.commons.jcr.JcrUtil;
import com.google.common.base.Splitter;
import com.smartling.aem.connector.automation.impl.TranslationJob;
import com.smartling.aem.connector.automation.impl.TranslationProject;
import com.smartling.aem.connector.automation.impl.TranslationProjectException;
import com.smartling.aem.connector.automation.impl.TranslationProjectManager;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobMetadata;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationJobResource;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationProjectCreateOptions;
import com.smartling.aem.connector.automation.impl.wcm.project.TranslationProjectResource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={TranslationProjectManager.class})
@Component(label="Smartling - Translation Project Manager (Touch)", immediate=true, metatype=true, description="Entry point for any processing related to AEM translation project")
public class TranslationProjectResourceManager
implements TranslationProjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationProjectResourceManager.class);
    public static final String PROJECTS_ROOT = "/content/projects";
    private static final String SMARTLING_PROJECTS_ROOT = "smartling-auto";
    private static final String TRANSLATION_OBJECT_QUERY = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE('%s') and s.translationObjectID='%s'";
    public static final String PROJECT_RESOURCE_TYPE = "cq/gui/components/projects/admin/card/projectcard";
    public static final String PROJECT_CONTENT_RESOURCE_TYPE = "cq/gui/components/projects/admin/card/projectcontent";
    public static final String PROJECT_FOLDER_RESOURCE_TYPE = "cq/gui/components/projects/admin/card/foldercard";
    public static final String SLING_RESOURCE_TYPE_PROPERTY_NAME = "sling:resourceType";
    public static final String TRANSLATION_PROJECT_QUERY = "SELECT * FROM [nt:base] AS s WHERE ISDESCENDANTNODE('%s') and s.[jcr:title]='%s' and s.[sling:resourceType]='%s'";
    public static final String TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING = "translationAutomaticApproveEnable";
    public static final String TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING = "translationAutomaticDeleteLaunchEnable";
    public static final String TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING = "translationAutomaticPromoteLaunchEnable";
    public static final int POLLING_RETRY_COUNT_MAX_VALUE = 50;
    public static final int POLLING_RETRY_COUNT_MIN_VALUE = 10;
    public static final int POLLING_RETRY_COUNT_DEFAULT_VALUE = 40;
    @Property(label="Polling retry count", description="Retry count for searching a project by job ID. Min 10, max 50", intValue={40})
    public static final String POLLING_RETRY_COUNT_PROP = "polling.retry.count";
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_MAX_VALUE = 500;
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_MIN_VALUE = 100;
    public static final int POLLING_RETRY_SLEEP_IN_MILLIS_DEFAULT_VALUE = 300;
    @Property(label="Polling retry sleep period in ms", description="Sleep periods between tries for searching a project by job ID in ms. Min 100ms, max 500ms", intValue={300})
    public static final String POLLING_RETRY_SLEEP_PROP = "polling.retry.sleep";
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_MAX_VALUE = 30;
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_MIN_VALUE = 10;
    public static final int POLLING_UPLOAD_COMPLETE_IN_MINUTES_DEFAULT_VALUE = 20;
    @Property(label="Polling upload complete period in minutes", description="Polling periods between checks for uploading is completed in minutes. Min 10mins, max 30mins", intValue={20})
    public static final String POLLING_UPLOAD_COMPLETE_PROP = "polling.upload.complete";
    public static final String AEM_SOURCE_LANGUAGE_CODE_PROPERTY_NAME = "aemSourceLanguageCode";
    public static final String AEM_TARGET_LANGUAGE_CODE_PROPERTY_NAME = "aemTargetLanguageCode";
    public static final String AEM_JOB_NAME_PROPERTY_NAME = "aemTranslationJobName";
    public static final String AEM_JOB_ID_PROPERTY_NAME = "aemTranslationJobId";
    public static final String AEM_USER_ID_PROPERTY_NAME = "aemUserId";
    public static final String AEM_PROJECT_NAME = "aemProjectName";
    public static final String TRANSLATION_JOB_METADATA_QUERY = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE('%s') and s.aemTranslationJobId='%s' ORDER BY s.'jcr:created' DESC";
    public static final String SMARTLING_METADATA_NODE_NAME = "smartling-metadata";
    private static final boolean AUTO_APPROVE_ENABLE_DEFAULT_VALUE = true;
    @Property(label="Enable Automatic Approve", description="Enables / Disables automatic approve translation project feature.", boolValue={true})
    public static final String AUTO_APPROVE_ENABLE_PROP = "translation.project.enable.approve";
    private static final boolean AUTO_DELETE_ENABLE_DEFAULT_VALUE = true;
    @Property(label="Enable Automatic Delete", description="Enables / Disables automatic delete translation project feature.", boolValue={true})
    public static final String AUTO_DELETE_ENABLE_PROP = "translation.project.enable.delete";
    private static final boolean AUTO_PROMOTE_LAUNCH_ENABLE_DEFAULT_VALUE = true;
    @Property(label="Enable Automatic Promote Launch", description="Enables / Disables automatic launch promote translation project feature.", boolValue={true})
    public static final String AUTO_PROMOTE_LAUNCH_ENABLE_PROP = "translation.project.enable.promote.launch";
    private int pollingRetryCount;
    private int pollingRetrySleep;
    private int pollingUploadComplete;
    private boolean autoApproveEnable;
    private boolean autoDeleteEnable;
    private boolean autoPromoteLaunchEnable;
    @Reference
    private SlingRepository repository;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.pollingRetryCount = PropertiesUtil.toInteger((Object)properties.get(POLLING_RETRY_COUNT_PROP), (int)40);
        this.pollingRetryCount = Math.max(this.pollingRetryCount, 10);
        this.pollingRetryCount = Math.min(this.pollingRetryCount, 50);
        this.pollingRetrySleep = PropertiesUtil.toInteger((Object)properties.get(POLLING_RETRY_SLEEP_PROP), (int)300);
        this.pollingRetrySleep = Math.max(this.pollingRetrySleep, 100);
        this.pollingRetrySleep = Math.min(this.pollingRetrySleep, 500);
        this.pollingUploadComplete = PropertiesUtil.toInteger((Object)properties.get(POLLING_UPLOAD_COMPLETE_PROP), (int)20);
        this.pollingUploadComplete = Math.max(this.pollingUploadComplete, 10);
        this.pollingUploadComplete = Math.min(this.pollingUploadComplete, 30);
        this.autoApproveEnable = PropertiesUtil.toBoolean((Object)properties.get(AUTO_APPROVE_ENABLE_PROP), (boolean)true);
        this.autoDeleteEnable = PropertiesUtil.toBoolean((Object)properties.get(AUTO_DELETE_ENABLE_PROP), (boolean)true);
        this.autoPromoteLaunchEnable = PropertiesUtil.toBoolean((Object)properties.get(AUTO_PROMOTE_LAUNCH_ENABLE_PROP), (boolean)true);
    }

    @Override
    public String createProjectFolder(ResourceResolver resourceResolver, TranslationProjectCreateOptions options) throws TranslationProjectException {
        try {
            return this.createProjectFolderNode(resourceResolver, options).getPath();
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException("Failed to create project folder:", e);
        }
    }

    @Override
    public TranslationProject getProject(ResourceResolver resourceResolver, String aemTranslationProjectPath) {
        Resource projectContentResource = resourceResolver.resolve(aemTranslationProjectPath).getChild("jcr:content");
        if (projectContentResource != null) {
            return new TranslationProjectResource(projectContentResource);
        }
        return null;
    }

    @Override
    public TranslationProject getProjectByTranslationJobId(ResourceResolver resourceResolver, String aemTranslationJobId) throws TranslationProjectException {
        Node translationJobNode = this.getTranslationJobNode(resourceResolver, aemTranslationJobId);
        String projectPath = this.findProjectPath(translationJobNode);
        Resource projectResource = resourceResolver.getResource(projectPath);
        if (projectResource == null) {
            throw new TranslationProjectException(String.format("Couldn't find translation project by path=\"%s\"", projectPath));
        }
        return new TranslationProjectResource(projectResource.getChild("jcr:content"));
    }

    @Override
    public TranslationJob getTranslationJobById(ResourceResolver resourceResolver, String aemTranslationJobId) throws TranslationProjectException {
        try {
            Node translationJobNode = this.getTranslationJobNode(resourceResolver, aemTranslationJobId);
            Resource translationJobResource = resourceResolver.getResource(translationJobNode.getPath());
            return new TranslationJobResource(translationJobResource);
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Couldn't get translation job resource by aemJobId=\"%s\"", aemTranslationJobId), e);
        }
    }

    @NotNull
    private Node getTranslationJobNode(ResourceResolver resourceResolver, String jobId) throws TranslationProjectException {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                throw new TranslationProjectException("Couldn't take a repository session");
            }
            String queryString = String.format(TRANSLATION_OBJECT_QUERY, PROJECTS_ROOT, jobId);
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = this.getNodesWithRetries(jobId, query);
            if (nodes != null && nodes.hasNext()) {
                return nodes.nextNode();
            }
            throw new TranslationProjectException(String.format("Couldn't find translation job by aemJobId=\"%s\"", jobId));
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Failed to get translation job by aemJobId=\"%s\"", jobId), e);
        }
    }

    @NotNull
    private Node getProjectContentNode(ResourceResolver resourceResolver, String projectName) throws TranslationProjectException {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                throw new TranslationProjectException("Couldn't take a repository session");
            }
            String queryString = String.format(TRANSLATION_PROJECT_QUERY, PROJECTS_ROOT, projectName, PROJECT_CONTENT_RESOURCE_TYPE);
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = query.execute().getNodes();
            if (nodes != null && nodes.hasNext()) {
                return nodes.nextNode();
            }
            throw new TranslationProjectException(String.format("Couldn't find translation project by name=\"%s\"", projectName));
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Failed to find translation project by name=\"%s\"", projectName), e);
        }
    }

    @Override
    public boolean applyProjectCustomizations(ResourceResolver resourceResolver, String projectPath) {
        String projectContentPath = projectPath + "/" + "jcr:content";
        Resource projectContent = resourceResolver.resolve(projectContentPath);
        if (ResourceUtil.isNonExistingResource((Resource)projectContent)) {
            LOGGER.warn("Project content path=\"{}\" haven't been created yet.", (Object)projectContentPath);
            return false;
        }
        Node projectContentNode = (Node)projectContent.adaptTo(Node.class);
        if (projectContentNode == null) {
            LOGGER.error("Project content path=\"{}\" is not a JCR node.", (Object)projectContentPath);
            return true;
        }
        try {
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING);
            } else {
                projectContentNode.setProperty(TRANSLATION_AUTOMATIC_APPROVE_ENABLE_SETTING, this.autoApproveEnable);
            }
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING);
            } else {
                projectContentNode.setProperty(TRANSLATION_AUTOMATIC_DELETE_ENABLE_SETTING, this.autoDeleteEnable);
            }
            if (!projectContentNode.hasProperty(TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING)) {
                LOGGER.warn("Project content path=\"{}\" doesn't have a property=\"{}\"", (Object)projectContentPath, (Object)TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING);
            } else {
                projectContentNode.setProperty(TRANSLATION_AUTOMATIC_PROMOTE_LAUNCH_ENABLE_SETTING, this.autoPromoteLaunchEnable);
            }
            resourceResolver.commit();
            LOGGER.info("Project path=\"{}\" is customized successfully", (Object)projectPath);
        }
        catch (RepositoryException | PersistenceException e) {
            LOGGER.error("Failed to customize translation project path=\"{}\"", (Object)projectPath, (Object)e);
        }
        return true;
    }

    public int getPollingRetryCount() {
        return this.pollingRetryCount;
    }

    public int getPollingRetrySleep() {
        return this.pollingRetrySleep;
    }

    @Override
    public int getPollingUploadComplete() {
        return this.pollingUploadComplete;
    }

    @Override
    public void writeTranslationJobMetadata(ResourceResolver resourceResolver, String aemTranslationJobName, String aemTranslationJobId, String aemSourceLanguageCode, String aemTargetLanguageCode) throws TranslationProjectException {
        String projectName = StringUtils.substringBeforeLast((String)aemTranslationJobName, (String)"_");
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                throw new TranslationProjectException("Couldn't take a repository session");
            }
            String metadataFolder = TranslationProjectResourceManager.generateDayOfTheYearFolderRelativePath(SMARTLING_METADATA_NODE_NAME);
            Node metadataFolderNode = TranslationProjectResourceManager.getOrCreateFolder(session, metadataFolder);
            Node jobNode = TranslationProjectResourceManager.getOrCreateChildNodeByName(metadataFolderNode, aemTranslationJobId);
            JcrUtil.setProperty((Node)jobNode, (String)AEM_JOB_NAME_PROPERTY_NAME, (Object)aemTranslationJobName);
            JcrUtil.setProperty((Node)jobNode, (String)AEM_JOB_ID_PROPERTY_NAME, (Object)aemTranslationJobId);
            JcrUtil.setProperty((Node)jobNode, (String)AEM_SOURCE_LANGUAGE_CODE_PROPERTY_NAME, (Object)aemSourceLanguageCode);
            JcrUtil.setProperty((Node)jobNode, (String)AEM_TARGET_LANGUAGE_CODE_PROPERTY_NAME, (Object)aemTargetLanguageCode);
            JcrUtil.setProperty((Node)jobNode, (String)AEM_PROJECT_NAME, (Object)projectName);
            Calendar now = Calendar.getInstance();
            JcrUtil.setProperty((Node)jobNode, (String)"jcr:lastModified", (Object)now);
            JcrUtil.setProperty((Node)jobNode, (String)"jcr:created", (Object)now);
            session.save();
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Failed to find translation job metadata by aemJobId=\"%s\"", aemTranslationJobId), e);
        }
    }

    @Override
    public TranslationJobMetadata getTranslationJobMetadata(ResourceResolver resourceResolver, String aemTranslationJobId) throws TranslationProjectException {
        try {
            Node projectContentNode;
            TranslationJobMetadata.TranslationJobMetadataBuilder metadataBuilder = TranslationJobMetadata.builder();
            Node jobMetadataNode = this.getJobMetadataNode(resourceResolver, aemTranslationJobId);
            metadataBuilder.aemJobId(aemTranslationJobId);
            metadataBuilder.aemSourceLanguage(JcrUtils.getStringProperty((Node)jobMetadataNode, (String)AEM_SOURCE_LANGUAGE_CODE_PROPERTY_NAME, (String)""));
            metadataBuilder.aemTargetLanguage(JcrUtils.getStringProperty((Node)jobMetadataNode, (String)AEM_TARGET_LANGUAGE_CODE_PROPERTY_NAME, (String)""));
            String projectName = JcrUtils.getStringProperty((Node)jobMetadataNode, (String)AEM_PROJECT_NAME, (String)"");
            if (StringUtils.isBlank((CharSequence)projectName)) {
                return metadataBuilder.build();
            }
            Node traverseNode = projectContentNode = this.getProjectContentNode(resourceResolver, projectName);
            Node projectFolderNode = null;
            while (projectFolderNode == null && !PROJECTS_ROOT.equalsIgnoreCase(traverseNode.getPath())) {
                if (this.hasType(traverseNode, PROJECT_FOLDER_RESOURCE_TYPE)) {
                    projectFolderNode = traverseNode;
                }
                traverseNode = traverseNode.getParent();
            }
            metadataBuilder.smartlingJobUid(this.getStringProperty(projectContentNode, projectFolderNode, "jobUid"));
            metadataBuilder.smartlingBatchUid(this.getStringProperty(projectContentNode, projectFolderNode, "batchUid"));
            metadataBuilder.configSourceLocaleCode(this.getStringProperty(projectContentNode, projectFolderNode, "configSourceLocaleCode"));
            metadataBuilder.smartlingProjectUid(this.getStringProperty(projectContentNode, projectFolderNode, "projectUid"));
            return metadataBuilder.build();
        }
        catch (RepositoryException ex) {
            throw new TranslationProjectException(String.format("Couldn't find translation job metadata by aemJobId=\"%s\"", aemTranslationJobId));
        }
    }

    private String getStringProperty(Node node1, Node node2, String propertyName) throws RepositoryException {
        String propertyValue = null;
        if (node1 != null) {
            propertyValue = JcrUtils.getStringProperty((Node)node1, (String)propertyName, null);
        }
        if (StringUtils.isBlank(propertyValue) && node2 != null) {
            return JcrUtils.getStringProperty((Node)node2, (String)propertyName, null);
        }
        return propertyValue;
    }

    private boolean hasType(Node node, String type) throws RepositoryException {
        return type != null && type.equalsIgnoreCase(JcrUtils.getStringProperty((Node)node, (String)SLING_RESOURCE_TYPE_PROPERTY_NAME, null));
    }

    @NotNull
    private static Node getOrCreateChildNodeByName(Node parentNode, String childName) throws RepositoryException {
        if (!parentNode.hasNode(childName)) {
            return parentNode.addNode(childName, "nt:unstructured");
        }
        return parentNode.getNode(childName);
    }

    private Node getJobMetadataNode(ResourceResolver resourceResolver, String jobId) throws TranslationProjectException {
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (session == null) {
                throw new TranslationProjectException("Couldn't take a repository session");
            }
            String queryString = String.format(TRANSLATION_JOB_METADATA_QUERY, "/content/projects/smartling-metadata", jobId);
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = this.getNodesWithRetries(jobId, query);
            if (nodes != null && nodes.hasNext()) {
                return nodes.nextNode();
            }
            throw new TranslationProjectException(String.format("Couldn't find translation job metadata by aemJobId=\"%s\"", jobId));
        }
        catch (RepositoryException e) {
            throw new TranslationProjectException(String.format("Failed to find translation job metadata by aemJobId=\"%s\"", jobId), e);
        }
    }

    private NodeIterator getNodesWithRetries(String jobId, Query query) {
        NodeIterator nodeIterator = null;
        try {
            for (int retryCounter = 1; retryCounter < this.pollingRetryCount; ++retryCounter) {
                try {
                    LOGGER.info("Going to find Translation job node by aemJobId=\"{}\"", (Object)jobId);
                    nodeIterator = query.execute().getNodes();
                }
                catch (RepositoryException e) {
                    LOGGER.error("Failed to find translation AEM job by id=\"{}\"", (Object)jobId, (Object)e);
                    break;
                }
                if (nodeIterator.hasNext()) {
                    return nodeIterator;
                }
                Thread.sleep(this.pollingRetrySleep);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.error("Thread is interrupted on retrying to find Translation Job node", (Throwable)ex);
        }
        return nodeIterator;
    }

    private String findProjectPath(Node translationObjectNode) throws TranslationProjectException {
        String translationObjectNodePath = null;
        try {
            Node seekNode;
            translationObjectNodePath = translationObjectNode.getPath();
            for (seekNode = translationObjectNode; seekNode != null && !PROJECT_RESOURCE_TYPE.equalsIgnoreCase(JcrUtils.getStringProperty((Node)seekNode, (String)SLING_RESOURCE_TYPE_PROPERTY_NAME, (String)"")); seekNode = seekNode.getParent()) {
            }
            if (seekNode == null) {
                throw new TranslationProjectException(String.format("Couldn't find translation project for node \"%s\"", translationObjectNodePath));
            }
            return seekNode.getPath();
        }
        catch (RepositoryException ex) {
            throw new TranslationProjectException(String.format("Couldn't find translation project for node \"%s\"", translationObjectNodePath));
        }
    }

    private Node createProjectFolderNode(ResourceResolver resourceResolver, TranslationProjectCreateOptions options) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        String projectFolderRelativePath = TranslationProjectResourceManager.generateDayOfTheYearFolderRelativePath(SMARTLING_PROJECTS_ROOT);
        String folderName = TranslationProjectResourceManager.generateProjectFolderNodeName(options.getTitle());
        Node projectFolderNode = this.createInSeparateSession(session, projectFolderRelativePath + "/" + folderName);
        projectFolderNode.setProperty("jobUid", options.getJobUid());
        projectFolderNode.setProperty("batchUid", options.getBatchUid());
        projectFolderNode.setProperty("configSourceLocaleCode", options.getConfigSourceLocaleCode());
        projectFolderNode.setProperty(AEM_USER_ID_PROPERTY_NAME, options.getUserId());
        projectFolderNode.setProperty("projectUid", options.getProjectUid());
        projectFolderNode.setProperty("pseudo", options.isPseudo());
        projectFolderNode.setProperty("autoAuthorize", options.isAutoAuthorize());
        session.save();
        return projectFolderNode;
    }

    private static String generateProjectFolderNodeName(String title) {
        SimpleDateFormat timeOfTheDay = new SimpleDateFormat("HH-mm-ss-S");
        String nodeName = StringUtils.length((CharSequence)title) > 51 ? StringUtils.left((String)title, (int)51) : title;
        nodeName = nodeName + "-" + timeOfTheDay.format(new Date());
        return JcrUtil.createValidName((String)nodeName);
    }

    private static String generateDayOfTheYearFolderRelativePath(String name) {
        SimpleDateFormat dayOfTheYear = new SimpleDateFormat("yyyy/MM/dd");
        return name + "/" + dayOfTheYear.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createInSeparateSession(Session session, String path) throws RepositoryException {
        if (session.nodeExists("/content/projects/" + path)) {
            return session.getNode("/content/projects/" + path);
        }
        Session serviceSession = this.repository.loginService(null, null);
        try {
            Node folderNode = TranslationProjectResourceManager.getOrCreateFolder(serviceSession, path);
            session.refresh(true);
            Node node = session.getNode(folderNode.getPath());
            return node;
        }
        finally {
            serviceSession.logout();
        }
    }

    private static Node getOrCreateFolder(Session session, String relativePath) throws RepositoryException {
        Iterable segments = Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)relativePath);
        Node node = session.getNode(PROJECTS_ROOT);
        for (String nextNodeName : segments) {
            try {
                Node child = node.addNode(nextNodeName, "sling:OrderedFolder");
                child.setProperty(SLING_RESOURCE_TYPE_PROPERTY_NAME, PROJECT_FOLDER_RESOURCE_TYPE);
                child.setProperty("jcr:title", nextNodeName);
                session.save();
            }
            catch (RepositoryException e) {
                if (node.hasNode(nextNodeName)) {
                    session.refresh(false);
                }
                throw e;
            }
            node = node.getNode(nextNodeName);
        }
        return node;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

