/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.wcm.workflow;

import com.smartling.aem.connector.automation.impl.wcm.workflow.TranslationWorkflow;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={TranslationWorkflowManager.class})
@Component
public class TranslationWorkflowManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationWorkflowManager.class);
    public static final String WORKFLOW_INSTANCES_ROOT = "/var/workflow/instances";
    public static final String WORKFLOW_METADATA_QUERY = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE('%s') and s.projectFolderPath='%s'";
    public static final String CQ_WORKFLOW_NODE_TYPE = "cq:Workflow";
    public static final String MODEL_ID_PROPERTY_NAME = "modelId";
    public static final String START_TIME_PROPERTY_NAME = "startTime";
    public static final String STATUS_PROPERTY_NAME = "status";
    public static final String WORK_ITEMS_NODE_NAME = "workItems";
    public static final String META_DATA_NODE_NAME = "metaData";
    public static final String FAILED_NODE_TITLE_PROPERTY_NAME = "failedNodeTitle";
    public static final String FAILURE_MESSAGE_PROPERTY_NAME = "failureMessage";
    public static final String FAILURE_STACK_PROPERTY_NAME = "failureStack";

    public List<TranslationWorkflow> getAEMTranslationWorkflows(String projectPath, ResourceResolver resourceResolver) {
        ArrayList<TranslationWorkflow> wfs = new ArrayList<TranslationWorkflow>();
        try {
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            String queryString = String.format(WORKFLOW_METADATA_QUERY, WORKFLOW_INSTANCES_ROOT, projectPath);
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "JCR-SQL2");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes != null && nodes.hasNext()) {
                Node metadataNode = nodes.nextNode();
                Node workflowInstanceNode = metadataNode.getParent();
                if (!workflowInstanceNode.isNodeType(CQ_WORKFLOW_NODE_TYPE)) continue;
                TranslationWorkflow.TranslationWorkflowBuilder wf = TranslationWorkflow.builder().path(workflowInstanceNode.getPath());
                try {
                    wf.modelId(workflowInstanceNode.getProperty(MODEL_ID_PROPERTY_NAME).getString()).startTime(workflowInstanceNode.getProperty(START_TIME_PROPERTY_NAME).getDate()).status(workflowInstanceNode.getProperty(STATUS_PROPERTY_NAME).getString());
                }
                catch (PathNotFoundException e) {
                    LOGGER.error("Couldn't find a property at workflow instance path=\"{}\"", (Object)workflowInstanceNode.getPath());
                }
                this.fillWorkItemsIssues(workflowInstanceNode, wf);
                wfs.add(wf.build());
            }
        }
        catch (RepositoryException e) {
            LOGGER.error("Couldn't read AEM workflow instances info");
        }
        return wfs;
    }

    private void fillWorkItemsIssues(Node workflowInstanceNode, TranslationWorkflow.TranslationWorkflowBuilder wf) throws RepositoryException {
        Node workItemsNode = workflowInstanceNode.getNode(WORK_ITEMS_NODE_NAME);
        if (workItemsNode == null) {
            return;
        }
        NodeIterator itemsIterator = workItemsNode.getNodes();
        while (itemsIterator != null && itemsIterator.hasNext()) {
            Node item = itemsIterator.nextNode();
            Node itemMetadata = item.getNode(META_DATA_NODE_NAME);
            if (itemMetadata == null) continue;
            try {
                wf.failedNodeTitle(itemMetadata.getProperty(FAILED_NODE_TITLE_PROPERTY_NAME).getString());
                wf.failureMessage(itemMetadata.getProperty(FAILURE_MESSAGE_PROPERTY_NAME).getString());
                wf.failureStack(itemMetadata.getProperty(FAILURE_STACK_PROPERTY_NAME).getString());
            }
            catch (PathNotFoundException e) {
                LOGGER.error("Couldn't find a property at workItem metadata path=\"{}\"", (Object)itemMetadata.getPath());
            }
        }
    }
}

