/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.smartling.aem.connector.automation.impl.LanguageCopyManager;
import com.smartling.aem.connector.automation.impl.PageLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.automation.impl.workflow.context.ContextAwareWorkflowProcess;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class CreateNotExistedPageLanguageCopiesProcess
extends ContextAwareWorkflowProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateNotExistedPageLanguageCopiesProcess.class);
    private static final String CREATE_LANGUAGE_COPY_ERROR_MESSAGE = "Failed to create non existed language copy page path=\"%s\"";
    @Reference
    protected PageLanguageCopyManager languageCopyManager;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String payloadPagePath = (String)workItem.getWorkflowData().getPayload();
        try {
            JobWorkflowParameters workflowParameters = new JobWorkflowParameters(workItem);
            ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
            this.copyNotExistedLanguageCopies(resourceResolver, payloadPagePath, workflowParameters);
        }
        catch (Exception e) {
            LOGGER.error(String.format(CREATE_LANGUAGE_COPY_ERROR_MESSAGE, payloadPagePath), (Throwable)e);
            throw new WorkflowException(String.format(CREATE_LANGUAGE_COPY_ERROR_MESSAGE, payloadPagePath), (Throwable)e);
        }
    }

    private void copyNotExistedLanguageCopies(ResourceResolver resourceResolver, String sourcePath, JobWorkflowParameters workflowParameters) throws Exception {
        this.createNonExistedLanguageCopy(resourceResolver, sourcePath, workflowParameters);
        if (!workflowParameters.isDeep()) {
            return;
        }
        TreeSet<String> excludedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        excludedPaths.addAll(workflowParameters.getExcludedPathList());
        List<String> childrenPaths = this.languageCopyManager.getSubpagesPaths(resourceResolver, sourcePath, excludedPaths);
        for (String childPath : childrenPaths) {
            this.createNonExistedLanguageCopy(resourceResolver, childPath, workflowParameters);
        }
    }

    private void createNonExistedLanguageCopy(ResourceResolver resourceResolver, String sourcePath, JobWorkflowParameters workflowParameters) throws Exception {
        Set<String> targetLocaleCodes = workflowParameters.getTargetLocaleCodes();
        Iterable languageCopies = StreamSupport.stream(this.languageCopyManager.findLanguageCopies(resourceResolver, sourcePath).spliterator(), false).filter(arg_0 -> WorkflowUtil.byLocaleCode((Predicate<String>)Predicates.in(targetLocaleCodes)).apply(arg_0)).filter(languageCopy -> !languageCopy.exists()).collect(Collectors.toList());
        boolean deep = false;
        for (LanguageCopyManager.LanguageCopy languageCopy2 : languageCopies) {
            this.languageCopyManager.createLanguageCopy(resourceResolver, sourcePath, languageCopy2.getPath(), deep);
            LOGGER.info("Copied language page path=\"{}\" from source path=\"{}\"", (Object)languageCopy2.getPath(), (Object)sourcePath);
        }
    }

    protected void bindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        this.languageCopyManager = pageLanguageCopyManager;
    }

    protected void unbindLanguageCopyManager(PageLanguageCopyManager pageLanguageCopyManager) {
        if (this.languageCopyManager == pageLanguageCopyManager) {
            this.languageCopyManager = null;
        }
    }
}

