/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.automation.impl.workflow;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.smartling.aem.connector.automation.impl.AssetLanguageCopyManager;
import com.smartling.aem.connector.automation.impl.workflow.DetermineTargetLocalesProcess;
import com.smartling.aem.connector.automation.impl.workflow.JobWorkflowParameters;
import com.smartling.aem.connector.automation.impl.workflow.WorkflowUtil;
import com.smartling.aem.connector.core.SmartlingCloudConfig;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component
public class DetermineAssetTargetLocalesProcess
extends DetermineTargetLocalesProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetermineAssetTargetLocalesProcess.class);
    @Reference
    private AssetLanguageCopyManager assetLanguageCopyManager;

    @Override
    public void executeInternal(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        JobWorkflowParameters parameters = new JobWorkflowParameters(workItem);
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        String sourceLocale = parameters.getConfigSourceLocaleCode();
        if (StringUtils.isBlank((CharSequence)sourceLocale)) {
            Resource resource = this.getPayloadResource(workItem, workflowSession);
            sourceLocale = this.assetLanguageCopyManager.getLanguage(resourceResolver, resource.getPath()).getCode();
        }
        SmartlingCloudConfig cloudConfig = this.getSmartlingCloudConfig(workItem, workflowSession);
        StringBuilder skipUpToDateLocalesMessage = new StringBuilder();
        StringBuilder skipNonValidConfigMessage = new StringBuilder();
        TreeSet<String> supportedLocales = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        if (!parameters.getSourcePathList().isEmpty()) {
            supportedLocales = this.getSupportedLocales(sourceLocale, cloudConfig, parameters.getTargetLocaleCodes(), skipNonValidConfigMessage);
        }
        TreeSet<String> actualLocales = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String sourcePath : parameters.getSourcePathList()) {
            Resource sourceResource = resourceResolver.resolve(sourcePath);
            if (parameters.shouldForceResubmission()) {
                WorkflowUtil.setContentLastModifiedNow(sourceResource);
                actualLocales.addAll(supportedLocales);
                continue;
            }
            Set<String> newActualLocales = this.getActualLocales(resourceResolver, this.assetLanguageCopyManager, cloudConfig, sourceResource, supportedLocales, skipUpToDateLocalesMessage);
            actualLocales.addAll(newActualLocales);
        }
        this.putTargetLocales(workItem, actualLocales, skipUpToDateLocalesMessage, skipNonValidConfigMessage);
        if (parameters.shouldForceResubmission()) {
            try {
                ((Session)resourceResolver.adaptTo(Session.class)).save();
            }
            catch (RepositoryException ex) {
                LOGGER.error("Couldn't save changes", (Throwable)ex);
            }
        }
    }

    protected void bindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        this.assetLanguageCopyManager = assetLanguageCopyManager;
    }

    protected void unbindAssetLanguageCopyManager(AssetLanguageCopyManager assetLanguageCopyManager) {
        if (this.assetLanguageCopyManager == assetLanguageCopyManager) {
            this.assetLanguageCopyManager = null;
        }
    }
}

